/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.blocks.entity;

import java.util.List;
import java.util.Map;
import net.jcm.vsch.blocks.entity.VSCHBlockEntities;
import net.jcm.vsch.blocks.thruster.AbstractThrusterBlockEntity;
import net.jcm.vsch.blocks.thruster.ThrusterEngine;
import net.jcm.vsch.blocks.thruster.ThrusterEngineContext;
import net.jcm.vsch.config.VSCHServerConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ThrusterBlockEntity
extends AbstractThrusterBlockEntity {
    public ThrusterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)VSCHBlockEntities.THRUSTER_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    protected String getPeripheralType() {
        return "thruster";
    }

    @Override
    protected ThrusterEngine createThrusterEngine() {
        return new NormalThrusterEngine((int)((Integer)VSCHServerConfig.THRUSTER_ENERGY_CONSUME_RATE.get()), (float)((Number)VSCHServerConfig.THRUSTER_STRENGTH.get()).intValue(), VSCHServerConfig.getThrusterFuelConsumeRates());
    }

    @Override
    protected double getEvaporateDistance() {
        return 8.0 * this.getCurrentPower();
    }

    private static final class NormalThrusterEngine
    extends ThrusterEngine {
        private final Map<String, Integer> fuelConsumeRates;

        public NormalThrusterEngine(int energyConsumeRate, float maxThrottle, Map<String, Integer> fuelConsumeRates) {
            super(1, energyConsumeRate, maxThrottle);
            this.fuelConsumeRates = fuelConsumeRates;
        }

        @Override
        public boolean isValidFuel(int tank, Fluid fluid) {
            String fluidName = BuiltInRegistries.f_257020_.m_7981_((Object)fluid).toString();
            return this.fuelConsumeRates.containsKey(fluidName);
        }

        @Override
        public void tick(ThrusterEngineContext context) {
            super.tick(context);
            if (this.fuelConsumeRates.size() == 0) {
                return;
            }
            double power = context.getPower();
            if (power == 0.0) {
                return;
            }
            Fluid fluid = context.getFluidHandler().getFluidInTank(0).getFluid();
            if (fluid == Fluids.f_76191_) {
                context.setPower(0.0);
                return;
            }
            String fluidName = BuiltInRegistries.f_257020_.m_7981_((Object)fluid).toString();
            int consumeRate = this.fuelConsumeRates.get(fluidName);
            if (consumeRate == 0) {
                return;
            }
            double scale = context.getScale();
            int amount = context.getAmount();
            int needsFuel = (int)Math.ceil((double)consumeRate * power * scale * (double)amount);
            int avaliableFuel = context.getFluidHandler().drain(new FluidStack(fluid, needsFuel), IFluidHandler.FluidAction.SIMULATE).getAmount();
            context.setPower((double)avaliableFuel / (double)(consumeRate * amount));
            context.addConsumer(ctx -> ctx.getFluidHandler().drain(new FluidStack(fluid, (int)Math.ceil((double)consumeRate * ctx.getPower() * ctx.getScale() * (double)ctx.getAmount())), IFluidHandler.FluidAction.EXECUTE));
        }

        @Override
        public void tickBurningObjects(ThrusterEngineContext context, List<BlockPos> thrusters, Direction direction) {
            NormalThrusterEngine.simpleTickBurningObjects(context, thrusters, direction, 8.0, 3, 0.1);
        }
    }
}

