/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.blocks.thruster;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ThrusterEngineContext {
    private final ServerLevel level;
    private final IEnergyStorage energy;
    private final IFluidHandler tanks;
    private final List<EngineConsumeAction> consumers = new ArrayList<EngineConsumeAction>(2);
    private final int amount;
    private final double scale;
    private double power;
    private boolean rejected = false;

    public ThrusterEngineContext(ServerLevel level, IEnergyStorage energy, IFluidHandler tanks, double power, int amount, double scale) {
        this.level = level;
        this.energy = energy;
        this.tanks = tanks;
        this.power = power;
        this.amount = amount;
        this.scale = scale;
    }

    public void reject() {
        this.rejected = true;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energy;
    }

    public IFluidHandler getFluidHandler() {
        return this.tanks;
    }

    public void addConsumer(EngineConsumeAction consumer) {
        this.consumers.add(consumer);
    }

    public double getPower() {
        return this.power;
    }

    public void setPower(double power) {
        this.power = power;
    }

    public int getAmount() {
        return this.amount;
    }

    public double getScale() {
        return this.scale;
    }

    void consume() {
        for (EngineConsumeAction consumer : this.consumers) {
            consumer.consume(this);
        }
    }

    @FunctionalInterface
    public static interface EngineConsumeAction {
        public void consume(ThrusterEngineContext var1);
    }
}

