/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.jcm.vsch.api.resource.ModelTextures;
import net.jcm.vsch.api.resource.TextureLocation;
import net.jcm.vsch.blocks.entity.GyroBlockEntity;
import net.jcm.vsch.client.RenderUtil;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.joml.Vector4f;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class GyroRenderer
implements BlockEntityRenderer<GyroBlockEntity> {
    private static final Vector4f ONE4 = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private static final Vector3f HALF3 = new Vector3f(0.5f, 0.5f, 0.5f);
    private static final Vector3i CORE_SIZE = new Vector3i(6, 6, 6);
    private static final ModelTextures CORE_MODEL;
    private final BlockEntityRendererProvider.Context ctx;

    public GyroRenderer(BlockEntityRendererProvider.Context ctx) {
        this.ctx = ctx;
    }

    public void render(GyroBlockEntity be, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)be.m_58904_(), (BlockPos)be.m_58899_());
        RenderUtil.BoxLightMap lightMap = new RenderUtil.BoxLightMap().setAll(packedLight);
        Quaternionf rot = be.getCoreRotation(partialTick);
        if (ship != null) {
            rot.mul((Quaternionfc)new Quaternionf().setFromNormalized(ship.getShipToWorld()).conjugate()).normalize();
        }
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110466_());
        RenderUtil.drawBoxWithTexture(poseStack, buffer, lightMap, CORE_MODEL, ONE4, new Vector3f(), rot, CORE_SIZE, 1.0f);
    }

    static {
        ResourceLocation resource = new ResourceLocation("vsch", "block/gyro");
        CORE_MODEL = new ModelTextures(TextureLocation.fromNonStandardSize(resource, 12, 44, 128), TextureLocation.fromNonStandardSize(resource, 6, 44, 128), TextureLocation.fromNonStandardSize(resource, 6, 50, 128), TextureLocation.fromNonStandardSize(resource, 18, 50, 128), TextureLocation.fromNonStandardSize(resource, 12, 50, 128), TextureLocation.fromNonStandardSize(resource, 0, 50, 128));
    }
}

