/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.event;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import net.jcm.vsch.util.VSCHUtils;
import net.jcm.vsch.util.wapi.LevelData;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import org.valkyrienskies.core.impl.game.ships.ShipObjectServer;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class GravityInducer
implements ShipForcesInducer {
    private String dimension = null;
    private volatile double gravity = 0.0;

    public void applyForces(@NotNull PhysShip physShip) {
        double gravityForce = (1.0 - this.gravity) * 10.0 * ((PhysShipImpl)physShip).getInertia().getShipMass();
        if (!Double.isFinite(gravityForce)) {
            return;
        }
        physShip.applyInvariantForce((Vector3dc)new Vector3d(0.0, gravityForce, 0.0));
    }

    public static GravityInducer tickOnShip(LoadedServerShip ship) {
        GravityInducer attachment;
        ShipObjectServer shipObject;
        if (ship instanceof ShipObjectServer && (shipObject = (ShipObjectServer)ship).getShipData().getAttachment(GravityInducer.class) != null) {
            shipObject.saveAttachment(GravityInducer.class, null);
        }
        if ((attachment = (GravityInducer)ship.getAttachment(GravityInducer.class)) == null) {
            attachment = new GravityInducer();
            ship.setAttachment(GravityInducer.class, (Object)attachment);
        }
        String shipDim = ship.getChunkClaimDimension();
        if (attachment.dimension == null) {
            attachment.dimension = shipDim;
            attachment.gravity = LevelData.get((Level)VSCHUtils.registeryDimToLevel(shipDim)).getGravity();
        }
        return attachment;
    }
}

