/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.ship.thruster;

import net.jcm.vsch.config.VSCHServerConfig;
import net.jcm.vsch.ship.IVSCHForceApplier;
import net.jcm.vsch.ship.thruster.ThrusterData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class ThrusterForceApplier
implements IVSCHForceApplier {
    private final ThrusterData data;

    public ThrusterData getData() {
        return this.data;
    }

    public ThrusterForceApplier(ThrusterData data) {
        this.data = data;
    }

    @Override
    public void applyForces(BlockPos pos, PhysShipImpl physShip) {
        double throttle = this.data.throttle;
        if (throttle == 0.0) {
            return;
        }
        ShipTransform transform = physShip.getTransform();
        Vector3d tForce = transform.getShipToWorld().transformDirection(this.data.dir.div(transform.getShipToWorldScaling(), new Vector3d()));
        tForce.mul(throttle);
        Vector3dc linearVelocity = physShip.getPoseVel().getVel();
        if (((Boolean)VSCHServerConfig.LIMIT_SPEED.get()).booleanValue()) {
            double dotProduct;
            int maxSpeed = ((Number)VSCHServerConfig.MAX_SPEED.get()).intValue();
            if (Math.abs(linearVelocity.length()) >= (double)maxSpeed && (dotProduct = tForce.dot(linearVelocity)) > 0.0) {
                if (this.data.mode == ThrusterData.ThrusterMode.GLOBAL) {
                    ThrusterForceApplier.applyScaledForce(physShip, linearVelocity, tForce, maxSpeed);
                } else {
                    Vector3d tPos = VectorConversionsMCKt.toJOMLD((Vec3i)pos).add(0.5, 0.5, 0.5, new Vector3d()).sub(transform.getPositionInShip());
                    Vector3d parallel = new Vector3d((Vector3dc)tPos).mul(tForce.dot((Vector3dc)tPos) / tForce.dot((Vector3dc)tForce));
                    Vector3d perpendicular = new Vector3d((Vector3dc)tForce).sub((Vector3dc)parallel);
                    physShip.applyInvariantForceToPos((Vector3dc)perpendicular, (Vector3dc)tPos);
                    ThrusterForceApplier.applyScaledForce(physShip, linearVelocity, parallel, maxSpeed);
                }
                return;
            }
        }
        if (this.data.mode == ThrusterData.ThrusterMode.POSITION) {
            Vector3d tPos = VectorConversionsMCKt.toJOMLD((Vec3i)pos).add(0.5, 0.5, 0.5, new Vector3d()).sub(transform.getPositionInShip());
            physShip.applyInvariantForceToPos((Vector3dc)tForce, (Vector3dc)tPos);
        } else {
            physShip.applyInvariantForce((Vector3dc)tForce);
        }
    }

    private static void applyScaledForce(PhysShipImpl physShip, Vector3dc linearVelocity, Vector3d tForce, int maxSpeed) {
        assert (ValkyrienSkiesMod.getCurrentServer() != null);
        double deltaTime = 0.016666666666666666;
        double mass = physShip.getInertia().getShipMass();
        Vector3d targetVelocity = new Vector3d(linearVelocity).add((Vector3dc)new Vector3d((Vector3dc)tForce).mul(deltaTime / mass)).normalize((double)maxSpeed).sub(linearVelocity);
        physShip.applyInvariantForce((Vector3dc)targetVelocity.mul(mass / deltaTime));
    }
}

