/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.util.rot;

import net.jcm.vsch.util.rot.RotShape;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DirectionalShape {
    private final VoxelShape north;
    private final VoxelShape east;
    private final VoxelShape south;
    private final VoxelShape west;
    private final VoxelShape up;
    private final VoxelShape down;

    private DirectionalShape(RotShape shape) {
        this.north = shape.build();
        this.east = shape.rotate90().build();
        this.south = shape.rotate180().build();
        this.west = shape.rotate270().build();
        this.up = shape.xrotate90().build();
        this.down = shape.xrotate270().build();
    }

    public VoxelShape get(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> this.north;
            case Direction.EAST -> this.east;
            case Direction.SOUTH -> this.south;
            case Direction.WEST -> this.west;
            case Direction.UP -> this.up;
            case Direction.DOWN -> this.down;
        };
    }

    public static DirectionalShape north(RotShape shape) {
        return new DirectionalShape(shape);
    }

    public static DirectionalShape east(RotShape shape) {
        return new DirectionalShape(shape.rotate270());
    }

    public static DirectionalShape south(RotShape shape) {
        return new DirectionalShape(shape.rotate180());
    }

    public static DirectionalShape west(RotShape shape) {
        return new DirectionalShape(shape.rotate90());
    }

    public static DirectionalShape up(RotShape shape) {
        return new DirectionalShape(shape.xrotate270());
    }

    public static DirectionalShape down(RotShape shape) {
        return new DirectionalShape(shape.xrotate90());
    }
}

