/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.util.wapi;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.jcm.vsch.accessor.ILevelAccessor;
import net.jcm.vsch.util.wapi.PlanetData;
import net.lointain.cosmos.network.CosmosModVariables;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Vector3d;

public class LevelData {
    private static final Logger LOGGER = LogManager.getLogger((String)"vsch");
    private static final double SQRT1_2 = Math.sqrt(0.5);
    private final ResourceKey<Level> dimension;
    private final String type;
    private double gravity = 1.0;
    private double friction = 0.98;
    private ResourceKey<Level> upperDimension = null;
    private double atmosphereY = 0.0;
    private final Map<ResourceKey<Level>, PlanetData> lowerDimensions = new HashMap<ResourceKey<Level>, PlanetData>(0);

    private LevelData(ResourceKey<Level> dimension, String type) {
        this.dimension = dimension;
        this.type = type;
    }

    public static LevelData get(Level level) {
        if (level instanceof ILevelAccessor) {
            ILevelAccessor levelAccessor = (ILevelAccessor)level;
            return levelAccessor.starlance$getLevelData();
        }
        return LevelData.get0(level);
    }

    public static LevelData get0(Level level) {
        return LevelData.get1(CosmosModVariables.WorldVariables.get((LevelAccessor)level), (ResourceKey<Level>)level.m_46472_(), new HashMap<ResourceKey<Level>, LevelData>());
    }

    private static LevelData get1(CosmosModVariables.WorldVariables worldVars, ResourceKey<Level> dimension, Map<ResourceKey<Level>, LevelData> parsing) {
        CompoundTag atmoData;
        LevelData parsingData = parsing.get(dimension);
        if (parsingData != null) {
            return parsingData;
        }
        String dimensionStr = dimension.m_135782_().toString();
        LevelData data = new LevelData(dimension, worldVars.dimension_type.m_128461_(dimensionStr));
        parsing.put(dimension, data);
        if (worldVars.gravity_data.m_128441_(dimensionStr)) {
            data.gravity = worldVars.gravity_data.m_128459_(dimensionStr);
        }
        if (worldVars.friction_data.m_128441_(dimensionStr)) {
            data.friction = worldVars.friction_data.m_128459_(dimensionStr);
        }
        if ((atmoData = worldVars.atmospheric_collision_data_map.m_128469_(dimensionStr)).m_128441_("travel_to")) {
            data.upperDimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(atmoData.m_128461_("travel_to")));
            data.atmosphereY = atmoData.m_128459_("atmosphere_y");
        }
        ListTag collisionDatas = worldVars.collision_data_map.m_128437_(dimensionStr, 10);
        for (int i = 0; i < collisionDatas.size(); ++i) {
            CompoundTag collisionData = collisionDatas.m_128728_(i);
            String planetDimension = collisionData.m_128461_("travel_to");
            if (planetDimension.isEmpty()) {
                LOGGER.error("[starlance]: Planet {} in {} has no travel_to dimension. Please report this! Planet data: {}", (Object)collisionData.m_128461_("object_name"), (Object)dimensionStr, (Object)collisionData);
                continue;
            }
            ResourceKey planetDim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(planetDimension));
            if (data.lowerDimensions.containsKey(planetDim)) {
                LOGGER.error("[starlance]: Dimension {} has two planets! Only one is allowed.", (Object)planetDim.m_135782_());
                continue;
            }
            PlanetData planet = PlanetData.create(LevelData.get1(worldVars, (ResourceKey<Level>)planetDim, parsing), (id, updater) -> {}, collisionData);
            data.lowerDimensions.put((ResourceKey<Level>)planetDim, planet);
        }
        return data;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public String getType() {
        return this.type;
    }

    public boolean isSpace() {
        return "space".equals(this.type);
    }

    public boolean isPlanet() {
        return "planet".equals(this.type);
    }

    public double getGravity() {
        return this.gravity;
    }

    public double getFriction() {
        return this.friction;
    }

    public double getAtmosphereY() {
        return this.atmosphereY;
    }

    public ResourceKey<Level> getUpperDimension() {
        return this.upperDimension;
    }

    public boolean hasPlanets() {
        return !this.lowerDimensions.isEmpty();
    }

    public Collection<PlanetData> getPlanets() {
        return this.lowerDimensions.values();
    }

    public PlanetData getPlanet(ResourceKey<Level> level) {
        return this.lowerDimensions.get(level);
    }

    public ClosestPlanetData getNearestPlanet(Vec3 pos) {
        ClosestPlanetData nearestPlanet = null;
        for (PlanetData planet : this.lowerDimensions.values()) {
            Direction farthestAxis;
            Vec3 planetPos = planet.getPosition();
            Vector3d relDir = new Vector3d(pos.f_82479_ - planetPos.f_82479_, pos.f_82480_ - planetPos.f_82480_, pos.f_82481_ - planetPos.f_82481_);
            planet.getRotation().transformInverse(relDir);
            double dx = Math.abs(relDir.x);
            double dy = Math.abs(relDir.y);
            double dz = Math.abs(relDir.z);
            double farthestDist = dy;
            Direction direction = farthestAxis = relDir.y < 0.0 ? Direction.DOWN : Direction.UP;
            if (dx > Math.abs(farthestDist)) {
                farthestDist = dx;
                Direction direction2 = farthestAxis = relDir.x < 0.0 ? Direction.WEST : Direction.EAST;
            }
            if (dz > Math.abs(farthestDist)) {
                farthestDist = dz;
                Direction direction3 = farthestAxis = relDir.z < 0.0 ? Direction.NORTH : Direction.SOUTH;
            }
            if (nearestPlanet != null && !(farthestDist < nearestPlanet.distance())) continue;
            nearestPlanet = new ClosestPlanetData(planet, Math.max(farthestDist - planet.getSize() / 2.0, 0.0), farthestAxis);
        }
        return nearestPlanet;
    }

    public record ClosestPlanetData(PlanetData planet, double distance, Direction direction) {
    }
}

