/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch;

import net.jcm.vsch.config.VSCHCommonConfig;
import net.jcm.vsch.event.AtmosphericCollision;
import net.jcm.vsch.event.GravityInducer;
import net.jcm.vsch.event.PlanetCollision;
import net.jcm.vsch.util.EmptyChunkAccess;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.impl.config.VSCoreConfig;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Mod.EventBusSubscriber
public class VSCHEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        switch (event.phase) {
            case START: {
                for (LoadedServerShip ship : VSGameUtilsKt.getShipObjectWorld((MinecraftServer)event.getServer()).getLoadedShips()) {
                    GravityInducer.tickOnShip(ship);
                }
                break;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        switch (event.phase) {
            case START: {
                break;
            }
            case END: {
                if (serverLevel.m_261156_(player -> true, 1).isEmpty()) {
                    return;
                }
                AtmosphericCollision.atmosphericCollisionTick(serverLevel);
                PlanetCollision.planetCollisionTick(serverLevel);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        ChunkPos pos = new ChunkPos(event.getPos());
        if (EmptyChunkAccess.shouldUseEmptyChunk(level, pos.f_45578_, pos.f_45579_)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent joinEvent) {
        if (VSCoreConfig.SERVER.getPhysics().getLodDetail() >= 4096) {
            return;
        }
        if (((Boolean)VSCHCommonConfig.DISABLE_LOD_WARNING.get()).booleanValue()) {
            return;
        }
        Player player = joinEvent.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player2.m_213846_((Component)Component.m_237110_((String)"vsch.lod_warning", (Object[])new Object[]{VSCoreConfig.SERVER.getPhysics().getLodDetail()}).m_130940_(ChatFormatting.YELLOW));
        }
    }
}

