/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.blocks.custom;

import java.util.List;
import net.jcm.vsch.blocks.entity.template.ParticleBlockEntity;
import net.jcm.vsch.blocks.thruster.AbstractThrusterBlockEntity;
import net.jcm.vsch.ship.VSCHForceInducedShips;
import net.jcm.vsch.util.VSCHUtils;
import net.jcm.vsch.util.rot.DirectionalShape;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BaseThrusterBlock<T extends AbstractThrusterBlockEntity>
extends DirectionalBlock
implements EntityBlock {
    public static final BooleanProperty LIT = RedstoneTorchBlock.f_55674_;
    private final DirectionalShape shape;
    private final BlockEntityType.BlockEntitySupplier<? extends T> blockEntitySupplier;

    public BaseThrusterBlock(BlockBehaviour.Properties properties, DirectionalShape shape, BlockEntityType.BlockEntitySupplier<? extends T> blockEntitySupplier) {
        super(properties);
        this.shape = shape;
        this.blockEntitySupplier = blockEntitySupplier;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_});
        builder.m_61104_(new Property[]{LIT});
        super.m_7926_(builder);
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape.get((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_));
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add(VSCHUtils.getWarningComponent());
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, level, pos, newState, isMoving);
        if (!(level instanceof ServerLevel)) {
            return;
        }
        VSCHForceInducedShips ships = VSCHForceInducedShips.get(level, pos);
        if (ships != null) {
            ships.removeThruster(pos);
        }
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction dir = ctx.m_7820_();
        if (ctx.m_7078_()) {
            dir = dir.m_122424_();
        }
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)dir);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block neighbor, BlockPos neighborPos, boolean moving) {
        super.m_6861_(state, world, pos, neighbor, neighborPos, moving);
        AbstractThrusterBlockEntity be = (AbstractThrusterBlockEntity)world.m_7702_(pos);
        be.neighborChanged(neighbor, neighborPos, moving);
    }

    public T newBlockEntity(BlockPos pos, BlockState state) {
        return (T)((AbstractThrusterBlockEntity)this.blockEntitySupplier.m_155267_(pos, state));
    }

    public <U extends BlockEntity> BlockEntityTicker<U> m_142354_(Level level, BlockState state, BlockEntityType<U> type) {
        return level.m_5776_() ? ParticleBlockEntity::clientTick : ParticleBlockEntity::serverTick;
    }
}

