/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.blocks.entity;

import dan200.computercraft.shared.Capabilities;
import net.jcm.vsch.blocks.entity.VSCHBlockEntities;
import net.jcm.vsch.blocks.entity.template.ParticleBlockEntity;
import net.jcm.vsch.compat.CompatMods;
import net.jcm.vsch.compat.cc.peripherals.DragInducerPeripheral;
import net.jcm.vsch.ship.VSCHForceInducedShips;
import net.jcm.vsch.ship.dragger.DraggerData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class DragInducerBlockEntity
extends BlockEntity
implements ParticleBlockEntity {
    private final DraggerData draggerData;
    private volatile boolean enabled = false;
    private volatile boolean isPeripheralMode = false;
    private boolean wasPeripheralMode = true;
    private LazyOptional<Object> lazyPeripheral = LazyOptional.empty();

    public DragInducerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)VSCHBlockEntities.DRAG_INDUCER_BLOCK_ENTITY.get(), pos, state);
        this.draggerData = new DraggerData(false);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, true);
    }

    protected void setEnabled(boolean enabled, boolean update) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        if (update) {
            this.m_6596_();
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 11);
        }
    }

    public boolean getPeripheralMode() {
        return this.isPeripheralMode;
    }

    public void setPeripheralMode(boolean on) {
        if (this.isPeripheralMode != on) {
            this.isPeripheralMode = on;
            this.m_6596_();
        }
    }

    public void m_142466_(CompoundTag data) {
        this.setEnabled(data.m_128471_("Enabled"), false);
        this.isPeripheralMode = CompatMods.COMPUTERCRAFT.isLoaded() && data.m_128471_("PeripheralMode");
        this.draggerData.on = this.isEnabled();
        super.m_142466_(data);
    }

    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        data.m_128379_("Enabled", this.isEnabled());
        data.m_128379_("PeripheralMode", this.getPeripheralMode());
    }

    public CompoundTag m_5995_() {
        CompoundTag data = super.m_5995_();
        data.m_128379_("Enabled", this.isEnabled());
        return data;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction direction) {
        if (CompatMods.COMPUTERCRAFT.isLoaded() && cap == Capabilities.CAPABILITY_PERIPHERAL) {
            if (!this.lazyPeripheral.isPresent()) {
                this.lazyPeripheral = LazyOptional.of(() -> new DragInducerPeripheral(this));
            }
            return this.lazyPeripheral.cast();
        }
        return super.getCapability(cap, direction);
    }

    public void neighborChanged(Block block, BlockPos pos, boolean moving) {
        if (!this.isPeripheralMode) {
            this.updateEnabledByRedstone();
        }
    }

    @Override
    public void tickForce(ServerLevel level, BlockPos pos, BlockState state) {
        if (this.wasPeripheralMode != this.isPeripheralMode && !this.isPeripheralMode) {
            this.updateEnabledByRedstone();
        }
        this.wasPeripheralMode = this.isPeripheralMode;
        if (this.isEnabled() != this.draggerData.on) {
            this.draggerData.on = this.isEnabled();
        }
        int signal = level.m_277086_(pos);
        VSCHForceInducedShips ships = VSCHForceInducedShips.get((Level)level, pos);
        if (ships == null) {
            return;
        }
        if (ships.getDraggerAtPos(pos) != this.draggerData) {
            ships.addDragger(pos, this.draggerData);
        }
    }

    private void updateEnabledByRedstone() {
        this.setEnabled(DragInducerBlockEntity.getEnabledByRedstone(this.m_58904_(), this.m_58899_()));
    }

    @Override
    public void tickParticles(Level level, BlockPos pos, BlockState state) {
    }

    private static boolean getEnabledByRedstone(Level level, BlockPos pos) {
        return level.m_277086_(pos) > 0;
    }
}

