/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.blocks.entity;

import dan200.computercraft.shared.Capabilities;
import net.jcm.vsch.blocks.custom.template.WrenchableBlock;
import net.jcm.vsch.blocks.entity.VSCHBlockEntities;
import net.jcm.vsch.blocks.entity.template.ParticleBlockEntity;
import net.jcm.vsch.compat.CompatMods;
import net.jcm.vsch.compat.cc.peripherals.GyroPeripheral;
import net.jcm.vsch.config.VSCHServerConfig;
import net.jcm.vsch.ship.VSCHForceInducedShips;
import net.jcm.vsch.ship.gyro.GyroData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;

public class GyroBlockEntity
extends BlockEntity
implements ParticleBlockEntity,
WrenchableBlock {
    private final GyroData data;
    private final EnergyStorage energyStorage;
    private final Quaternionf rotation = new Quaternionf();
    private final Quaternionf rotationO = new Quaternionf();
    private volatile double torqueX = 0.0;
    private volatile double torqueY = 0.0;
    private volatile double torqueZ = 0.0;
    private int percentPower = 100;
    private volatile boolean isPeripheralMode = false;
    private boolean wasPeripheralMode = true;
    private LazyOptional<Object> lazyPeripheral = LazyOptional.empty();

    public GyroBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)VSCHBlockEntities.GYRO_BLOCK_ENTITY.get(), pos, state);
        this.data = new GyroData(new Vector3d());
        this.energyStorage = new EnergyStorage((Integer)VSCHServerConfig.GYRO_ENERGY_CONSUME_RATE.get());
    }

    public double getTorqueForce() {
        return ((Number)VSCHServerConfig.GYRO_STRENGTH.get()).doubleValue();
    }

    public double getTorqueX() {
        return this.torqueX;
    }

    public void setTorqueX(double x) {
        if (this.torqueX == (x = Math.min(Math.max(x, -1.0), 1.0))) {
            return;
        }
        this.torqueX = x;
        this.m_6596_();
    }

    public double getTorqueY() {
        return this.torqueY;
    }

    public void setTorqueY(double y) {
        if (this.torqueY == (y = Math.min(Math.max(y, -1.0), 1.0))) {
            return;
        }
        this.torqueY = y;
        this.m_6596_();
    }

    public double getTorqueZ() {
        return this.torqueZ;
    }

    public void setTorqueZ(double z) {
        if (this.torqueZ == (z = Math.min(Math.max(z, -1.0), 1.0))) {
            return;
        }
        this.torqueZ = z;
        this.m_6596_();
    }

    public void resetTorque() {
        this.torqueX = 0.0;
        this.torqueY = 0.0;
        this.torqueZ = 0.0;
        this.m_6596_();
    }

    public double[] getTorque() {
        return new double[]{this.torqueX, this.torqueY, this.torqueZ};
    }

    public void setTorque(double x, double y, double z) {
        this.torqueX = Math.min(Math.max(x, -1.0), 1.0);
        this.torqueY = Math.min(Math.max(y, -1.0), 1.0);
        this.torqueZ = Math.min(Math.max(z, -1.0), 1.0);
        this.m_6596_();
    }

    public int getPercentPower() {
        return this.percentPower;
    }

    public void setPercentPower(int power) {
        if (power < 0 || power > 100) {
            throw new IllegalArgumentException("power out of range [0, 100]");
        }
        if (this.percentPower == (power = (int)Math.round((double)power / 10.0) * 10)) {
            return;
        }
        this.percentPower = power;
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public boolean getPeripheralMode() {
        return this.isPeripheralMode;
    }

    public void setPeripheralMode(boolean on) {
        if (this.isPeripheralMode != on) {
            this.isPeripheralMode = on;
            this.m_6596_();
        }
    }

    public Quaternionf getCoreRotation(float partialTick) {
        return this.rotationO.slerp((Quaternionfc)this.rotation, partialTick, new Quaternionf());
    }

    @Override
    public void tickForce(ServerLevel level, BlockPos pos, BlockState state) {
        VSCHForceInducedShips ships;
        if (this.wasPeripheralMode != this.isPeripheralMode && !this.isPeripheralMode) {
            this.updatePowerByRedstone();
        }
        this.wasPeripheralMode = this.isPeripheralMode;
        Vector3d torque = new Vector3d(this.torqueX, this.torqueY, this.torqueZ);
        if (this.energyStorage.maxEnergy > 0) {
            double requirePower = (Math.abs(torque.x) + Math.abs(torque.y) + Math.abs(torque.z)) * (double)this.energyStorage.maxEnergy / 3.0;
            double availablePower = this.energyStorage.storedEnergy;
            if (availablePower <= 0.0) {
                torque.zero();
            } else if (requirePower > availablePower) {
                torque.mul(availablePower / requirePower);
                this.energyStorage.storedEnergy = 0;
            } else {
                this.energyStorage.storedEnergy = (int)((double)this.energyStorage.storedEnergy - requirePower);
            }
        }
        double force = this.getTorqueForce();
        this.data.torque.set(torque.x * force, torque.y * force, torque.z * force);
        if (torque.x != 0.0 || torque.y != 0.0 || torque.z != 0.0) {
            this.m_6596_();
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            if (force != 0.0) {
                torque.mul(-force * Math.PI * 1.0E-6);
                this.rotation.conjugate(new Quaternionf()).transform(torque);
                float angle = (float)torque.length();
                torque.normalize();
                this.rotation.mul((Quaternionfc)new Quaternionf().fromAxisAngleRad((float)torque.x, (float)torque.y, (float)torque.z, angle)).normalize();
            }
        }
        if ((ships = VSCHForceInducedShips.get((Level)level, pos)) == null) {
            return;
        }
        if (ships.getGyroAtPos(pos) != this.data) {
            ships.addGyro(pos, this.data);
        }
    }

    @Override
    public InteractionResult onUseWrench(UseOnContext ctx) {
        if (ctx.m_43724_() != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        int newPower = (this.getPercentPower() / 10 + 1) * 10;
        if (newPower > 100) {
            newPower = 10;
        }
        this.setPercentPower(newPower);
        Player player = ctx.m_43723_();
        if (player != null) {
            player.m_5661_((Component)Component.m_237110_((String)"vsch.message.gyro", (Object[])new Object[]{this.getPercentPower()}), true);
        }
        this.updatePowerByRedstone();
        return InteractionResult.SUCCESS;
    }

    @Override
    public void tickParticles(Level level, BlockPos pos, BlockState state) {
        this.rotationO.set((Quaternionfc)this.rotation);
    }

    public void m_142466_(CompoundTag data) {
        this.energyStorage.storedEnergy = data.m_128451_("Energy");
        this.isPeripheralMode = CompatMods.COMPUTERCRAFT.isLoaded() && data.m_128471_("PeripheralMode");
        this.rotation.set(data.m_128457_("RotateX"), data.m_128457_("RotateY"), data.m_128457_("RotateZ"), data.m_128457_("RotateW"));
        this.torqueX = data.m_128459_("TorqueX");
        this.torqueY = data.m_128459_("TorqueY");
        this.torqueZ = data.m_128459_("TorqueZ");
        this.percentPower = data.m_128451_("PercentPower");
        super.m_142466_(data);
    }

    public void saveShared(CompoundTag data) {
        data.m_128350_("RotateX", this.rotation.x);
        data.m_128350_("RotateY", this.rotation.y);
        data.m_128350_("RotateZ", this.rotation.z);
        data.m_128350_("RotateW", this.rotation.w);
        data.m_128347_("TorqueX", this.torqueX);
        data.m_128347_("TorqueY", this.torqueY);
        data.m_128347_("TorqueZ", this.torqueZ);
        data.m_128405_("PercentPower", this.percentPower);
    }

    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        data.m_128405_("Energy", this.energyStorage.storedEnergy);
        data.m_128379_("PeripheralMode", this.getPeripheralMode());
        this.saveShared(data);
    }

    public CompoundTag m_5995_() {
        CompoundTag data = super.m_5995_();
        this.saveShared(data);
        return data;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction direction) {
        if (cap == ForgeCapabilities.ENERGY) {
            return LazyOptional.of(() -> this.energyStorage).cast();
        }
        if (CompatMods.COMPUTERCRAFT.isLoaded() && cap == Capabilities.CAPABILITY_PERIPHERAL) {
            if (!this.lazyPeripheral.isPresent()) {
                this.lazyPeripheral = LazyOptional.of(() -> new GyroPeripheral(this));
            }
            return this.lazyPeripheral.cast();
        }
        return super.getCapability(cap, direction);
    }

    public void neighborChanged(Block block, BlockPos pos, boolean moving) {
        if (!this.isPeripheralMode) {
            this.updatePowerByRedstone();
        }
    }

    private void updatePowerByRedstone() {
        Level level = this.m_58904_();
        BlockPos pos = this.m_58899_();
        double x = (double)(level.m_277185_(pos.m_122029_(), Direction.EAST) - level.m_277185_(pos.m_122024_(), Direction.WEST)) / 15.0;
        double y = (double)(level.m_277185_(pos.m_7494_(), Direction.UP) - level.m_277185_(pos.m_7495_(), Direction.DOWN)) / 15.0;
        double z = (double)(level.m_277185_(pos.m_122019_(), Direction.SOUTH) - level.m_277185_(pos.m_122012_(), Direction.NORTH)) / 15.0;
        double scale = (double)this.percentPower / 100.0;
        this.setTorque(x * scale, y * scale, z * scale);
    }

    private static final class EnergyStorage
    implements IEnergyStorage {
        final int maxEnergy;
        int storedEnergy;

        EnergyStorage(int maxEnergy) {
            this.maxEnergy = maxEnergy;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int needs = this.maxEnergy - this.storedEnergy;
            if (needs < maxReceive) {
                maxReceive = needs;
            }
            if (!simulate) {
                this.storedEnergy += maxReceive;
            }
            return maxReceive;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return this.storedEnergy;
        }

        public int getMaxEnergyStored() {
            return this.maxEnergy;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

