/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.blocks.thruster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.jcm.vsch.api.block.IVentBlock;
import net.jcm.vsch.blocks.thruster.ThrusterEngineContext;
import net.jcm.vsch.util.NoSourceClipContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3d;
import org.joml.Vector3fc;
import org.joml.primitives.AABBd;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public abstract class ThrusterEngine {
    private static final Random RND = new Random();
    private static final EntityTypeTest<Entity, Entity> ANY_ENTITY_TESTER = new EntityTypeTest<Entity, Entity>(){

        public Entity tryCast(Entity entity) {
            return entity;
        }

        public Class<Entity> m_142225_() {
            return Entity.class;
        }
    };
    private final int tanks;
    private final int energyConsumeRate;
    private final float maxThrottle;

    protected ThrusterEngine(int tanks, int energyConsumeRate, float maxThrottle) {
        this.tanks = tanks;
        this.energyConsumeRate = energyConsumeRate;
        this.maxThrottle = maxThrottle;
    }

    public int getTanks() {
        return this.tanks;
    }

    public int getEnergyConsumeRate() {
        return this.energyConsumeRate;
    }

    public float getMaxThrottle() {
        return this.maxThrottle;
    }

    public boolean isValidFuel(int tank, Fluid fluid) {
        return false;
    }

    public void tick(ThrusterEngineContext context) {
        if (this.energyConsumeRate == 0) {
            return;
        }
        double power = context.getPower();
        if (power == 0.0) {
            return;
        }
        double scale = context.getScale();
        int amount = context.getAmount();
        int needs = (int)Math.ceil((double)this.energyConsumeRate * power * scale * (double)amount);
        int extracted = context.getEnergyStorage().extractEnergy(needs, true);
        context.setPower((double)extracted / ((double)this.energyConsumeRate * (double)amount * scale));
        context.addConsumer(ctx -> ctx.getEnergyStorage().extractEnergy((int)Math.ceil(ctx.getPower() * ctx.getScale() * (double)ctx.getAmount() * (double)this.energyConsumeRate), false));
    }

    public abstract void tickBurningObjects(ThrusterEngineContext var1, List<BlockPos> var2, Direction var3);

    public static void simpleTickBurningObjects(ThrusterEngineContext context, List<BlockPos> thrusters, Direction direction, double maxDistance, int maxBurnDamage, double maxPushVel) {
        int maxBurnTime = 300;
        ServerLevel level = context.getLevel();
        double distance = maxDistance * context.getPower() * context.getScale();
        if (distance <= 0.0) {
            return;
        }
        if (thrusters.isEmpty()) {
            return;
        }
        HashMap<Entity, Double> pendingEntities = new HashMap<Entity, Double>();
        ArrayList entities = new ArrayList();
        ServerShip ship = VSGameUtilsKt.getShipManagingPos((ServerLevel)level, (BlockPos)thrusters.get(0));
        Vector3d directionVec = new Vector3d((Vector3fc)Vec3.m_82528_((Vec3i)direction.m_122436_()).m_252839_());
        if (ship != null) {
            ship.getShipToWorld().transformDirection(directionVec);
        }
        for (BlockPos blockPos : thrusters) {
            Vec3 centerPos = Vec3.m_82512_((Vec3i)blockPos);
            Vec3 centerExtendedPos = centerPos.m_231075_(direction, distance);
            Vec3 centerPosWorld = VSGameUtilsKt.toWorldCoordinates((Level)level, (Vec3)centerPos);
            Vec3 centerExtendedPosWorld = VSGameUtilsKt.toWorldCoordinates((Level)level, (Vec3)centerExtendedPos);
            Vec3 centerFacePos = centerPos.m_231075_(direction, 0.5);
            Vec3 centerFacePosWorld = VSGameUtilsKt.toWorldCoordinates((Level)level, (Vec3)centerFacePos);
            BlockHitResult hitResult = level.m_45547_((ClipContext)new ThrustClipContext(centerPosWorld, centerExtendedPosWorld, blockPos));
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos hitPos = hitResult.m_82425_();
                BlockState blockState = level.m_8055_(hitPos);
                Block hitBlock = blockState.m_60734_();
                FluidState hitFluid = blockState.m_60819_();
                if (hitFluid.m_76178_()) {
                    if (hitBlock instanceof TntBlock) {
                        TntBlock.m_57433_((Level)level, (BlockPos)hitPos);
                        level.m_7731_(hitPos, Blocks.f_50016_.m_49966_(), 11);
                    }
                    Direction.m_235666_().filter(d -> d != hitResult.m_82434_().m_122424_()).map(arg_0 -> ((BlockPos)hitPos).m_121945_(arg_0)).filter(firePos -> {
                        BlockState firePosState = level.m_8055_(firePos);
                        return firePosState.m_60795_() || firePosState.m_247087_();
                    }).filter(firePos -> RND.nextFloat() < 0.025f).forEach(firePos -> level.m_7731_(firePos, BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)firePos), 3));
                } else if (!hitFluid.m_76170_() || hitFluid.m_192917_((Fluid)Fluids.f_76193_)) {
                    if (hitBlock instanceof LiquidBlock) {
                        level.m_7731_(hitPos, Blocks.f_50016_.m_49966_(), 3);
                    } else if (hitBlock instanceof BucketPickup) {
                        BucketPickup pickupable = (BucketPickup)hitBlock;
                        pickupable.m_142598_((LevelAccessor)level, hitPos, blockState);
                    }
                }
            }
            BlockHitResult particleHitResult = level.m_45547_((ClipContext)new ParticleClipContext(centerPosWorld, centerExtendedPosWorld, blockPos));
            double clipDist = distance;
            if (particleHitResult.m_6662_() == HitResult.Type.BLOCK) {
                clipDist = particleHitResult.m_82450_().m_82554_(centerPosWorld);
            }
            Direction.Axis axis = direction.m_122434_();
            Vec3 cornerPos = switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
                case Direction.Axis.Y -> new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_());
                case Direction.Axis.Z -> new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5);
            };
            AABB box = new AABB(cornerPos, cornerPos.m_231075_(direction, clipDist - 0.5).m_82520_((double)axis.m_7863_(0, 1, 1), (double)axis.m_7863_(1, 0, 1), (double)axis.m_7863_(1, 1, 0)));
            level.m_261153_(ANY_ENTITY_TESTER, VSGameUtilsKt.transformAabbToWorld((Level)level, (AABB)box), arg_0 -> ThrusterEngine.lambda$simpleTickBurningObjects$5((Ship)ship, level, box, arg_0), entities);
            for (Entity entity : entities) {
                double dist = entity.m_20191_().m_272282_(centerFacePosWorld);
                pendingEntities.compute(entity, (k, v) -> v == null || dist > v ? dist : v);
            }
            entities.clear();
        }
        for (Map.Entry entry : pendingEntities.entrySet()) {
            Creeper creeper;
            double dist = Math.sqrt((Double)entry.getValue());
            double power = (maxDistance - dist) / maxDistance;
            if (power <= 0.0) continue;
            Entity entity = (Entity)entry.getKey();
            if (entity.m_7752_() != PushReaction.IGNORE) {
                entity.m_246865_(new Vec3(directionVec.x * power * maxPushVel, directionVec.y * power * maxPushVel, directionVec.z * power * maxPushVel));
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
                }
            }
            if (entity.m_5825_()) continue;
            int burnTime = (int)(300.0 * power);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                burnTime = ProtectionEnchantment.m_45138_((LivingEntity)livingEntity, (int)burnTime);
            }
            if (burnTime <= 0) continue;
            if (entity instanceof Creeper && !(creeper = (Creeper)entity).m_32311_()) {
                creeper.m_32312_();
            }
            if (entity.m_20094_() < burnTime) {
                entity.m_7311_(burnTime);
            }
            int burnDamage = 1;
            if (burnTime >= 270) {
                burnDamage = (int)((long)burnDamage + Math.round((double)(maxBurnDamage - burnDamage) * (double)burnTime / 300.0));
            }
            entity.m_6469_(entity.m_269291_().m_269549_(), (float)burnDamage);
        }
    }

    private static /* synthetic */ boolean lambda$simpleTickBurningObjects$5(Ship ship, ServerLevel level, AABB box, Entity entity) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_5833_()) {
            return false;
        }
        if (entity.m_7752_() == PushReaction.IGNORE && entity.m_5825_()) {
            return false;
        }
        if (ship != null && !VSGameUtilsKt.isBlockInShipyard((Level)level, (Vec3)entity.m_20182_())) {
            AABB entityBox = entity.m_20191_();
            AABBd entityBox2 = new AABBd(entityBox.f_82288_, entityBox.f_82289_, entityBox.f_82290_, entityBox.f_82291_, entityBox.f_82292_, entityBox.f_82293_);
            entityBox2.transform(ship.getWorldToShip());
            if (!box.m_82314_(entityBox2.minX, entityBox2.minY, entityBox2.minZ, entityBox2.maxX, entityBox2.maxY, entityBox2.maxZ)) {
                return false;
            }
        }
        return true;
    }

    private static class ThrustClipContext
    extends NoSourceClipContext {
        ThrustClipContext(Vec3 from, Vec3 to, BlockPos source) {
            super(from, to, source);
        }

        @Override
        public VoxelShape m_45694_(BlockState state, BlockGetter level, BlockPos pos) {
            VoxelShape shape = super.m_45694_(state, level, pos);
            if (shape.m_83281_()) {
                return shape;
            }
            Block block = state.m_60734_();
            if (block instanceof IVentBlock) {
                IVentBlock vent = (IVentBlock)block;
                BlockHitResult hitResult = shape.m_83220_(this.m_45702_(), this.m_45693_(), pos);
                if (hitResult != null && vent.canThrustPass(hitResult)) {
                    return Shapes.m_83040_();
                }
            }
            return shape;
        }
    }

    private static class ParticleClipContext
    extends NoSourceClipContext {
        ParticleClipContext(Vec3 from, Vec3 to, BlockPos source) {
            super(from, to, source);
        }

        @Override
        public VoxelShape m_45694_(BlockState state, BlockGetter level, BlockPos pos) {
            if (VSGameUtilsKt.isBlockInShipyard((Level)((Level)level), (BlockPos)pos)) {
                return Shapes.m_83040_();
            }
            VoxelShape shape = super.m_45694_(state, level, pos);
            return shape == Shapes.m_83144_() ? shape : Shapes.m_83040_();
        }

        @Override
        public VoxelShape m_45698_(FluidState state, BlockGetter level, BlockPos pos) {
            return Shapes.m_83040_();
        }
    }
}

