/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.jcm.vsch.api.resource.ModelTextures;
import net.jcm.vsch.api.resource.TextureLocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.joml.Vector4f;

public final class RenderUtil {
    private RenderUtil() {
    }

    public static void drawBox(PoseStack poseStack, VertexConsumer buffer, BoxLightMap lightMap, Vector4f rgba, Vector3i offseti, Quaternionf rot, Vector3i sizei) {
        poseStack.m_85836_();
        Vector3f offset = new Vector3f((Vector3ic)offseti).div(16.0f);
        Vector3f size = new Vector3f((Vector3ic)sizei).div(16.0f);
        poseStack.m_252880_(0.5f, 0.5f, 0.5f);
        poseStack.m_252781_(rot);
        RenderUtil.drawPlane(poseStack, buffer, lightMap, rgba, Direction.UP, offset, size);
        RenderUtil.drawPlane(poseStack, buffer, lightMap, rgba, Direction.DOWN, offset, size);
        RenderUtil.drawPlane(poseStack, buffer, lightMap, rgba, Direction.EAST, offset, size);
        RenderUtil.drawPlane(poseStack, buffer, lightMap, rgba, Direction.WEST, offset, size);
        RenderUtil.drawPlane(poseStack, buffer, lightMap, rgba, Direction.NORTH, offset, size);
        RenderUtil.drawPlane(poseStack, buffer, lightMap, rgba, Direction.SOUTH, offset, size);
        poseStack.m_85849_();
    }

    public static void drawPlane(PoseStack posestack, VertexConsumer buffer, BoxLightMap lightMap, Vector4f rgba, Direction perspective, Vector3f offset, Vector3f size) {
        posestack.m_85836_();
        posestack.m_252880_(offset.x, offset.y, offset.z);
        Matrix4f matrix4f = posestack.m_85850_().m_252922_();
        float sX = size.x;
        float sY = size.y;
        float sZ = size.z;
        sX /= 2.0f;
        sY /= 2.0f;
        sZ /= 2.0f;
        float r = rgba.x;
        float g = rgba.y;
        float b = rgba.z;
        float a = rgba.w;
        switch (perspective) {
            case UP: {
                buffer.m_252986_(matrix4f, -sX, sY, sZ).m_85950_(r, g, b, a).m_85969_(lightMap.usw).m_5752_();
                buffer.m_252986_(matrix4f, sX, sY, sZ).m_85950_(r, g, b, a).m_85969_(lightMap.use).m_5752_();
                buffer.m_252986_(matrix4f, sX, sY, -sZ).m_85950_(r, g, b, a).m_85969_(lightMap.une).m_5752_();
                buffer.m_252986_(matrix4f, -sX, sY, -sZ).m_85950_(r, g, b, a).m_85969_(lightMap.unw).m_5752_();
                break;
            }
            case DOWN: {
                buffer.m_252986_(matrix4f, -sX, -sY, sZ).m_85950_(r, g, b, a).m_85969_(lightMap.dsw).m_5752_();
                buffer.m_252986_(matrix4f, -sX, -sY, -sZ).m_85950_(r, g, b, a).m_85969_(lightMap.dnw).m_5752_();
                buffer.m_252986_(matrix4f, sX, -sY, -sZ).m_85950_(r, g, b, a).m_85969_(lightMap.dne).m_5752_();
                buffer.m_252986_(matrix4f, sX, -sY, sZ).m_85950_(r, g, b, a).m_85969_(lightMap.dse).m_5752_();
                break;
            }
            case SOUTH: {
                buffer.m_252986_(matrix4f, sX, -sY, sZ).m_85950_(r, g, b, a).m_85969_(lightMap.sdw).m_5752_();
                buffer.m_252986_(matrix4f, -sX, -sY, sZ).m_85950_(r, g, b, a).m_85969_(lightMap.sde).m_5752_();
                buffer.m_252986_(matrix4f, -sX, sY, sZ).m_85950_(r, g, b, a).m_85969_(lightMap.suw).m_5752_();
                buffer.m_252986_(matrix4f, sX, sY, sZ).m_85950_(r, g, b, a).m_85969_(lightMap.sue).m_5752_();
                break;
            }
            case NORTH: {
                buffer.m_252986_(matrix4f, sX, -sY, -sZ).m_85950_(r, g, b, a).m_85969_(lightMap.nde).m_5752_();
                buffer.m_252986_(matrix4f, sX, sY, -sZ).m_85950_(r, g, b, a).m_85969_(lightMap.nue).m_5752_();
                buffer.m_252986_(matrix4f, -sX, sY, -sZ).m_85950_(r, g, b, a).m_85969_(lightMap.nuw).m_5752_();
                buffer.m_252986_(matrix4f, -sX, -sY, -sZ).m_85950_(r, g, b, a).m_85969_(lightMap.ndw).m_5752_();
                break;
            }
            case EAST: {
                buffer.m_252986_(matrix4f, sX, -sY, -sZ).m_85950_(r, g, b, a).m_85969_(lightMap.edn).m_5752_();
                buffer.m_252986_(matrix4f, sX, sY, -sZ).m_85950_(r, g, b, a).m_85969_(lightMap.eun).m_5752_();
                buffer.m_252986_(matrix4f, sX, sY, sZ).m_85950_(r, g, b, a).m_85969_(lightMap.eus).m_5752_();
                buffer.m_252986_(matrix4f, sX, -sY, sZ).m_85950_(r, g, b, a).m_85969_(lightMap.eds).m_5752_();
                break;
            }
            case WEST: {
                buffer.m_252986_(matrix4f, -sX, -sY, -sZ).m_85950_(r, g, b, a).m_85969_(lightMap.wdn).m_5752_();
                buffer.m_252986_(matrix4f, -sX, -sY, sZ).m_85950_(r, g, b, a).m_85969_(lightMap.wds).m_5752_();
                buffer.m_252986_(matrix4f, -sX, sY, sZ).m_85950_(r, g, b, a).m_85969_(lightMap.wus).m_5752_();
                buffer.m_252986_(matrix4f, -sX, sY, -sZ).m_85950_(r, g, b, a).m_85969_(lightMap.wun).m_5752_();
            }
        }
        posestack.m_85849_();
    }

    public static void drawBoxWithTexture(PoseStack poseStack, VertexConsumer buffer, BoxLightMap lightMap, ModelTextures model, Vector3f rgb, Vector3f offset, Quaternionf rot, Vector3i size, float scale) {
        RenderUtil.drawBoxWithTexture(poseStack, buffer, lightMap, model, new Vector4f((Vector3fc)rgb, 1.0f), offset, rot, size, scale);
    }

    public static void drawBoxWithTexture(PoseStack poseStack, VertexConsumer buffer, BoxLightMap lightMap, ModelTextures model, Vector4f rgba, Vector3f offset, Quaternionf rot, Vector3i size, float scale) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.5f, 0.5f);
        poseStack.m_252781_(rot);
        for (Direction dir : Direction.values()) {
            RenderUtil.drawPlaneWithTexture(poseStack, buffer, lightMap, model.getTexture(dir), rgba, dir, offset, size, scale);
        }
        poseStack.m_85849_();
    }

    public static void drawPlaneWithTexture(PoseStack poseStack, VertexConsumer buffer, BoxLightMap lightMap, TextureLocation texture, Vector3f rgb, Direction perspective, Vector3f offset, Vector3i size, float scale) {
        RenderUtil.drawPlaneWithTexture(poseStack, buffer, lightMap, texture, new Vector4f((Vector3fc)rgb, 1.0f), perspective, offset, size, scale);
    }

    public static void drawPlaneWithTexture(PoseStack poseStack, VertexConsumer buffer, BoxLightMap lightMap, TextureLocation texture, Vector4f rgba, Direction perspective, Vector3f offset, Vector3i size, float scale) {
        poseStack.m_85836_();
        poseStack.m_252880_(offset.x, offset.y, offset.z);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        float sX = size.x;
        float sY = size.y;
        float sZ = size.z;
        sX *= scale / 16.0f / 2.0f;
        sY *= scale / 16.0f / 2.0f;
        sZ *= scale / 16.0f / 2.0f;
        float r = rgba.x;
        float g = rgba.y;
        float b = rgba.z;
        float a = rgba.w;
        TextureAtlasSprite stillTexture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(texture.location());
        float textureScale = texture.scale();
        double pUOffset = (float)texture.offsetX() * textureScale;
        double pVOffset = (float)texture.offsetY() * textureScale;
        float u1 = stillTexture.m_118367_(pUOffset);
        float v1 = stillTexture.m_118393_(pVOffset);
        switch (perspective) {
            case UP: {
                float u2 = stillTexture.m_118367_(pUOffset + (double)((float)size.z * textureScale));
                float v2 = stillTexture.m_118393_(pVOffset + (double)((float)size.x * textureScale));
                buffer.m_252986_(matrix4f, -sX, sY, -sZ).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.unw).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, -sX, sY, sZ).m_85950_(r, g, b, a).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.usw).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, sX, sY, sZ).m_85950_(r, g, b, a).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.use).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, sX, sY, -sZ).m_85950_(r, g, b, a).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.une).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                break;
            }
            case DOWN: {
                float u2 = stillTexture.m_118367_(pUOffset + (double)((float)size.z * textureScale));
                float v2 = stillTexture.m_118393_(pVOffset + (double)((float)size.x * textureScale));
                buffer.m_252986_(matrix4f, -sX, -sY, -sZ).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.dnw).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, sX, -sY, -sZ).m_85950_(r, g, b, a).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.dne).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, sX, -sY, sZ).m_85950_(r, g, b, a).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.dse).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, -sX, -sY, sZ).m_85950_(r, g, b, a).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.dsw).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                break;
            }
            case SOUTH: {
                float u2 = stillTexture.m_118367_(pUOffset + (double)((float)size.x * textureScale));
                float v2 = stillTexture.m_118393_(pVOffset + (double)((float)size.y * textureScale));
                buffer.m_252986_(matrix4f, -sX, -sY, sZ).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.sde).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                buffer.m_252986_(matrix4f, sX, -sY, sZ).m_85950_(r, g, b, a).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.sdw).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                buffer.m_252986_(matrix4f, sX, sY, sZ).m_85950_(r, g, b, a).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.sue).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                buffer.m_252986_(matrix4f, -sX, sY, sZ).m_85950_(r, g, b, a).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.suw).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                break;
            }
            case NORTH: {
                float u2 = stillTexture.m_118367_(pUOffset + (double)((float)size.x * textureScale));
                float v2 = stillTexture.m_118393_(pVOffset + (double)((float)size.y * textureScale));
                buffer.m_252986_(matrix4f, -sX, -sY, -sZ).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.ndw).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                buffer.m_252986_(matrix4f, -sX, sY, -sZ).m_85950_(r, g, b, a).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.nuw).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                buffer.m_252986_(matrix4f, sX, sY, -sZ).m_85950_(r, g, b, a).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.nue).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                buffer.m_252986_(matrix4f, sX, -sY, -sZ).m_85950_(r, g, b, a).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.nde).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                break;
            }
            case EAST: {
                float u2 = stillTexture.m_118367_(pUOffset + (double)((float)size.y * textureScale));
                float v2 = stillTexture.m_118393_(pVOffset + (double)((float)size.z * textureScale));
                buffer.m_252986_(matrix4f, sX, -sY, -sZ).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.edn).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, sX, sY, -sZ).m_85950_(r, g, b, a).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.eun).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, sX, sY, sZ).m_85950_(r, g, b, a).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.eus).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, sX, -sY, sZ).m_85950_(r, g, b, a).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.eds).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                break;
            }
            case WEST: {
                float u2 = stillTexture.m_118367_(pUOffset + (double)((float)size.y * textureScale));
                float v2 = stillTexture.m_118393_(pVOffset + (double)((float)size.z * textureScale));
                buffer.m_252986_(matrix4f, -sX, -sY, -sZ).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.wdn).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, -sX, -sY, sZ).m_85950_(r, g, b, a).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.wds).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, -sX, sY, sZ).m_85950_(r, g, b, a).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.wus).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                buffer.m_252986_(matrix4f, -sX, sY, -sZ).m_85950_(r, g, b, a).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMap.wun).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
            }
        }
        poseStack.m_85849_();
    }

    public static final class BoxLightMap {
        public int use;
        public int usw;
        public int une;
        public int unw;
        public int dse;
        public int dsw;
        public int dne;
        public int dnw;
        public int sue;
        public int suw;
        public int nue;
        public int nuw;
        public int sde;
        public int sdw;
        public int nde;
        public int ndw;
        public int eus;
        public int wus;
        public int eun;
        public int wun;
        public int eds;
        public int wds;
        public int edn;
        public int wdn;

        public BoxLightMap setAll(int packedLight) {
            this.edn = this.wdn = packedLight;
            this.wds = this.wdn;
            this.eds = this.wdn;
            this.wun = this.wdn;
            this.eun = this.wdn;
            this.wus = this.wdn;
            this.eus = this.wdn;
            this.ndw = this.wdn;
            this.nde = this.wdn;
            this.sdw = this.wdn;
            this.sde = this.wdn;
            this.nuw = this.wdn;
            this.nue = this.wdn;
            this.suw = this.wdn;
            this.sue = this.wdn;
            this.dnw = this.wdn;
            this.dne = this.wdn;
            this.dsw = this.wdn;
            this.dse = this.wdn;
            this.unw = this.wdn;
            this.une = this.wdn;
            this.usw = this.wdn;
            this.use = this.wdn;
            return this;
        }

        public BoxLightMap setCorners(int use, int usw, int une, int unw, int dse, int dsw, int dne, int dnw) {
            this.sue = this.eus = use;
            this.use = this.eus;
            this.suw = this.wus = usw;
            this.usw = this.wus;
            this.nue = this.eun = une;
            this.une = this.eun;
            this.nuw = this.wun = unw;
            this.unw = this.wun;
            this.sde = this.eds = dse;
            this.dse = this.eds;
            this.sdw = this.wds = dsw;
            this.dsw = this.wds;
            this.nde = this.edn = dne;
            this.dne = this.edn;
            this.ndw = this.wdn = dnw;
            this.dnw = this.wdn;
            return this;
        }

        public BoxLightMap setUSE(int value) {
            this.sue = this.eus = value;
            this.use = this.eus;
            return this;
        }

        public BoxLightMap setUSW(int value) {
            this.suw = this.wus = value;
            this.usw = this.wus;
            return this;
        }

        public BoxLightMap setUNE(int value) {
            this.nue = this.eun = value;
            this.une = this.eun;
            return this;
        }

        public BoxLightMap setUNW(int value) {
            this.nuw = this.wun = value;
            this.unw = this.wun;
            return this;
        }

        public BoxLightMap setDSE(int value) {
            this.sde = this.eds = value;
            this.dse = this.eds;
            return this;
        }

        public BoxLightMap setDSW(int value) {
            this.sdw = this.wds = value;
            this.dsw = this.wds;
            return this;
        }

        public BoxLightMap setDNE(int value) {
            this.nde = this.edn = value;
            this.dne = this.edn;
            return this;
        }

        public BoxLightMap setDNW(int value) {
            this.ndw = this.wdn = value;
            this.dnw = this.wdn;
            return this;
        }

        public BoxLightMap setFaces(int up, int down, int south, int north, int east, int west) {
            this.une = this.unw = up;
            this.usw = this.unw;
            this.use = this.unw;
            this.dne = this.dnw = down;
            this.dsw = this.dnw;
            this.dse = this.dnw;
            this.sde = this.sdw = south;
            this.suw = this.sdw;
            this.sue = this.sdw;
            this.nde = this.ndw = south;
            this.nuw = this.ndw;
            this.nue = this.ndw;
            this.eds = this.edn = east;
            this.eun = this.edn;
            this.eus = this.edn;
            this.wds = this.wdn = west;
            this.wun = this.wdn;
            this.wus = this.wdn;
            return this;
        }

        public BoxLightMap setFace(Direction face, int light) {
            switch (face) {
                case UP: {
                    this.une = this.unw = light;
                    this.usw = this.unw;
                    this.use = this.unw;
                    break;
                }
                case DOWN: {
                    this.dne = this.dnw = light;
                    this.dsw = this.dnw;
                    this.dse = this.dnw;
                    break;
                }
                case SOUTH: {
                    this.sde = this.sdw = light;
                    this.suw = this.sdw;
                    this.sue = this.sdw;
                    break;
                }
                case NORTH: {
                    this.nde = this.ndw = light;
                    this.nuw = this.ndw;
                    this.nue = this.ndw;
                    break;
                }
                case EAST: {
                    this.eds = this.edn = light;
                    this.eun = this.edn;
                    this.eus = this.edn;
                    break;
                }
                case WEST: {
                    this.wds = this.wdn = light;
                    this.wun = this.wdn;
                    this.wus = this.wdn;
                }
            }
            return this;
        }

        public BoxLightMap packLightMaps(BoxLightMap block, BoxLightMap sky) {
            this.use = LightTexture.m_109885_((int)block.use, (int)sky.use);
            this.usw = LightTexture.m_109885_((int)block.usw, (int)sky.usw);
            this.une = LightTexture.m_109885_((int)block.une, (int)sky.une);
            this.unw = LightTexture.m_109885_((int)block.unw, (int)sky.unw);
            this.dse = LightTexture.m_109885_((int)block.dse, (int)sky.dse);
            this.dsw = LightTexture.m_109885_((int)block.dsw, (int)sky.dsw);
            this.dne = LightTexture.m_109885_((int)block.dne, (int)sky.dne);
            this.dnw = LightTexture.m_109885_((int)block.dnw, (int)sky.dnw);
            this.sue = LightTexture.m_109885_((int)block.sue, (int)sky.sue);
            this.suw = LightTexture.m_109885_((int)block.suw, (int)sky.suw);
            this.nue = LightTexture.m_109885_((int)block.nue, (int)sky.nue);
            this.nuw = LightTexture.m_109885_((int)block.nuw, (int)sky.nuw);
            this.sde = LightTexture.m_109885_((int)block.sde, (int)sky.sde);
            this.sdw = LightTexture.m_109885_((int)block.sdw, (int)sky.sdw);
            this.nde = LightTexture.m_109885_((int)block.nde, (int)sky.nde);
            this.ndw = LightTexture.m_109885_((int)block.ndw, (int)sky.ndw);
            this.eus = LightTexture.m_109885_((int)block.eus, (int)sky.eus);
            this.wus = LightTexture.m_109885_((int)block.wus, (int)sky.wus);
            this.eun = LightTexture.m_109885_((int)block.eun, (int)sky.eun);
            this.wun = LightTexture.m_109885_((int)block.wun, (int)sky.wun);
            this.eds = LightTexture.m_109885_((int)block.eds, (int)sky.eds);
            this.wds = LightTexture.m_109885_((int)block.wds, (int)sky.wds);
            this.edn = LightTexture.m_109885_((int)block.edn, (int)sky.edn);
            this.wdn = LightTexture.m_109885_((int)block.wdn, (int)sky.wdn);
            return this;
        }

        public BoxLightMap getBlockLightMap() {
            BoxLightMap block = new BoxLightMap();
            block.use = LightTexture.m_109883_((int)this.use);
            block.usw = LightTexture.m_109883_((int)this.usw);
            block.une = LightTexture.m_109883_((int)this.une);
            block.unw = LightTexture.m_109883_((int)this.unw);
            block.dse = LightTexture.m_109883_((int)this.dse);
            block.dsw = LightTexture.m_109883_((int)this.dsw);
            block.dne = LightTexture.m_109883_((int)this.dne);
            block.dnw = LightTexture.m_109883_((int)this.dnw);
            block.sue = LightTexture.m_109883_((int)this.sue);
            block.suw = LightTexture.m_109883_((int)this.suw);
            block.nue = LightTexture.m_109883_((int)this.nue);
            block.nuw = LightTexture.m_109883_((int)this.nuw);
            block.sde = LightTexture.m_109883_((int)this.sde);
            block.sdw = LightTexture.m_109883_((int)this.sdw);
            block.nde = LightTexture.m_109883_((int)this.nde);
            block.ndw = LightTexture.m_109883_((int)this.ndw);
            block.eus = LightTexture.m_109883_((int)this.eus);
            block.wus = LightTexture.m_109883_((int)this.wus);
            block.eun = LightTexture.m_109883_((int)this.eun);
            block.wun = LightTexture.m_109883_((int)this.wun);
            block.eds = LightTexture.m_109883_((int)this.eds);
            block.wds = LightTexture.m_109883_((int)this.wds);
            block.edn = LightTexture.m_109883_((int)this.edn);
            block.wdn = LightTexture.m_109883_((int)this.wdn);
            return block;
        }

        public BoxLightMap getSkyLightMap() {
            BoxLightMap sky = new BoxLightMap();
            sky.use = LightTexture.m_109894_((int)this.use);
            sky.usw = LightTexture.m_109894_((int)this.usw);
            sky.une = LightTexture.m_109894_((int)this.une);
            sky.unw = LightTexture.m_109894_((int)this.unw);
            sky.dse = LightTexture.m_109894_((int)this.dse);
            sky.dsw = LightTexture.m_109894_((int)this.dsw);
            sky.dne = LightTexture.m_109894_((int)this.dne);
            sky.dnw = LightTexture.m_109894_((int)this.dnw);
            sky.sue = LightTexture.m_109894_((int)this.sue);
            sky.suw = LightTexture.m_109894_((int)this.suw);
            sky.nue = LightTexture.m_109894_((int)this.nue);
            sky.nuw = LightTexture.m_109894_((int)this.nuw);
            sky.sde = LightTexture.m_109894_((int)this.sde);
            sky.sdw = LightTexture.m_109894_((int)this.sdw);
            sky.nde = LightTexture.m_109894_((int)this.nde);
            sky.ndw = LightTexture.m_109894_((int)this.ndw);
            sky.eus = LightTexture.m_109894_((int)this.eus);
            sky.wus = LightTexture.m_109894_((int)this.wus);
            sky.eun = LightTexture.m_109894_((int)this.eun);
            sky.wun = LightTexture.m_109894_((int)this.wun);
            sky.eds = LightTexture.m_109894_((int)this.eds);
            sky.wds = LightTexture.m_109894_((int)this.wds);
            sky.edn = LightTexture.m_109894_((int)this.edn);
            sky.wdn = LightTexture.m_109894_((int)this.wdn);
            return sky;
        }
    }
}

