/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.compat.cc.peripherals;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.LuaValues;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jcm.vsch.blocks.thruster.ThrusterBrain;
import net.jcm.vsch.compat.cc.peripherals.CCGenerics;
import net.jcm.vsch.config.VSCHServerConfig;
import net.jcm.vsch.ship.thruster.ThrusterData;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ThrusterPeripheral
implements IPeripheral {
    private static final Set<String> ADDTIONAL_TYPES = Stream.concat(CCGenerics.ENERGY_METHODS.getType().getAdditionalTypes().stream(), CCGenerics.FLUID_METHODS.getType().getAdditionalTypes().stream()).collect(Collectors.toSet());
    private final ThrusterBrain brain;

    public ThrusterPeripheral(ThrusterBrain brain) {
        this.brain = brain;
    }

    public Object getTarget() {
        return this.brain;
    }

    public String getType() {
        return "starlance_thruster";
    }

    public Set<String> getAdditionalTypes() {
        return ADDTIONAL_TYPES;
    }

    @LuaFunction
    public final String getThrusterType() {
        return this.brain.getPeripheralType();
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getMode() {
        ThrusterData.ThrusterMode mode = this.brain.getThrusterMode();
        return MethodResult.of((Object[])new Object[]{mode.toString(), mode.ordinal() + 1});
    }

    @LuaFunction(mainThread=true)
    public final void setMode(IArguments args) throws LuaException {
        ThrusterData.ThrusterMode tmode;
        if (!((Boolean)VSCHServerConfig.THRUSTER_TOGGLE.get()).booleanValue()) {
            throw new LuaException("Thruster mode toggle disabled in server config");
        }
        Object arg0 = args.get(0);
        if (arg0 instanceof String) {
            String mode = (String)arg0;
            try {
                tmode = ThrusterData.ThrusterMode.valueOf(mode.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new LuaException("Unknown thruster mode");
            }
        } else if (arg0 instanceof Number) {
            Number mode = (Number)arg0;
            try {
                tmode = ThrusterData.ThrusterMode.values()[mode.intValue() - 1];
            }
            catch (IndexOutOfBoundsException e) {
                throw new LuaException("Unknown thruster mode");
            }
        } else {
            throw LuaValues.badArgumentOf((IArguments)args, (int)0, (String)"string or number");
        }
        this.brain.setThrusterMode(tmode);
    }

    @LuaFunction
    public final boolean getPeripheralMode() {
        return this.brain.getPeripheralMode();
    }

    @LuaFunction
    public final void setPeripheralMode(boolean mode) {
        this.brain.setPeripheralMode(mode);
    }

    @LuaFunction
    public final double getPower() {
        return this.brain.getPower();
    }

    @LuaFunction
    public final void setPower(double power) throws LuaException {
        if (!this.brain.getPeripheralMode()) {
            throw new LuaException("Peripheral mode is off, redstone control only");
        }
        this.brain.setPower(power);
    }

    @LuaFunction
    public final double getThrusters() {
        return this.brain.getThrusterCount();
    }

    @LuaFunction
    public final double getTotalMaxThrottle() {
        return this.brain.getMaxThrottle() * (double)this.brain.getThrusterCount();
    }

    @LuaFunction
    public final double getTotalThrottle() {
        return this.brain.getCurrentThrottle() * (double)this.brain.getThrusterCount();
    }

    @LuaFunction
    public final double getEachMaxThrottle() {
        return this.brain.getMaxThrottle();
    }

    @LuaFunction
    public final double getEachThrottle() {
        return this.brain.getCurrentThrottle();
    }

    public boolean equals(IPeripheral other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ThrusterPeripheral) {
            ThrusterPeripheral otherThruster = (ThrusterPeripheral)other;
            return this.brain == otherThruster.brain;
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public int getEnergy() {
        return CCGenerics.ENERGY_METHODS.getEnergy((IEnergyStorage)this.brain);
    }

    @LuaFunction(mainThread=true)
    public int getEnergyCapacity() {
        return CCGenerics.ENERGY_METHODS.getEnergyCapacity((IEnergyStorage)this.brain);
    }

    @LuaFunction(mainThread=true)
    public Map<Integer, Map<String, ?>> tanks() {
        return CCGenerics.FLUID_METHODS.tanks((IFluidHandler)this.brain);
    }

    @LuaFunction(mainThread=true)
    public int pushFluid(IComputerAccess computer, String toName, Optional<Integer> limit, Optional<String> fluidName) throws LuaException {
        return CCGenerics.FLUID_METHODS.pushFluid((IFluidHandler)this.brain, computer, toName, limit, fluidName);
    }

    @LuaFunction(mainThread=true)
    public int pullFluid(IComputerAccess computer, String fromName, Optional<Integer> limit, Optional<String> fluidName) throws LuaException {
        return CCGenerics.FLUID_METHODS.pullFluid((IFluidHandler)this.brain, computer, fromName, limit, fluidName);
    }
}

