/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.event;

import net.jcm.vsch.api.event.PreTravelEvent;
import net.jcm.vsch.ship.ShipLandingAttachment;
import net.jcm.vsch.util.TeleportationHandler;
import net.jcm.vsch.util.VSCHUtils;
import net.jcm.vsch.util.wapi.LevelData;
import net.jcm.vsch.util.wapi.PlanetData;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;

public class AtmosphericCollision {
    private static final Logger LOGGER = LogManager.getLogger((String)"vsch");
    private static final TeleportationHandler TELEPORT_HANDLER = new TeleportationHandler(null, null, false);

    public static void atmosphericCollisionTick(ServerLevel level) {
        LevelData levelData = LevelData.get((Level)level);
        ResourceKey<Level> targetDimension = levelData.getUpperDimension();
        if (targetDimension == null) {
            return;
        }
        ServerLevel targetLevel = level.m_7654_().m_129880_(targetDimension);
        if (targetLevel == null) {
            return;
        }
        ResourceKey dimension = level.m_46472_();
        LevelData targetLevelData = LevelData.get((Level)targetLevel);
        PlanetData planet = targetLevelData.getPlanet((ResourceKey<Level>)dimension);
        if (planet == null) {
            return;
        }
        Vec3 planetPos = planet.getPosition();
        double atmoHeight = levelData.getAtmosphereY();
        TeleportationHandler teleportHandler = TELEPORT_HANDLER;
        teleportHandler.reset(level, targetLevel);
        for (LoadedServerShip ship : VSCHUtils.getLoadedShipsInLevel(level)) {
            if (ship.isStatic() || teleportHandler.hasShip((ServerShip)ship)) continue;
            Vector3dc shipPos = ship.getTransform().getPositionInWorld();
            double shipY = shipPos.y();
            ShipLandingAttachment landingAttachment = ShipLandingAttachment.get((ServerShip)ship);
            if (shipY + 10.0 < atmoHeight) {
                landingAttachment.landing = false;
                continue;
            }
            if (landingAttachment.landing && shipY < atmoHeight + 128.0) continue;
            Vector3d targetPos = new Vector3d(0.0, planet.getSize() / 2.0 + 120.0, 0.0);
            Quaterniond rotation = new Quaterniond(planet.getRotation());
            rotation.transform(targetPos);
            targetPos.add(planetPos.f_82479_, planetPos.f_82480_, planetPos.f_82481_);
            MinecraftForge.EVENT_BUS.post((Event)new PreTravelEvent.PlanetToSpace((ResourceKey<Level>)dimension, shipPos, targetDimension, targetPos, rotation));
            LOGGER.info("[starlance]: Handling teleport {} ({}) to {} {} {} {}", (Object)ship.getSlug(), (Object)ship.getId(), (Object)targetDimension.m_135782_(), (Object)targetPos.x, (Object)targetPos.y, (Object)targetPos.z);
            teleportHandler.addShip((ServerShip)ship, (Vector3dc)targetPos, (Quaterniondc)rotation);
        }
        for (LoadedServerShip ship : teleportHandler.getPendingShips()) {
            ShipLandingAttachment landingAttachment = ShipLandingAttachment.get((ServerShip)ship);
            Vector3dc pos = ship.getTransform().getPositionInWorld();
            landingAttachment.setLaunching((ResourceKey<Level>)dimension, new ChunkPos(SectionPos.m_235865_((double)pos.x()), SectionPos.m_235865_((double)pos.z())));
        }
        teleportHandler.finalizeTeleport();
    }
}

