/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.items.custom;

import com.mojang.serialization.DynamicOps;
import net.jcm.vsch.accessor.LivingEntityAccessor;
import net.jcm.vsch.compat.CompatMods;
import net.jcm.vsch.compat.curios.MagnetBootCurio;
import net.jcm.vsch.config.VSCHServerConfig;
import net.jcm.vsch.items.IToggleableItem;
import net.jcm.vsch.util.CollisionUtil;
import net.jcm.vsch.util.VSCHUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import top.theillusivec4.curios.api.CuriosCapability;

public class MagnetBootItem
extends ArmorItem
implements IToggleableItem {
    private static final String TAG_DISABLED = "Disabled";
    private static final String TAG_READY = "Ready";
    private static final String TAG_DIRECTION = "Direction";
    private static final String TAG_ATTACHING = "Attaching";
    private static final double MIN_FORCE = 0.01;

    public MagnetBootItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public double getAttractDistance() {
        return ((Number)VSCHServerConfig.MAGNET_BOOT_DISTANCE.get()).doubleValue();
    }

    public double getMaxForce() {
        return ((Number)VSCHServerConfig.MAGNET_BOOT_MAX_FORCE.get()).doubleValue();
    }

    public boolean getEnabled(ItemStack stack) {
        if (!(stack.m_41720_() instanceof MagnetBootItem)) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        return tag == null || !tag.m_128471_(TAG_DISABLED);
    }

    public boolean getReady(ItemStack stack) {
        if (!(stack.m_41720_() instanceof MagnetBootItem)) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_(TAG_READY);
    }

    public boolean isWorking(ItemStack stack) {
        if (!(stack.m_41720_() instanceof MagnetBootItem)) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        return tag != null && !tag.m_128471_(TAG_DISABLED) && tag.m_128471_(TAG_READY);
    }

    public Long getWorkingShip(ItemStack stack) {
        if (!(stack.m_41720_() instanceof MagnetBootItem)) {
            return null;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null || tag.m_128471_(TAG_DISABLED) || !tag.m_128471_(TAG_READY)) {
            return null;
        }
        return tag.m_128441_(TAG_ATTACHING) ? Long.valueOf(tag.m_128454_(TAG_ATTACHING)) : null;
    }

    public static Long getMagnetizedShip(ItemStack stack) {
        Long l;
        Item item = stack.m_41720_();
        if (item instanceof MagnetBootItem) {
            MagnetBootItem boot = (MagnetBootItem)item;
            l = boot.getWorkingShip(stack);
        } else {
            l = null;
        }
        return l;
    }

    public static boolean isMagnetized(LivingEntity entity) {
        MagnetBootItem boot;
        Item item;
        ItemStack stack = entity.m_6844_(EquipmentSlot.FEET);
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof MagnetBootItem && (boot = (MagnetBootItem)item).isWorking(stack)) {
            return true;
        }
        return VSCHUtils.testCuriosItems(entity, "boots", (stack2, slot) -> {
            MagnetBootItem boot;
            Item patt3913$temp = stack2.m_41720_();
            return patt3913$temp instanceof MagnetBootItem && (boot = (MagnetBootItem)patt3913$temp).isWorking((ItemStack)stack2);
        });
    }

    public Vec3 getDirection(ItemStack stack) {
        if (!(stack.m_41720_() instanceof MagnetBootItem)) {
            return null;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return null;
        }
        return Vec3.f_231074_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_(TAG_DIRECTION)).result().orElse(null);
    }

    @Override
    public void onToggle(Player owner, ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        boolean disable = !tag.m_128471_(TAG_DISABLED);
        tag.m_128379_(TAG_DISABLED, disable);
        if (owner.m_9236_().f_46443_) {
            return;
        }
        owner.m_5661_((Component)Component.m_237115_((String)(disable ? "vsch.message.magnet_boot.disabled" : "vsch.message.magnet_boot.enabled")), true);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (livingEntity.m_6844_(EquipmentSlot.FEET) != stack) {
            return;
        }
        this.onInventoryTick(stack, level, livingEntity);
    }

    public void onInventoryTick(ItemStack stack, Level level, LivingEntity entity) {
        if (entity.f_19794_ || entity.m_20159_()) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150110_().f_35935_) {
                return;
            }
        }
        CompoundTag tag = stack.m_41784_();
        boolean disabled = tag.m_128471_(TAG_DISABLED);
        boolean wasReady = tag.m_128471_(TAG_READY);
        double maxDistance = this.getAttractDistance();
        Vec3 startPos = entity.m_20182_();
        Vec3 direction = new Vec3(0.0, -1.0, 0.0);
        BlockPos blockPos = CollisionUtil.findSupportingBlockNoOrientation((Entity)entity, maxDistance);
        if (blockPos == null) {
            if (wasReady) {
                tag.m_128379_(TAG_READY, false);
                tag.m_128473_(TAG_DIRECTION);
            }
            return;
        }
        if (!wasReady) {
            tag.m_128379_(TAG_READY, true);
            tag.m_128365_(TAG_DIRECTION, (Tag)Vec3.f_231074_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)direction).result().orElse(null));
        }
        if (disabled) {
            return;
        }
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)blockPos);
        Vector3d blockCenter = new Vector3d((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
        if (ship != null) {
            tag.m_128356_(TAG_ATTACHING, ship.getId());
            ship.getShipToWorld().transformPosition(blockCenter);
        } else {
            tag.m_128473_(TAG_ATTACHING);
        }
        Vector3d displacment = new Vector3d(startPos.f_82479_, startPos.f_82480_, startPos.f_82481_).sub((Vector3dc)blockCenter);
        double distance = Math.max(displacment.y, 0.0);
        if (((LivingEntityAccessor)entity).vsch$getTickSinceLastJump() > 30 || distance > 1.5) {
            double scaledForce = Math.min(maxDistance * maxDistance / distance * 0.01, this.getMaxForce());
            Vec3 force = direction.m_82490_(scaledForce);
            tag.m_128347_("Force", scaledForce);
            entity.m_5997_(force.f_82479_, force.f_82480_, force.f_82481_);
        } else {
            tag.m_128347_("Force", 0.0);
        }
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag nbt) {
        return new ICapabilityProvider(){
            private LazyOptional<Object> curiosCap = LazyOptional.empty();

            public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction dir) {
                if (CompatMods.CURIOS.isLoaded() && cap == CuriosCapability.ITEM) {
                    if (!this.curiosCap.isPresent()) {
                        this.curiosCap = LazyOptional.of(() -> new MagnetBootCurio(MagnetBootItem.this, stack));
                    }
                    return this.curiosCap.cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    private static Quaternionf rotateTowards(Quaternionf current, Quaternionfc target) {
        Quaternionf proj = MagnetBootItem.projectedRotation((Quaternionfc)current, target);
        Quaternionf quaternionf = new Quaternionf();
        if (proj.conjugate(quaternionf).mul((Quaternionfc)current).angle() < 0.025f) {
            return current.set((Quaternionfc)proj);
        }
        return current.slerp((Quaternionfc)proj, 0.15f);
    }

    private static Quaternionf projectedRotation(Quaternionfc current, Quaternionfc target) {
        Vector3f up = target.transform(new Vector3f(0.0f, 1.0f, 0.0f));
        Vector3f forward = current.transform(new Vector3f(0.0f, 0.0f, -1.0f));
        Vector3f forwardProj = forward.fma(-forward.dot((Vector3fc)up), (Vector3fc)up, new Vector3f());
        if ((double)forwardProj.lengthSquared() < 1.0E-6) {
            forwardProj.set(up.x, up.y, 0.0f);
        }
        forwardProj.normalize();
        Vector3f right = forwardProj.cross((Vector3fc)up, new Vector3f()).normalize();
        return new Quaternionf().setFromNormalized((Matrix3fc)new Matrix3f((Vector3fc)right, (Vector3fc)up, (Vector3fc)forwardProj.negate()));
    }
}

