/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.mixin.valkyrienskies;

import net.jcm.vsch.config.VSCHServerConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.util.datastructures.DenseBlockPosSet;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.assembly.ShipAssemblyKt;

@Mixin(value={ShipAssemblyKt.class})
public class MixinShipAssemblyKt {
    @Unique
    private static final Logger LOGGER = LogManager.getLogger((String)"vsch");

    @Inject(method={"createNewShipWithBlocks"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void createNewShipWithBlocks(BlockPos centerBlock, DenseBlockPosSet blocks, ServerLevel level, CallbackInfoReturnable<ServerShip> cir) {
        if (centerBlock.m_123342_() > VSGameUtilsKt.getYRange((Level)level).getMaxY()) {
            if (((Boolean)VSCHServerConfig.CANCEL_ASSEMBLY.get()).booleanValue()) {
                level.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)"Starlance: Multi-block assembly above world height, cancelling. Instead, use ship creator stick, or assemble in another dimension. You can override this behavior in config, but its not recommended.").m_130940_(ChatFormatting.RED), false);
                LOGGER.warn("Starlance cancelled multi-block assembly above overworld build height. You can override this behavior in config, but its not recommended.");
                cir.cancel();
            } else {
                LOGGER.warn("Multi-block assembly above build height NOT cancelled by starlance: be warned");
            }
        }
    }
}

