/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.ship;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public final class ShipLandingAttachment {
    @JsonProperty
    public boolean launching = false;
    @JsonProperty
    public boolean landing = false;
    public ServerPlayer commander = null;
    @JsonProperty
    public boolean freezed = false;
    public Vector3dc velocity = null;
    public Vector3dc omega = null;
    private final Map<ResourceKey<Level>, ChunkPos> launchPositions = new HashMap<ResourceKey<Level>, ChunkPos>();

    public static ShipLandingAttachment get(ServerShip ship) {
        ShipLandingAttachment attachment = (ShipLandingAttachment)ship.getAttachment(ShipLandingAttachment.class);
        if (attachment == null) {
            attachment = new ShipLandingAttachment();
            ship.saveAttachment(ShipLandingAttachment.class, (Object)attachment);
        }
        return attachment;
    }

    @JsonGetter(value="launchPositions")
    private Map<String, Long> getLaunchPositions0() {
        HashMap<String, Long> positions = new HashMap<String, Long>(this.launchPositions.size());
        this.launchPositions.forEach((level, pos) -> positions.put(level.m_135782_().toString(), pos.m_45588_()));
        return positions;
    }

    @JsonSetter(value="launchPositions")
    private void setLaunchPositions0(Map<String, Long> positions) {
        this.launchPositions.clear();
        positions.forEach((level, pos) -> this.launchPositions.put((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(level)), new ChunkPos(pos.longValue())));
    }

    public void setLaunching(ResourceKey<Level> level, ChunkPos pos) {
        this.landing = false;
        this.launching = true;
        this.launchPositions.put(level, pos);
    }

    public void setLanding() {
        this.launching = false;
        this.landing = true;
    }

    public void freezeShip(LoadedServerShip ship) {
        this.freezed = true;
        this.velocity = new Vector3d(ship.getVelocity());
        this.omega = new Vector3d(ship.getOmega());
        ship.setStatic(true);
    }

    public Map<ResourceKey<Level>, ChunkPos> getLaunchPositions() {
        return this.launchPositions;
    }

    public ChunkPos getLaunchPosition(ResourceKey<Level> level) {
        return this.launchPositions.get(level);
    }
}

