/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.ship;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.jcm.vsch.ship.IVSCHForceApplier;
import net.jcm.vsch.ship.dragger.DraggerData;
import net.jcm.vsch.ship.dragger.DraggerForceApplier;
import net.jcm.vsch.ship.gyro.GyroData;
import net.jcm.vsch.ship.gyro.GyroForceApplier;
import net.jcm.vsch.ship.thruster.ThrusterData;
import net.jcm.vsch.ship.thruster.ThrusterForceApplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class VSCHForceInducedShips
implements ShipForcesInducer {
    public Map<BlockPos, IVSCHForceApplier> appliers = new ConcurrentHashMap<BlockPos, IVSCHForceApplier>();
    private String dimensionId = null;

    public VSCHForceInducedShips() {
    }

    public VSCHForceInducedShips(String dimensionId) {
        this.dimensionId = dimensionId;
    }

    public void applyForces(@NotNull PhysShip physicShip) {
        PhysShipImpl physShip = (PhysShipImpl)physicShip;
        this.appliers.forEach((pos, applier) -> applier.applyForces((BlockPos)pos, physShip));
    }

    public void addApplier(BlockPos pos, IVSCHForceApplier applier) {
        this.appliers.put(pos, applier);
    }

    public void removeApplier(BlockPos pos) {
        this.appliers.remove(pos);
    }

    @Nullable
    public IVSCHForceApplier getApplierAtPos(BlockPos pos) {
        return this.appliers.get(pos);
    }

    public void addDragger(BlockPos pos, DraggerData data) {
        this.addApplier(pos, new DraggerForceApplier(data));
    }

    public void removeDragger(BlockPos pos) {
        if (this.getDraggerAtPos(pos) != null) {
            this.removeApplier(pos);
        }
    }

    @Nullable
    public DraggerData getDraggerAtPos(BlockPos pos) {
        IVSCHForceApplier applier = this.getApplierAtPos(pos);
        if (applier instanceof DraggerForceApplier) {
            DraggerForceApplier dragger = (DraggerForceApplier)applier;
            return dragger.getData();
        }
        return null;
    }

    public void addThruster(BlockPos pos, ThrusterData data) {
        this.addApplier(pos, new ThrusterForceApplier(data));
    }

    public void removeThruster(BlockPos pos) {
        if (this.getThrusterAtPos(pos) != null) {
            this.removeApplier(pos);
        }
    }

    @Nullable
    public ThrusterData getThrusterAtPos(BlockPos pos) {
        IVSCHForceApplier applier = this.getApplierAtPos(pos);
        if (applier instanceof ThrusterForceApplier) {
            ThrusterForceApplier thruster = (ThrusterForceApplier)applier;
            return thruster.getData();
        }
        return null;
    }

    public void addGyro(BlockPos pos, GyroData data) {
        this.addApplier(pos, new GyroForceApplier(data));
    }

    public void removeGyro(BlockPos pos) {
        if (this.getGyroAtPos(pos) != null) {
            this.removeApplier(pos);
        }
    }

    @Nullable
    public GyroData getGyroAtPos(BlockPos pos) {
        IVSCHForceApplier applier = this.getApplierAtPos(pos);
        if (applier instanceof GyroForceApplier) {
            GyroForceApplier gyro = (GyroForceApplier)applier;
            return gyro.getData();
        }
        return null;
    }

    public static VSCHForceInducedShips getOrCreate(ServerShip ship, String dimensionId) {
        VSCHForceInducedShips attachment = (VSCHForceInducedShips)ship.getAttachment(VSCHForceInducedShips.class);
        if (attachment == null) {
            attachment = new VSCHForceInducedShips(dimensionId);
            ship.saveAttachment(VSCHForceInducedShips.class, (Object)attachment);
        }
        return attachment;
    }

    public static VSCHForceInducedShips getOrCreate(ServerShip ship) {
        return VSCHForceInducedShips.getOrCreate(ship, ship.getChunkClaimDimension());
    }

    public static VSCHForceInducedShips get(Level level, BlockPos pos) {
        ServerLevel serverLevel = (ServerLevel)level;
        LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)pos);
        if (ship == null) {
            ship = VSGameUtilsKt.getShipManagingPos((ServerLevel)serverLevel, (BlockPos)pos);
        }
        return ship != null ? VSCHForceInducedShips.getOrCreate((ServerShip)ship) : null;
    }
}

