/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.ship.dragger;

import net.jcm.vsch.config.VSCHServerConfig;
import net.jcm.vsch.ship.IVSCHForceApplier;
import net.jcm.vsch.ship.dragger.DraggerData;
import net.jcm.vsch.util.VSCHUtils;
import net.minecraft.core.BlockPos;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;

public class DraggerForceApplier
implements IVSCHForceApplier {
    private DraggerData data;

    public DraggerForceApplier(DraggerData data) {
        this.data = data;
    }

    public DraggerData getData() {
        return this.data;
    }

    @Override
    public void applyForces(BlockPos pos, PhysShipImpl physShip) {
        if (!this.data.on) {
            return;
        }
        Vector3dc linearVelocity = physShip.getPoseVel().getVel();
        Vector3dc angularVelocity = physShip.getPoseVel().getOmega();
        Vector3d force = linearVelocity.mul(-physShip.getInertia().getShipMass(), new Vector3d());
        double maxDrag = ((Number)VSCHServerConfig.MAX_DRAG.get()).intValue();
        if (force.lengthSquared() > maxDrag * maxDrag) {
            force.normalize(maxDrag);
        }
        Vector3d rotForce = angularVelocity.mul(-physShip.getInertia().getShipMass(), new Vector3d());
        VSCHUtils.clampVector(rotForce, ((Number)VSCHServerConfig.MAX_DRAG.get()).intValue());
        physShip.applyInvariantForce((Vector3dc)force);
        physShip.applyInvariantTorque((Vector3dc)rotForce);
    }
}

