/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.util;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public final class CollisionUtil {
    private CollisionUtil() {
    }

    public static boolean willCollide(CollisionGetter level, Entity entity, AABBd box, Matrix4dc box2voxel, Matrix4dc voxel2box, Vector3d movement) {
        Vector3d movementInVoxel = box2voxel.transformDirection((Vector3dc)movement, new Vector3d());
        AABBd box1 = box.translate((Vector3dc)movement, new AABBd());
        AABBd box2 = box.transform(box2voxel, new AABBd()).translate((Vector3dc)movementInVoxel);
        boolean[] intersect = new boolean[1];
        for (VoxelShape shape : level.m_186434_(entity, CollisionUtil.toAABB(box2))) {
            AABBd voxel;
            if (shape.m_83281_() || !box2.intersectsAABB(voxel = CollisionUtil.toAABBd(shape.m_83215_())) || !voxel.transform(voxel2box).intersectsAABB(box1)) continue;
            AABBd voxelInBox = new AABBd();
            shape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                if (intersect[0]) {
                    return;
                }
                voxel.setMin(minX, minY, minZ).setMax(maxX, maxY, maxZ);
                if (!box2.intersectsAABB(voxel)) {
                    return;
                }
                voxel.transform(voxel2box, voxelInBox);
                if (!box1.intersectsAABB(voxelInBox)) {
                    return;
                }
                intersect[0] = true;
            });
            if (!intersect[0]) continue;
            return true;
        }
        return false;
    }

    public static boolean willCollideAny(Level level, Entity entity, AABBd box, Matrix4dc box2world, Vector3d movement) {
        Matrix4d world2box = box2world.invert(new Matrix4d());
        if (CollisionUtil.willCollide((CollisionGetter)level, entity, box, box2world, (Matrix4dc)world2box, movement)) {
            return true;
        }
        Matrix4d entityToShip = new Matrix4d();
        Matrix4d shipToEntity = new Matrix4d();
        AABBd checkBox = box.transform(box2world, new AABBd());
        String dimId = VSGameUtilsKt.getDimensionId((Level)level);
        for (LoadedShip ship : VSGameUtilsKt.getShipObjectWorld((Level)level).getLoadedShips()) {
            if (!ship.getChunkClaimDimension().equals(dimId) || !ship.getWorldAABB().intersectsAABB(checkBox)) continue;
            entityToShip.set(ship.getWorldToShip()).mul(box2world);
            shipToEntity.set((Matrix4dc)world2box).mul(ship.getShipToWorld());
            if (!CollisionUtil.willCollide((CollisionGetter)level, entity, box, (Matrix4dc)entityToShip, (Matrix4dc)shipToEntity, movement)) continue;
            return true;
        }
        return false;
    }

    public static BlockPos findSupportingBlockNoOrientation(Entity entity, double downExtend) {
        Vec3 position = entity.m_20182_();
        EntityDimensions dimensions = entity.m_6972_(entity.m_20089_());
        AABBd box = new AABBd((double)(-dimensions.f_20377_ / 2.0f), -downExtend, (double)(-dimensions.f_20377_ / 2.0f), (double)(dimensions.f_20377_ / 2.0f), (double)dimensions.f_20378_, (double)(dimensions.f_20377_ / 2.0f));
        Matrix4d box2world = new Matrix4d().translation(position.f_82479_, position.f_82480_, position.f_82481_);
        return CollisionUtil.findSupportingBlock(entity.m_9236_(), entity, box, (Vector3dc)new Vector3d(), (Matrix4dc)box2world);
    }

    public static BlockPos findSupportingBlock(Level level, Entity entity, AABBd box, Vector3dc feetPos, Matrix4dc box2world) {
        BlockPos closestBlock = null;
        double closestDistance = Double.POSITIVE_INFINITY;
        AABBd worldBox = box.transform(box2world, new AABBd());
        Vector3d feetPos2 = new Vector3d();
        BlockPos block = level.m_285750_(entity, CollisionUtil.toAABB(worldBox)).orElse(null);
        if (block != null) {
            double dist;
            box2world.transformPosition(feetPos, feetPos2);
            closestDistance = dist = block.m_203198_(feetPos2.x, feetPos2.y, feetPos2.z);
            closestBlock = block;
        }
        Matrix4d entityToShip = new Matrix4d();
        AABBd box2 = new AABBd();
        String dimId = VSGameUtilsKt.getDimensionId((Level)level);
        for (LoadedShip ship : VSGameUtilsKt.getShipObjectWorld((Level)level).getLoadedShips()) {
            if (!ship.getChunkClaimDimension().equals(dimId) || !ship.getWorldAABB().intersectsAABB(worldBox)) continue;
            entityToShip.set(ship.getWorldToShip()).mul(box2world);
            BlockPos block2 = level.m_285750_(entity, CollisionUtil.toAABB(box.transform((Matrix4dc)entityToShip, box2))).orElse(null);
            if (block2 == null) continue;
            entityToShip.transformPosition(feetPos, feetPos2);
            double dist = block2.m_203198_(feetPos2.x, feetPos2.y, feetPos2.z);
            if (dist >= closestDistance) continue;
            closestDistance = dist;
            closestBlock = block2;
        }
        return closestBlock;
    }

    public static AABBd expandTowards(AABBd box, Vector3dc vec) {
        return CollisionUtil.expandTowards(box, vec.x(), vec.y(), vec.z());
    }

    public static AABBd expandTowards(AABBd box, double x, double y, double z) {
        if (x < 0.0) {
            box.minX += x;
        } else {
            box.maxX += x;
        }
        if (y < 0.0) {
            box.minY += y;
        } else {
            box.maxY += y;
        }
        if (z < 0.0) {
            box.minZ += z;
        } else {
            box.maxZ += z;
        }
        return box;
    }

    private static AABBd toAABBd(AABB box) {
        return new AABBd(box.f_82288_, box.f_82289_, box.f_82290_, box.f_82291_, box.f_82292_, box.f_82293_);
    }

    private static AABB toAABB(AABBd box) {
        return new AABB(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ);
    }
}

