/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.util;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.physics.PhysicsEntityServer;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.core.impl.game.ships.ShipObjectServerWorld;
import org.valkyrienskies.core.impl.game.ships.ShipTransformImpl;
import org.valkyrienskies.core.util.datastructures.DenseBlockPosSet;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.assembly.ShipAssemblyKt;
import org.valkyrienskies.mod.common.util.EntityDraggingInformation;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.util.RelocationUtilKt;

public class ShipUtils {
    public static ShipTransform transformFromId(Long id, ServerShipWorldCore shipWorld) {
        Ship ship = shipWorld.getAllShips().getById(id.longValue());
        if (ship == null) {
            PhysicsEntityServer physicsEntity = (PhysicsEntityServer)((ShipObjectServerWorld)shipWorld).getLoadedPhysicsEntities().get(id);
            if (physicsEntity == null) {
                return new ShipTransformImpl((Vector3dc)new Vector3d(), (Vector3dc)new Vector3d(), (Quaterniondc)new Quaterniond(), (Vector3dc)new Vector3d());
            }
            return physicsEntity.getShipTransform();
        }
        return ship.getTransform();
    }

    public static boolean isEntityDraggedByShip(Ship ship, Entity entity) {
        IEntityDraggingInformationProvider provider = (IEntityDraggingInformationProvider)entity;
        if (!provider.vs$shouldDrag()) {
            return false;
        }
        EntityDraggingInformation information = provider.getDraggingInformation();
        if (!information.isEntityBeingDraggedByAShip()) {
            return false;
        }
        return Objects.equals(information.getLastShipStoodOn(), ship.getId());
    }

    public static boolean isEntityDraggedByShip(Long id, Entity entity) {
        IEntityDraggingInformationProvider provider = (IEntityDraggingInformationProvider)entity;
        if (!provider.vs$shouldDrag()) {
            return false;
        }
        EntityDraggingInformation information = provider.getDraggingInformation();
        if (!information.isEntityBeingDraggedByAShip()) {
            return false;
        }
        return Objects.equals(information.getLastShipStoodOn(), id);
    }

    public static ServerShip assembleBlocks(ServerLevel level, BlockPos center, int dx, int dy, int dz) {
        if (dx < 0 || dy < 0 || dz < 0) {
            return null;
        }
        DenseBlockPosSet set = new DenseBlockPosSet();
        for (int x = -dx; x <= dx; ++x) {
            for (int y = -dy; y <= dy; ++y) {
                for (int z = -dz; z <= dz; ++z) {
                    BlockPos newBlock = new BlockPos(center.m_123341_() + x, center.m_123342_() + y, center.m_123343_() + z);
                    if (level.m_8055_(newBlock).m_60795_()) continue;
                    set.add((Vector3ic)VectorConversionsMCKt.toJOML((Vec3i)newBlock));
                }
            }
        }
        if (set.isEmpty()) {
            return null;
        }
        return ShipAssemblyKt.createNewShipWithBlocks((BlockPos)center, (DenseBlockPosSet)set, (ServerLevel)level);
    }

    public static ServerShip assembleBlock(ServerLevel level, BlockPos blockPos) {
        BlockState blockState = level.m_8055_(blockPos);
        if (VSGameUtilsKt.getShipManagingPos((ServerLevel)level, (BlockPos)blockPos) != null) {
            return null;
        }
        if (blockState.m_60795_()) {
            return null;
        }
        String dimensionId = VSGameUtilsKt.getDimensionId((Level)level);
        ServerShip serverShip = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).createNewShipAtBlock((Vector3ic)VectorConversionsMCKt.toJOML((Vec3i)blockPos), false, 1.0, dimensionId);
        BlockPos centerPos = VectorConversionsMCKt.toBlockPos((Vector3ic)serverShip.getChunkClaim().getCenterBlockCoordinates(VSGameUtilsKt.getYRange((Level)level), new Vector3i()));
        RelocationUtilKt.relocateBlock((Level)level, (BlockPos)blockPos, (BlockPos)centerPos, (boolean)true, (ServerShip)serverShip, (Rotation)Rotation.NONE);
        return serverShip;
    }
}

