/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.util;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcm.vsch.api.entity.ISpecialTeleportLogicEntity;
import net.jcm.vsch.api.event.PreShipTravelEvent;
import net.jcm.vsch.mixin.valkyrienskies.accessor.ServerShipObjectWorldAccessor;
import net.jcm.vsch.ship.ShipLandingAttachment;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.QueryableShipData;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ServerShipTransformProvider;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.ShipTeleportData;
import org.valkyrienskies.core.apigame.constraints.VSConstraint;
import org.valkyrienskies.core.apigame.physics.PhysicsEntityServer;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.core.impl.game.ShipTeleportDataImpl;
import org.valkyrienskies.core.impl.game.ships.ShipObjectServerWorld;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Mod.EventBusSubscriber
public class TeleportationHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"vsch");
    private static final double ENTITY_COLLECT_RANGE = 8.0;
    private static final double SHIP_COLLECT_RANGE = 10.0;
    private static Map<Long, Set<Integer>> SHIP2CONSTRAINTS;
    private static Map<Integer, VSConstraint> ID2CONSTRAINT;
    private final Long2ObjectOpenHashMap<TeleportData> ships = new Long2ObjectOpenHashMap();
    private final Map<Entity, Vec3> entityToPos = new HashMap<Entity, Vec3>();
    private ServerShipWorldCore shipWorld;
    private double greatestOffset;
    private ServerLevel oldLevel;
    private ServerLevel newLevel;
    private final boolean isReturning;

    public TeleportationHandler(ServerLevel oldLevel, ServerLevel newLevel, boolean isReturning) {
        this.shipWorld = newLevel == null ? null : VSGameUtilsKt.getShipObjectWorld((ServerLevel)newLevel);
        this.oldLevel = oldLevel;
        this.newLevel = newLevel;
        this.isReturning = isReturning;
    }

    @SubscribeEvent
    public static void onServerStart(ServerStartedEvent event) {
        ServerShipObjectWorldAccessor server = (ServerShipObjectWorldAccessor)VSGameUtilsKt.getShipObjectWorld((MinecraftServer)event.getServer());
        SHIP2CONSTRAINTS = server.getShipIdToConstraints();
        ID2CONSTRAINT = server.getConstraints();
    }

    public void reset(ServerLevel oldLevel, ServerLevel newLevel) {
        this.shipWorld = newLevel == null ? null : VSGameUtilsKt.getShipObjectWorld((ServerLevel)newLevel);
        this.oldLevel = oldLevel;
        this.newLevel = newLevel;
        this.ships.clear();
        this.entityToPos.clear();
    }

    public boolean hasShip(ServerShip ship) {
        return this.ships.containsKey(ship.getId());
    }

    public void addShip(ServerShip ship, Vector3dc newPos, Quaterniondc rotation) {
        this.addShipWithVelocity(ship, newPos, rotation, null, null);
    }

    public void addShipWithVelocity(ServerShip ship, Vector3dc newPos, Quaterniondc rotation, Vector3dc velocity, Vector3dc omega) {
        long shipId = ship.getId();
        if (this.ships.containsKey(shipId)) {
            return;
        }
        this.greatestOffset = 0.0;
        ArrayList<ServerShip> collected = new ArrayList<ServerShip>();
        Vector3dc origin = ship.getTransform().getPositionInWorld();
        this.collectShipAndConnectedWithVelocity(shipId, origin, newPos, rotation, velocity, omega, collected);
        this.collectNearbyShips(collected, origin, newPos, rotation);
        this.collectNearbyEntities(collected, origin, newPos, rotation);
        this.finalizeCollect(collected, rotation);
    }

    public List<LoadedServerShip> getPendingShips() {
        ArrayList<LoadedServerShip> ships = new ArrayList<LoadedServerShip>(this.ships.size());
        LongIterator longIterator = this.ships.keySet().iterator();
        while (longIterator.hasNext()) {
            long id = (Long)longIterator.next();
            LoadedServerShip ship = (LoadedServerShip)this.shipWorld.getLoadedShips().getById(id);
            if (ship == null) continue;
            ships.add(ship);
        }
        return ships;
    }

    private void collectShipAndConnected(long shipId, Vector3dc origin, Vector3dc newPos, Quaterniondc rotation, List<ServerShip> collected) {
        this.collectShipAndConnectedWithVelocity(shipId, origin, newPos, rotation, null, null, collected);
    }

    private void collectShipAndConnectedWithVelocity(long shipId, Vector3dc origin, Vector3dc newPos, Quaterniondc rotation, Vector3dc velocity, Vector3dc omega, List<ServerShip> collected) {
        double offset;
        if (this.ships.containsKey(shipId)) {
            return;
        }
        ServerShip ship = this.getShip(shipId);
        if (ship == null) {
            return;
        }
        Vector3dc pos = ship.getTransform().getPositionInWorld();
        ShipLandingAttachment landingAttachment = (ShipLandingAttachment)ship.getAttachment(ShipLandingAttachment.class);
        if (ship.isStatic() && landingAttachment.freezed) {
            velocity = landingAttachment.velocity;
            omega = landingAttachment.omega;
        } else {
            if (velocity == null) {
                velocity = new Vector3d(ship.getVelocity());
            }
            if (omega == null) {
                omega = new Vector3d(ship.getOmega());
            }
        }
        collected.add(ship);
        Vector3d relPos = pos.sub(origin, new Vector3d());
        Quaterniond newRotataion = new Quaterniond(ship.getTransform().getShipToWorldRotation());
        if (!this.isReturning && (offset = relPos.y) < this.greatestOffset) {
            this.greatestOffset = offset;
        }
        rotation.transform(relPos);
        velocity = rotation.transform(velocity, new Vector3d());
        newRotataion.mul(rotation).normalize();
        if (this.isReturning && (offset = relPos.y) > this.greatestOffset) {
            this.greatestOffset = offset;
        }
        relPos.add(newPos);
        Vector3d velocity0 = new Vector3d(velocity);
        Vector3d omega0 = new Vector3d(omega);
        MinecraftForge.EVENT_BUS.post((Event)this.createPreShipTravelEvent(ship, (ResourceKey<Level>)this.oldLevel.m_46472_(), (ResourceKey<Level>)this.newLevel.m_46472_(), (Vector3dc)relPos, (Quaterniondc)newRotataion, velocity0, omega0));
        this.ships.put(shipId, (Object)new TeleportData(relPos, newRotataion, (Vector3dc)velocity0, (Vector3dc)omega0));
        Set<Integer> constraints = SHIP2CONSTRAINTS.get(shipId);
        if (constraints != null) {
            constraints.stream().map(ID2CONSTRAINT::get).forEach(constraint -> {
                this.collectShipAndConnected(constraint.getShipId0(), origin, newPos, rotation, collected);
                this.collectShipAndConnected(constraint.getShipId1(), origin, newPos, rotation, collected);
            });
        }
    }

    private void collectNearbyShips(List<ServerShip> collected, Vector3dc origin, Vector3dc newPos, Quaterniondc rotation) {
        QueryableShipData loadedShips = this.shipWorld.getLoadedShips();
        Vector3d offset = newPos.sub(origin, new Vector3d());
        for (int i = 0; i < collected.size(); ++i) {
            AABBdc shipBox = collected.get(i).getWorldAABB();
            AABBd box = new AABBd(shipBox.minX() - 10.0, shipBox.minY() - 10.0, shipBox.minZ() - 10.0, shipBox.maxX() + 10.0, shipBox.maxY() + 10.0, shipBox.maxZ() + 10.0);
            for (ServerShip ship : loadedShips.getIntersecting((AABBdc)box)) {
                this.collectShipAndConnected(ship.getId(), origin, newPos, rotation, collected);
            }
        }
    }

    private void collectNearbyEntities(List<ServerShip> collected, Vector3dc origin, Vector3dc newPos, Quaterniondc rotation) {
        for (ServerShip ship : collected) {
            this.collectEntities(ship, origin, newPos, rotation);
        }
    }

    private void finalizeCollect(List<ServerShip> collected, Quaterniondc rotation) {
        Vector3d offset = new Vector3d(0.0, -this.greatestOffset, 0.0);
        if (!this.isReturning) {
            rotation.transform(offset);
        }
        for (ServerShip ship : collected) {
            long id = ship.getId();
            Vector3d newPos = ((TeleportData)this.ships.get(id)).newPos();
            newPos.add((Vector3dc)offset);
        }
    }

    public void finalizeTeleport() {
        int size = this.ships.size();
        if (size == 0) {
            return;
        }
        this.ships.forEach(this::handleShipTeleport);
        this.ships.clear();
        if (size >= 256) {
            this.ships.trim(32);
        }
        this.teleportEntities();
    }

    private void collectEntities(ServerShip ship, Vector3dc origin, Vector3dc newPos, Quaterniondc rotation) {
        AABBd shipBoxd = new AABBd(ship.getWorldAABB());
        AABBic shipBoxi = ship.getShipAABB();
        if (shipBoxi != null) {
            AABBd shipYardBox = new AABBd((double)shipBoxi.minX(), (double)shipBoxi.minY(), (double)shipBoxi.minZ(), (double)shipBoxi.maxX(), (double)shipBoxi.maxY(), (double)shipBoxi.maxZ());
            for (Entity entity2 : this.oldLevel.m_6249_((Entity)null, new AABB(shipYardBox.minX - 64.0, shipYardBox.minY - 64.0, shipYardBox.minZ - 64.0, shipYardBox.maxX + 64.0, shipYardBox.maxY + 64.0, shipYardBox.maxZ + 64.0), entity -> !this.entityToPos.containsKey(entity))) {
                this.collectEntity(entity2, origin, newPos, rotation);
            }
            shipBoxd.union((AABBdc)shipYardBox.transform(ship.getPrevTickTransform().getShipToWorld()));
        }
        AABB inflatedBox = new AABB(shipBoxd.minX - 8.0, shipBoxd.minY - 8.0, shipBoxd.minZ - 8.0, shipBoxd.maxX + 8.0, shipBoxd.maxY + 8.0, shipBoxd.maxZ + 8.0);
        for (Entity entity2 : this.oldLevel.m_6249_((Entity)null, inflatedBox, entity -> !this.entityToPos.containsKey(entity))) {
            this.collectEntity(entity2, origin, newPos, rotation);
        }
    }

    private void collectEntity(Entity entity, Vector3dc origin, Vector3dc newPos, Quaterniondc rotation) {
        Entity root = entity.m_20201_();
        if (this.entityToPos.containsKey(root)) {
            return;
        }
        Vec3 pos = root.m_20182_();
        if (!VSGameUtilsKt.isBlockInShipyard((Level)this.oldLevel, (Vec3)pos)) {
            Vector3d relPos = new Vector3d(pos.f_82479_, pos.f_82480_, pos.f_82481_).sub(origin);
            rotation.transform(relPos);
            relPos.add(newPos);
            pos = new Vec3(relPos.x, relPos.y, relPos.z);
        }
        this.entityToPos.put(root, pos);
    }

    private void teleportEntities() {
        this.entityToPos.keySet().forEach(entity -> {
            if (entity instanceof ISpecialTeleportLogicEntity) {
                ISpecialTeleportLogicEntity specialEntity = (ISpecialTeleportLogicEntity)entity;
                specialEntity.starlance$beforeTeleport();
            }
        });
        this.entityToPos.forEach((entity, newPos) -> TeleportationHandler.teleportToWithPassengers(entity, this.newLevel, newPos));
        this.entityToPos.clear();
    }

    private void handleShipTeleport(final long id, TeleportData data) {
        String vsDimName = VSGameUtilsKt.getDimensionId((Level)this.newLevel);
        Vector3d newPos = data.newPos();
        Quaterniond rotation = data.rotation();
        final Vector3dc velocity = data.velocity();
        final Vector3dc omega = data.omega();
        LoadedServerShip ship = (LoadedServerShip)this.shipWorld.getLoadedShips().getById(id);
        if (ship == null) {
            PhysicsEntityServer physEntity = (PhysicsEntityServer)((ShipObjectServerWorld)this.shipWorld).getLoadedPhysicsEntities().get(id);
            if (physEntity == null) {
                LOGGER.warn("[starlance]: Failed to teleport physics object with id " + id + "! It's neither a Ship nor a Physics Entity!");
                return;
            }
            LOGGER.info("[starlance]: Teleporting physics entity {} to {} {}", (Object)id, (Object)vsDimName, (Object)newPos);
            ShipTeleportDataImpl teleportData = new ShipTeleportDataImpl((Vector3dc)newPos, physEntity.getShipTransform().getShipToWorldRotation(), physEntity.getLinearVelocity(), physEntity.getAngularVelocity(), vsDimName, null);
            this.shipWorld.teleportPhysicsEntity(physEntity, (ShipTeleportData)teleportData);
            return;
        }
        LOGGER.info("[starlance]: Teleporting ship {} ({}) to {} {}", (Object)ship.getSlug(), (Object)id, (Object)vsDimName, (Object)newPos);
        ship.setStatic(false);
        ShipTeleportDataImpl teleportData = new ShipTeleportDataImpl((Vector3dc)newPos, (Quaterniondc)rotation, velocity, omega, vsDimName, null);
        this.shipWorld.teleportShip((ServerShip)ship, (ShipTeleportData)teleportData);
        if (velocity.lengthSquared() != 0.0 || omega.lengthSquared() != 0.0) {
            ship.setTransformProvider(new ServerShipTransformProvider(){

                public ServerShipTransformProvider.NextTransformAndVelocityData provideNextTransformAndVelocity(ShipTransform prevTransform, ShipTransform transform) {
                    LoadedServerShip ship2 = (LoadedServerShip)TeleportationHandler.this.shipWorld.getLoadedShips().getById(id);
                    if (!prevTransform.getPositionInWorld().equals(transform.getPositionInWorld()) || !prevTransform.getShipToWorldRotation().equals(transform.getShipToWorldRotation())) {
                        ship2.setTransformProvider(null);
                        return null;
                    }
                    if (ship2.getVelocity().lengthSquared() == 0.0 && ship2.getOmega().lengthSquared() == 0.0) {
                        return new ServerShipTransformProvider.NextTransformAndVelocityData(transform, velocity, omega);
                    }
                    return null;
                }
            });
        }
    }

    private static <T extends Entity> T teleportToWithPassengers(T entity, ServerLevel newLevel, Vec3 newPos) {
        Object newEntity;
        Vec3 oldPos = entity.m_20182_();
        ArrayList passengers = new ArrayList(entity.m_20197_());
        passengers.forEach(e -> {
            if (e instanceof ISpecialTeleportLogicEntity) {
                ISpecialTeleportLogicEntity specialEntity = (ISpecialTeleportLogicEntity)e;
                specialEntity.starlance$beforeTeleport();
            }
        });
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.m_8999_(newLevel, newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, player.m_146908_(), player.m_146909_());
            newEntity = entity;
        } else {
            newEntity = entity.m_6095_().m_20615_((Level)newLevel);
            if (newEntity == null) {
                if (entity instanceof ISpecialTeleportLogicEntity) {
                    ISpecialTeleportLogicEntity specialEntity = (ISpecialTeleportLogicEntity)entity;
                    specialEntity.starlance$afterTeleport(null);
                }
                return null;
            }
            entity.m_20153_();
            newEntity.m_20361_(entity);
            newEntity.m_7678_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, newEntity.m_146908_(), newEntity.m_146909_());
            newEntity.m_5616_(entity.m_6080_());
            newEntity.m_5618_(entity.m_213816_());
            newLevel.m_143334_(newEntity);
            entity.m_142467_(Entity.RemovalReason.CHANGED_DIMENSION);
        }
        for (Entity p : passengers) {
            Entity newPassenger = TeleportationHandler.teleportToWithPassengers(p, newLevel, p.m_20182_().m_82546_(oldPos).m_82549_(newPos));
            if (newPassenger == null) continue;
            newPassenger.m_7998_(newEntity, true);
        }
        if (newEntity instanceof ISpecialTeleportLogicEntity) {
            ISpecialTeleportLogicEntity specialEntity = (ISpecialTeleportLogicEntity)newEntity;
            specialEntity.starlance$afterTeleport((ISpecialTeleportLogicEntity)entity);
        }
        return (T)newEntity;
    }

    private ServerShip getShip(long shipId) {
        ServerShip ship = (ServerShip)this.shipWorld.getLoadedShips().getById(shipId);
        if (ship != null) {
            return ship;
        }
        return (ServerShip)this.shipWorld.getAllShips().getById(shipId);
    }

    private PreShipTravelEvent createPreShipTravelEvent(ServerShip ship, ResourceKey<Level> oldLevel, ResourceKey<Level> newLevel, Vector3dc position, Quaterniondc rotation, Vector3d velocity, Vector3d omega) {
        return this.isReturning ? new PreShipTravelEvent.SpaceToPlanet(ship, oldLevel, newLevel, position, rotation, velocity, omega) : new PreShipTravelEvent.PlanetToSpace(ship, oldLevel, newLevel, position, rotation, velocity, omega);
    }

    private record TeleportData(Vector3d newPos, Quaterniond rotation, Vector3dc velocity, Vector3dc omega) {
    }
}

