/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.util.rot;

import java.util.Arrays;
import java.util.List;
import net.jcm.vsch.util.rot.RotShape;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RotShapes {
    public static RotShape cube() {
        return RotShapes.box(0.1, 0.1, 0.1, 15.9, 15.9, 15.9);
    }

    public static RotShape solid() {
        return RotShapes.box(0.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    }

    public static RotShape box(double x1, double y1, double z1, double x2, double y2, double z2) {
        return new Box(x1, y1, z1, x2, y2, z2);
    }

    public static RotShape or(RotShape ... shapes) {
        return new Union(Arrays.asList(shapes));
    }

    private static class Box
    implements RotShape {
        private final double x1;
        private final double y1;
        private final double z1;
        private final double x2;
        private final double y2;
        private final double z2;

        private Box(double x1, double y1, double z1, double x2, double y2, double z2) {
            this.x1 = x1;
            this.y1 = y1;
            this.z1 = z1;
            this.x2 = x2;
            this.y2 = y2;
            this.z2 = z2;
        }

        @Override
        public RotShape rotate90() {
            return new Box(16.0 - this.z1, this.y1, this.x1, 16.0 - this.z2, this.y2, this.x2);
        }

        @Override
        public RotShape xrotate90() {
            return new Box(this.x1, 16.0 - this.z1, this.y1, this.x2, 16.0 - this.z2, this.y2);
        }

        @Override
        public VoxelShape makeMcShape() {
            return Shapes.m_83048_((double)(Math.min(this.x1, this.x2) / 16.0), (double)(Math.min(this.y1, this.y2) / 16.0), (double)(Math.min(this.z1, this.z2) / 16.0), (double)(Math.max(this.x1, this.x2) / 16.0), (double)(Math.max(this.y1, this.y2) / 16.0), (double)(Math.max(this.z1, this.z2) / 16.0));
        }
    }

    private static class Union
    implements RotShape {
        private final List<RotShape> shapes;

        private Union(List<RotShape> shapes) {
            this.shapes = shapes;
        }

        @Override
        public RotShape rotate90() {
            return new Union(this.shapes.stream().map(RotShape::rotate90).toList());
        }

        @Override
        public RotShape xrotate90() {
            return new Union(this.shapes.stream().map(RotShape::xrotate90).toList());
        }

        @Override
        public VoxelShape makeMcShape() {
            VoxelShape aggregate = Shapes.m_83040_();
            for (RotShape sh : this.shapes) {
                aggregate = Shapes.m_83110_((VoxelShape)aggregate, (VoxelShape)sh.makeMcShape());
            }
            return aggregate;
        }
    }
}

