/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.util.wapi;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.jcm.vsch.util.wapi.LevelData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;

public class PlanetData {
    private final LevelData levelData;
    private final BiConsumer<String, Consumer<CompoundTag>> dataUpdater;
    private Vec3 position;
    private double size;
    private Quaterniondc rotation;

    private PlanetData(LevelData levelData, BiConsumer<String, Consumer<CompoundTag>> dataUpdater) {
        this.levelData = levelData;
        this.dataUpdater = dataUpdater;
    }

    public static PlanetData create(LevelData levelData, BiConsumer<String, Consumer<CompoundTag>> dataUpdater, CompoundTag collisionData) {
        PlanetData data = new PlanetData(levelData, dataUpdater);
        data.position = new Vec3(collisionData.m_128459_("x"), collisionData.m_128459_("y"), collisionData.m_128459_("z"));
        data.size = collisionData.m_128459_("scale");
        data.rotation = new Quaterniond().rotationYXZ(Math.toRadians(collisionData.m_128459_("yaw")), Math.toRadians(collisionData.m_128459_("pitch")), Math.toRadians(collisionData.m_128459_("roll")));
        return data;
    }

    public LevelData getLevelData() {
        return this.levelData;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public void setPosition(Vec3 position) {
        this.position = position;
        this.dataUpdater.accept("position", collisionData -> {
            collisionData.m_128347_("x", position.f_82479_);
            collisionData.m_128347_("y", position.f_82480_);
            collisionData.m_128347_("z", position.f_82481_);
        });
    }

    public double getSize() {
        return this.size;
    }

    public Quaterniondc getRotation() {
        return this.rotation;
    }

    public void setRotation(Quaterniondc rotation) {
        this.rotation = rotation;
        this.dataUpdater.accept("rotation", collisionData -> {
            Vector3d angles = rotation.getEulerAnglesYXZ(new Vector3d());
            collisionData.m_128347_("yaw", Math.toDegrees(angles.y));
            collisionData.m_128347_("pitch", Math.toDegrees(angles.x));
            collisionData.m_128347_("roll", Math.toDegrees(angles.z));
        });
    }
}

