/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.blocks;

import java.util.function.Supplier;
import net.jcm.vsch.blocks.custom.BaseThrusterBlock;
import net.jcm.vsch.blocks.custom.DragInducerBlock;
import net.jcm.vsch.blocks.custom.GravityInducerBlock;
import net.jcm.vsch.blocks.custom.GyroBlock;
import net.jcm.vsch.blocks.custom.VentBlock;
import net.jcm.vsch.blocks.entity.AirThrusterBlockEntity;
import net.jcm.vsch.blocks.entity.CreativeThrusterBlockEntity;
import net.jcm.vsch.blocks.entity.PowerfulThrusterBlockEntity;
import net.jcm.vsch.blocks.entity.ThrusterBlockEntity;
import net.jcm.vsch.blocks.rocketassembler.RocketAssemblerBlock;
import net.jcm.vsch.items.VSCHItems;
import net.jcm.vsch.util.rot.DirectionalShape;
import net.jcm.vsch.util.rot.RotShapes;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class VSCHBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"vsch");
    public static final RegistryObject<Block> VENT_BLOCK = VSCHBlocks.registerBlock("vent_block", () -> new VentBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_154663_).m_60978_(5.0f).m_60955_()));
    public static final RegistryObject<Block> THRUSTER_BLOCK = VSCHBlocks.registerBlock("thruster_block", () -> new BaseThrusterBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_154663_).m_60978_(5.0f).m_60955_(), DirectionalShape.down(RotShapes.solid()), ThrusterBlockEntity::new));
    public static final RegistryObject<Block> AIR_THRUSTER_BLOCK = VSCHBlocks.registerBlock("air_thruster_block", () -> new BaseThrusterBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_154663_).m_60978_(5.0f).m_60955_(), DirectionalShape.down(RotShapes.box(3.0, 0.0, 3.0, 13.0, 8.0, 13.0)), AirThrusterBlockEntity::new));
    public static final RegistryObject<Block> POWERFUL_THRUSTER_BLOCK = VSCHBlocks.registerBlock("powerful_thruster_block", () -> new BaseThrusterBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_154663_).m_60978_(5.0f).m_60955_(), DirectionalShape.down(RotShapes.solid()), PowerfulThrusterBlockEntity::new));
    public static final RegistryObject<Block> CREATIVE_THRUSTER_BLOCK = VSCHBlocks.registerBlock("creative_thruster_block", () -> new BaseThrusterBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_154663_).m_60978_(5.0f).m_60955_(), DirectionalShape.down(RotShapes.solid()), CreativeThrusterBlockEntity::new));
    public static final RegistryObject<Block> DRAG_INDUCER_BLOCK = VSCHBlocks.registerBlock("drag_inducer_block", () -> new DragInducerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_154663_).m_60978_(5.0f).m_60955_()));
    public static final RegistryObject<Block> GRAVITY_INDUCER_BLOCK = VSCHBlocks.registerBlock("gravity_inducer_block", () -> new GravityInducerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_154663_).m_60978_(5.0f).m_60955_()));
    public static final RegistryObject<Block> GYRO_BLOCK = VSCHBlocks.registerBlock("gyro", () -> new GyroBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60918_(SoundType.f_56749_).m_60913_(5.0f, 3.0f).m_60955_()));
    public static final RegistryObject<Block> ROCKET_ASSEMBLER_BLOCK = VSCHBlocks.registerBlock("rocket_assembler", () -> new RocketAssemblerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50074_).m_284180_(MapColor.f_283947_).m_60918_(SoundType.f_56749_).m_60978_(5.0f).m_60924_((state, level, pos) -> false)));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        VSCHBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return VSCHItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

