/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.blocks.custom.template;

import java.util.UUID;
import net.jcm.vsch.blocks.entity.template.ParticleBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class BlockEntityWithEntity<E extends Entity>
extends BlockEntity
implements ParticleBlockEntity {
    private UUID entityUUID;

    public BlockEntityWithEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void spawnLinkedEntity() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.entityUUID != null) {
            this.removeLinkedEntity();
        }
        this.spawnLinkedEntityImpl(serverLevel, this.m_58899_());
    }

    public void spawnLinkedEntityIfNeeded() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.entityUUID != null) {
            return;
        }
        this.spawnLinkedEntityImpl(serverLevel, this.m_58899_());
    }

    private E spawnLinkedEntityImpl(ServerLevel level, BlockPos blockPos) {
        E entity = this.createLinkedEntity(level, blockPos);
        entity.m_146884_(Vec3.m_82512_((Vec3i)blockPos));
        level.m_7967_(entity);
        this.entityUUID = entity.m_20148_();
        return entity;
    }

    public void removeLinkedEntity() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.entityUUID == null) {
            return;
        }
        Entity entity = serverLevel.m_8791_(this.entityUUID);
        this.entityUUID = null;
        if (entity != null) {
            entity.m_146870_();
        }
    }

    public abstract E createLinkedEntity(ServerLevel var1, BlockPos var2);

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.entityUUID != null) {
            tag.m_128362_("EntityUUID", this.entityUUID);
        }
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128403_("EntityUUID")) {
            this.entityUUID = tag.m_128342_("EntityUUID");
        }
        super.m_142466_(tag);
    }

    @Override
    public void tickParticles(Level level, BlockPos pos, BlockState state) {
    }

    @Override
    public void tickForce(ServerLevel level, BlockPos pos, BlockState state) {
        if (this.entityUUID == null) {
            return;
        }
        Entity entity = level.m_8791_(this.entityUUID);
        if (entity == null) {
            return;
        }
        entity.m_146884_(Vec3.m_82512_((Vec3i)this.m_58899_()));
    }
}

