/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.blocks.entity;

import java.util.List;
import net.jcm.vsch.blocks.entity.VSCHBlockEntities;
import net.jcm.vsch.blocks.thruster.AbstractThrusterBlockEntity;
import net.jcm.vsch.blocks.thruster.ThrusterEngine;
import net.jcm.vsch.blocks.thruster.ThrusterEngineContext;
import net.jcm.vsch.config.VSCHServerConfig;
import net.lointain.cosmos.init.CosmosModParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class AirThrusterBlockEntity
extends AbstractThrusterBlockEntity {
    public AirThrusterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)VSCHBlockEntities.AIR_THRUSTER_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    protected String getPeripheralType() {
        return "air_thruster";
    }

    @Override
    protected ThrusterEngine createThrusterEngine() {
        return new AirThrusterEngine((int)((Integer)VSCHServerConfig.AIR_THRUSTER_ENERGY_CONSUME_RATE.get()), ((Number)VSCHServerConfig.AIR_THRUSTER_STRENGTH.get()).floatValue(), (Integer)VSCHServerConfig.AIR_THRUSTER_MAX_WATER_CONSUME_RATE.get());
    }

    @Override
    protected ParticleOptions getThrusterParticleType() {
        return (ParticleOptions)CosmosModParticleTypes.AIR_THRUST.get();
    }

    @Override
    protected ParticleOptions getThrusterSmokeParticleType() {
        return (ParticleOptions)CosmosModParticleTypes.AIR_THRUST.get();
    }

    @Override
    protected double getEvaporateDistance() {
        return 1.0 * this.getCurrentPower();
    }

    @Override
    protected void spawnParticles(Vector3d pos, Vector3d direction) {
        Vector3d speed = new Vector3d((Vector3dc)direction).mul(this.getCurrentPower());
        speed.mul(0.118);
        int amount = 100;
        for (int i = 0; i < amount; ++i) {
            this.f_58857_.m_7106_(this.getThrusterParticleType(), pos.x, pos.y, pos.z, speed.x, speed.y, speed.z);
        }
    }

    private static final class AirThrusterEngine
    extends ThrusterEngine {
        private final int maxWaterConsumeRate;

        public AirThrusterEngine(int energyConsumeRate, float maxThrottle, int maxWaterConsumeRate) {
            super(1, energyConsumeRate, maxThrottle);
            this.maxWaterConsumeRate = maxWaterConsumeRate;
        }

        @Override
        public boolean isValidFuel(int tank, Fluid fluid) {
            return fluid == Fluids.f_76193_;
        }

        @Override
        public void tick(ThrusterEngineContext context) {
            super.tick(context);
            if (this.maxWaterConsumeRate == 0) {
                return;
            }
            double power = context.getPower();
            if (power == 0.0) {
                return;
            }
            double density = AirThrusterEngine.getLevelAirDensity(context.getLevel());
            if (density >= 1.0) {
                return;
            }
            double scale = context.getScale();
            int amount = context.getAmount();
            double waterConsumeRate = (double)this.maxWaterConsumeRate * (1.0 - density);
            int needsWater = (int)Math.ceil(waterConsumeRate * power * scale * (double)amount);
            int avaliableWater = context.getFluidHandler().drain(new FluidStack((Fluid)Fluids.f_76193_, needsWater), IFluidHandler.FluidAction.SIMULATE).getAmount();
            context.setPower((double)avaliableWater / (waterConsumeRate * (double)amount));
            context.addConsumer(ctx -> {
                int water = (int)Math.ceil((double)this.maxWaterConsumeRate * (1.0 - density) * ctx.getPower() * ctx.getScale() * (double)ctx.getAmount());
                ctx.getFluidHandler().drain(new FluidStack((Fluid)Fluids.f_76193_, water), IFluidHandler.FluidAction.EXECUTE);
            });
        }

        @Override
        public void tickBurningObjects(ThrusterEngineContext context, List<BlockPos> thrusters, Direction direction) {
        }

        private static double getLevelAirDensity(ServerLevel level) {
            if (level.m_46472_() == Level.f_46428_) {
                return 1.0;
            }
            if (level.m_46472_() == Level.f_46429_) {
                return 1.2;
            }
            if (level.m_46472_() == Level.f_46430_) {
                return 0.0;
            }
            return 0.0;
        }
    }
}

