/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.blocks.entity;

import java.util.List;
import net.jcm.vsch.VSCHTags;
import net.jcm.vsch.blocks.entity.VSCHBlockEntities;
import net.jcm.vsch.blocks.thruster.AbstractThrusterBlockEntity;
import net.jcm.vsch.blocks.thruster.ThrusterEngine;
import net.jcm.vsch.blocks.thruster.ThrusterEngineContext;
import net.jcm.vsch.config.VSCHServerConfig;
import net.lointain.cosmos.init.CosmosModParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class PowerfulThrusterBlockEntity
extends AbstractThrusterBlockEntity {
    private static final int HYDROGEN_SLOT = 0;
    private static final int OXYGEN_SLOT = 1;

    public PowerfulThrusterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)VSCHBlockEntities.POWERFUL_THRUSTER_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    protected String getPeripheralType() {
        return "powerful_thruster";
    }

    @Override
    protected ThrusterEngine createThrusterEngine() {
        return new PowerfulThrusterEngine((int)((Integer)VSCHServerConfig.POWERFUL_THRUSTER_ENERGY_CONSUME_RATE.get()), ((Number)VSCHServerConfig.POWERFUL_THRUSTER_STRENGTH.get()).floatValue(), (Integer)VSCHServerConfig.POWERFUL_THRUSTER_FUEL_CONSUME_RATE.get());
    }

    @Override
    protected ParticleOptions getThrusterParticleType() {
        return (ParticleOptions)CosmosModParticleTypes.BLUETHRUSTED.get();
    }

    @Override
    protected double getEvaporateDistance() {
        return 8.0 * this.getCurrentPower();
    }

    private static final class PowerfulThrusterEngine
    extends ThrusterEngine {
        private final int fuelConsumeRate;

        public PowerfulThrusterEngine(int energyConsumeRate, float maxThrottle, int fuelConsumeRate) {
            super(2, energyConsumeRate, maxThrottle);
            this.fuelConsumeRate = fuelConsumeRate;
        }

        @Override
        public boolean isValidFuel(int slot, Fluid fluid) {
            return switch (slot) {
                case 0 -> fluid.m_205067_(VSCHTags.Fluids.HYDROGEN);
                case 1 -> fluid.m_205067_(VSCHTags.Fluids.OXYGEN);
                default -> throw new IllegalArgumentException("fluid slot is not in range [0, 1]");
            };
        }

        @Override
        public void tick(ThrusterEngineContext context) {
            super.tick(context);
            if (this.fuelConsumeRate == 0) {
                return;
            }
            double power = context.getPower();
            if (power == 0.0) {
                return;
            }
            double scale = context.getScale();
            int amount = context.getAmount();
            int needsOxygen = (int)Math.ceil((double)this.fuelConsumeRate * power * scale * (double)amount);
            int needsHydrogen = needsOxygen * 2;
            IFluidHandler fluidHandler = context.getFluidHandler();
            FluidStack oxygenStack = fluidHandler.getFluidInTank(1);
            FluidStack hydrogenStack = fluidHandler.getFluidInTank(0);
            int avaliableHydrogen = Math.min(needsHydrogen, hydrogenStack.getAmount());
            int avaliableOxygen = Math.min(avaliableHydrogen / 2, Math.min(needsOxygen, oxygenStack.getAmount()));
            if (avaliableOxygen == 0) {
                context.setPower(0.0);
                return;
            }
            context.setPower((double)avaliableOxygen / ((double)this.fuelConsumeRate * (double)amount));
            context.addConsumer(ctx -> {
                IFluidHandler tanks = ctx.getFluidHandler();
                int oxygen = (int)Math.ceil((double)this.fuelConsumeRate * ctx.getPower() * ctx.getScale() * (double)ctx.getAmount());
                int hydrogen = oxygen * 2;
                tanks.drain(new FluidStack(oxygenStack.getFluid(), oxygen), IFluidHandler.FluidAction.EXECUTE);
                tanks.drain(new FluidStack(hydrogenStack.getFluid(), hydrogen), IFluidHandler.FluidAction.EXECUTE);
            });
        }

        @Override
        public void tickBurningObjects(ThrusterEngineContext context, List<BlockPos> thrusters, Direction direction) {
            PowerfulThrusterEngine.simpleTickBurningObjects(context, thrusters, direction, 8.0, 5, 0.3);
        }
    }
}

