/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.blocks.rocketassembler;

import com.simibubi.create.content.contraptions.actors.seat.SeatEntity;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import dan200.computercraft.shared.Capabilities;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Queue;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.jcm.vsch.blocks.entity.VSCHBlockEntities;
import net.jcm.vsch.blocks.entity.template.ParticleBlockEntity;
import net.jcm.vsch.blocks.rocketassembler.AssembleResult;
import net.jcm.vsch.blocks.rocketassembler.RocketAssemblerBlock;
import net.jcm.vsch.blocks.rocketassembler.RocketAssemblerPeripheral;
import net.jcm.vsch.compat.CompatMods;
import net.jcm.vsch.config.VSCHServerConfig;
import net.jcm.vsch.util.Pair;
import net.jcm.vsch.util.assemble.IMoveable;
import net.jcm.vsch.util.assemble.MoveUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.joml.primitives.AABBi;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ServerShipTransformProvider;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.ShipTeleportData;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.core.impl.game.ShipTeleportDataImpl;
import org.valkyrienskies.core.impl.game.ships.ShipTransformImpl;
import org.valkyrienskies.core.util.datastructures.DenseBlockPosSet;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class RocketAssemblerBlockEntity
extends BlockEntity
implements ParticleBlockEntity {
    private static final int MAX_SIZE = 4096;
    private boolean triggering = false;
    private volatile AssembleResult assembleResult = AssembleResult.SUCCESS;
    private String shipSlug = null;
    private int energyStored = 0;
    private final int energyConsumption = (Integer)VSCHServerConfig.ASSEMBLER_ENERGY_CONSUMPTION.get();
    private final Queue<BlockPos> queueing = new ArrayDeque<BlockPos>();
    private final DenseBlockPosSet blocks = new DenseBlockPosSet();
    private final DenseBlockPosSet checked = new DenseBlockPosSet();
    private final AABBi box = new AABBi();
    final IEnergyStorage energyStorage = new EnergyStorage();
    private final LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
    private final LazyOptional<Object> lazyPeripheral = LazyOptional.of(() -> {
        RocketAssemblerPeripheral peripheral = new RocketAssemblerPeripheral(this);
        this.assembleFinishCallback = peripheral::onAssembleFinish;
        return peripheral;
    });
    private Runnable assembleFinishCallback = null;

    public RocketAssemblerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)VSCHBlockEntities.ROCKET_ASSEMBLER_BLOCK_ENTITY.get(), pos, state);
    }

    public boolean isAssembling() {
        return this.assembleResult.isWorking();
    }

    public boolean isAssembleSuccessed() {
        return this.assembleResult.isSuccess();
    }

    public int getEnergyConsumption() {
        return this.energyConsumption;
    }

    public AssembleResult getAssembleResult() {
        return this.assembleResult;
    }

    private void setAssembleResult(AssembleResult result) {
        if (this.assembleResult == result) {
            return;
        }
        this.assembleResult = result;
        this.m_6596_();
        this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(RocketAssemblerBlock.LED, (Comparable)((Object)result.getLED())), 3);
    }

    public void m_142466_(CompoundTag data) {
        this.energyStored = data.m_128451_("EnergyStored");
        try {
            this.assembleResult = AssembleResult.valueOf(data.m_128461_("AssembleResult"));
        }
        catch (IllegalArgumentException e) {
            this.assembleResult = AssembleResult.SUCCESS;
        }
    }

    public void m_183515_(CompoundTag data) {
        data.m_128405_("EnergyStored", this.energyStored);
        this.saveShared(data);
    }

    public void saveShared(CompoundTag data) {
        data.m_128359_("AssembleResult", this.assembleResult.toString());
    }

    public CompoundTag m_5995_() {
        CompoundTag data = super.m_5995_();
        this.saveShared(data);
        return data;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void neighborChanged(Block neighbor, BlockPos neighborPos, boolean moving) {
        Level level = this.m_58904_();
        BlockPos pos = this.m_58899_();
        boolean shouldTrigger = Direction.m_235666_().filter(dir -> dir != this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_)).anyMatch(dir -> level.m_277185_(pos.m_121945_(dir), dir) > 0);
        if (this.triggering == shouldTrigger) {
            return;
        }
        this.triggering = shouldTrigger;
        if (shouldTrigger) {
            this.assemble(null);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction direction) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        if (CompatMods.COMPUTERCRAFT.isLoaded() && cap == Capabilities.CAPABILITY_PERIPHERAL) {
            return this.lazyPeripheral.cast();
        }
        return super.getCapability(cap, direction);
    }

    @Override
    public void tickForce(ServerLevel level, BlockPos pos, BlockState state) {
        if (this.isAssembling()) {
            this.assembleTick(level);
        }
    }

    @Override
    public void tickParticles(Level level, BlockPos pos, BlockState state) {
    }

    boolean assemble(String slug) {
        if (this.isAssembling()) {
            return false;
        }
        if (this.energyStored < this.energyConsumption) {
            this.finishAssemble(AssembleResult.NO_ENERGY);
            return true;
        }
        this.setAssembleResult(AssembleResult.WORKING);
        this.shipSlug = slug;
        this.queueing.clear();
        this.blocks.clear();
        this.checked.clear();
        BlockPos facingBlockPos = this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_));
        this.queueing.add(facingBlockPos);
        this.box.setMin(facingBlockPos.m_123341_(), facingBlockPos.m_123342_(), facingBlockPos.m_123343_()).setMax(facingBlockPos.m_123341_(), facingBlockPos.m_123342_(), facingBlockPos.m_123343_());
        return true;
    }

    private void finishAssemble(AssembleResult result) {
        this.setAssembleResult(result);
        this.shipSlug = null;
        this.queueing.clear();
        this.blocks.clear();
        this.checked.clear();
        if (this.assembleFinishCallback != null) {
            this.assembleFinishCallback.run();
        }
    }

    private void assembleTick(ServerLevel level) {
        block7: {
            BlockPos selfPos = this.m_58899_();
            int ticked = 0;
            do {
                BlockPos pos;
                if ((pos = this.queueing.poll()) == null) {
                    this.checked.clear();
                    if (ticked > 0) {
                        return;
                    }
                    break block7;
                }
                if (this.blocks.size() >= (Integer)VSCHServerConfig.MAX_ASSEMBLE_BLOCKS.get()) {
                    this.finishAssemble(AssembleResult.TOO_MANY_BLOCKS);
                    return;
                }
                if (pos.equals((Object)selfPos)) {
                    this.finishAssemble(AssembleResult.ASSEMBLING_SELF);
                    return;
                }
                this.checkBlock(pos);
                if (this.isAssembling()) continue;
                return;
            } while (++ticked <= 4096);
            return;
        }
        if (this.blocks.isEmpty()) {
            this.finishAssemble(AssembleResult.NO_BLOCK);
            return;
        }
        if (this.box.lengthX() > 4096 || this.box.lengthY() > 4096 || this.box.lengthZ() > 4096) {
            this.finishAssemble(AssembleResult.SIZE_OVERFLOW);
            return;
        }
        this.createShip(level);
    }

    private void checkBlock(BlockPos pos) {
        Level level = this.m_58904_();
        if (!level.m_151577_(pos.m_123341_(), pos.m_123343_())) {
            this.finishAssemble(AssembleResult.CHUNK_UNLOADED);
            return;
        }
        BlockState block = level.m_8055_(pos);
        if (this.isAirBlock(block)) {
            return;
        }
        if (!this.canAssembleBlock(block)) {
            this.finishAssemble(AssembleResult.UNABLE_ASSEMBLE);
            return;
        }
        this.box.union(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        this.blocks.add(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        for (Direction dir : Direction.values()) {
            BlockPos p = pos.m_121945_(dir);
            BlockState targetState = level.m_8055_(p);
            if (targetState.m_60734_() instanceof RocketAssemblerBlock && targetState.m_61143_((Property)DirectionalBlock.f_52588_) == dir.m_122424_()) {
                RocketAssemblerBlockEntity otherAssembler = (RocketAssemblerBlockEntity)level.m_7702_(p);
                if (otherAssembler == this || !otherAssembler.isAssembling()) continue;
                this.finishAssemble(AssembleResult.OTHER_ASSEMBLING);
                return;
            }
            if (!this.checked.add(p.m_123341_(), p.m_123342_(), p.m_123343_())) continue;
            this.queueing.add(p);
        }
    }

    protected boolean isAirBlock(BlockState state) {
        return state.m_60795_();
    }

    protected boolean canAssembleBlock(BlockState state) {
        Block block = state.m_60734_();
        ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        return !VSCHServerConfig.getAssembleBlacklistSet().contains(blockId);
    }

    private void createShip(ServerLevel level) {
        Vec3 pos;
        if (this.energyStored < this.energyConsumption) {
            this.finishAssemble(AssembleResult.NO_ENERGY);
            return;
        }
        this.energyStored -= this.energyConsumption;
        this.m_6596_();
        ServerShipWorldCore shipWorld = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level);
        String levelId = VSGameUtilsKt.getDimensionId((Level)level);
        Vector3i worldCenter = new Vector3i((Vector3dc)this.box.center(new Vector3d()), 0);
        final ServerShip ship = shipWorld.createNewShipAtBlock((Vector3ic)worldCenter, false, 1.0, levelId);
        Vector3i shipCenter = ship.getChunkClaim().getCenterBlockCoordinates(VSGameUtilsKt.getYRange((Level)level), new Vector3i());
        Vector3i offset = shipCenter.sub((Vector3ic)worldCenter, new Vector3i());
        ArrayList blockStates = new ArrayList(this.blocks.size());
        ArrayList<Entity> entities = new ArrayList<Entity>();
        ship.setSlug((String)(this.shipSlug == null ? "+assembled+rocket+" + ship.getId() : this.shipSlug));
        for (Entity entity : level.m_45933_(null, new AABB((double)(this.box.minX - 1), (double)(this.box.minY - 1), (double)(this.box.minZ - 1), (double)(this.box.maxX + 2), (double)(this.box.maxY + 2), (double)(this.box.maxZ + 2)))) {
            SuperGlueEntity glue;
            AABB box;
            if (entity instanceof HangingEntity) {
                HangingEntity he = (HangingEntity)entity;
                BlockPos hanging = he.m_31748_().m_121945_(he.m_6350_().m_122424_());
                if (!this.blocks.contains(hanging.m_123341_(), hanging.m_123342_(), hanging.m_123343_())) continue;
                entities.add(entity);
                continue;
            }
            if (!CompatMods.CREATE.isLoaded()) continue;
            if (entity instanceof SeatEntity) {
                SeatEntity seat = (SeatEntity)entity;
                BlockPos p2 = seat.m_20183_();
                if (!this.blocks.contains(p2.m_123341_(), p2.m_123342_(), p2.m_123343_())) continue;
                entities.add(entity);
                continue;
            }
            if (!(entity instanceof SuperGlueEntity) || !RocketAssemblerBlockEntity.streamBlocksInAABB(box = (glue = (SuperGlueEntity)entity).m_20191_()).anyMatch(p -> this.blocks.contains(p.m_123341_(), p.m_123342_(), p.m_123343_()))) continue;
            entities.add(entity);
        }
        this.blocks.forEach((x, y, z) -> {
            BlockPos pos = new BlockPos(x.intValue(), y.intValue(), z.intValue());
            BlockPos target = pos.m_7918_(offset.x, offset.y, offset.z);
            BlockState state = level.m_8055_(pos);
            BlockEntity be = level.m_7702_(pos);
            IMoveable<?> moveableOld = MoveUtil.getMover(be);
            if (moveableOld == null) {
                moveableOld = MoveUtil.getMover(state.m_60734_());
            }
            if (moveableOld != null) {
                moveableOld.beforeSaveForMove(level, pos, target);
            }
            state = level.m_8055_(pos);
            blockStates.add(new Pair<BlockPos, BlockState>(pos, state));
            CompoundTag nbt = level.m_46745_(pos).m_8051_(pos);
            if (nbt != null) {
                BlockPos targetPos = pos.m_7918_(offset.x, offset.y, offset.z);
                nbt.m_128405_("x", targetPos.m_123341_());
                nbt.m_128405_("y", targetPos.m_123342_());
                nbt.m_128405_("z", targetPos.m_123343_());
                level.m_46745_(targetPos).m_5604_(nbt);
            }
            Clearable.m_18908_((Object)be);
            Object moveData = moveableOld != null ? (Object)moveableOld.beforeMove(level, pos, target) : null;
            level.m_7731_(target, state, 82);
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 82);
            IMoveable<?> moveableNew = MoveUtil.getMover(level.m_7702_(target));
            if (moveableNew == null) {
                moveableNew = MoveUtil.getMover(state.m_60734_());
            }
            if (moveableNew != null) {
                moveableNew.afterMove(level, pos, target, moveData);
            }
            return null;
        });
        for (Entity entity : entities) {
            pos = entity.m_20182_();
            entity.m_6034_(pos.f_82479_ + (double)offset.x, pos.f_82480_ + (double)offset.y, pos.f_82481_ + (double)offset.z);
        }
        for (Pair value : blockStates) {
            pos = (BlockPos)value.left();
            Block block = ((BlockState)value.right()).m_60734_();
            level.m_6289_((BlockPos)pos, block);
            level.m_6289_(pos.m_7918_(offset.x, offset.y, offset.z), block);
        }
        AABBic box = ship.getShipAABB();
        final Vector3d absPosition = ship.getTransform().getPositionInWorld().add(ship.getInertiaData().getCenterOfMassInShip(), new Vector3d()).sub((double)shipCenter.x, (double)shipCenter.y, (double)shipCenter.z);
        final Vector3d position = new Vector3d((Vector3dc)absPosition);
        final Quaterniond rotation = new Quaterniond();
        final Vector3d velocity = new Vector3d();
        final Vector3d omega = new Vector3d();
        final Vector3d scaling = new Vector3d(1.0);
        double scale = 1.0;
        final ServerShip selfShip = VSGameUtilsKt.getShipManagingPos((ServerLevel)level, (BlockPos)this.m_58899_());
        if (selfShip != null) {
            ShipTransform selfTransform = selfShip.getTransform();
            selfTransform.getShipToWorld().transformPosition(position);
            rotation.set(selfTransform.getShipToWorldRotation());
            velocity.set(selfShip.getVelocity());
            omega.set(selfShip.getOmega());
            scaling.set(selfTransform.getShipToWorldScaling());
            scale = Math.sqrt(scaling.lengthSquared() / 3.0);
        }
        shipWorld.teleportShip(ship, (ShipTeleportData)new ShipTeleportDataImpl((Vector3dc)position, (Quaterniondc)rotation, (Vector3dc)velocity, (Vector3dc)omega, levelId, Double.valueOf(scale)));
        if (velocity.lengthSquared() != 0.0 || omega.lengthSquared() != 0.0) {
            ship.setTransformProvider(new ServerShipTransformProvider(){

                public ServerShipTransformProvider.NextTransformAndVelocityData provideNextTransformAndVelocity(ShipTransform transform, ShipTransform nextTransform) {
                    if (!transform.getPositionInWorld().equals(nextTransform.getPositionInWorld()) || !transform.getShipToWorldRotation().equals(nextTransform.getShipToWorldRotation())) {
                        ship.setTransformProvider(null);
                        return null;
                    }
                    if (ship.getVelocity().lengthSquared() == 0.0 && ship.getOmega().lengthSquared() == 0.0) {
                        if (selfShip != null) {
                            ShipTransform selfTransform2 = selfShip.getTransform();
                            selfTransform2.getShipToWorld().transformPosition((Vector3dc)absPosition, position);
                            rotation.set(selfTransform2.getShipToWorldRotation());
                            velocity.set(selfShip.getVelocity());
                            omega.set(selfShip.getOmega());
                            scaling.set(selfTransform2.getShipToWorldScaling());
                        }
                        return new ServerShipTransformProvider.NextTransformAndVelocityData((ShipTransform)new ShipTransformImpl((Vector3dc)position, nextTransform.getPositionInShip(), (Quaterniondc)rotation, (Vector3dc)scaling), (Vector3dc)velocity, (Vector3dc)omega);
                    }
                    return null;
                }
            });
        }
        this.finishAssemble(AssembleResult.SUCCESS);
    }

    private static Stream<BlockPos> streamBlocksInAABB(AABB box) {
        int minX = (int)Math.round(box.f_82288_);
        int maxX = (int)Math.round(box.f_82291_);
        int minY = (int)Math.round(box.f_82289_);
        int maxY = (int)Math.round(box.f_82292_);
        int minZ = (int)Math.round(box.f_82290_);
        int maxZ = (int)Math.round(box.f_82293_);
        int widthX = maxX - minX;
        int widthY = maxY - minY;
        int widthZ = maxZ - minZ;
        return IntStream.range(0, widthX * widthY * widthZ).mapToObj(i -> {
            int x = i % widthX + minX;
            int z = (i /= widthX) % widthZ + minZ;
            int y = (i /= widthZ) + minY;
            return new BlockPos(x, y, z);
        });
    }

    private class EnergyStorage
    implements IEnergyStorage {
        private EnergyStorage() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int storedEnergy = this.getEnergyStored();
            int newEnergy = Math.min(storedEnergy + maxReceive, this.getMaxEnergyStored());
            if (!simulate) {
                RocketAssemblerBlockEntity.this.energyStored = newEnergy;
                RocketAssemblerBlockEntity.this.m_6596_();
            }
            return newEnergy - storedEnergy;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return RocketAssemblerBlockEntity.this.energyStored;
        }

        public int getMaxEnergyStored() {
            return RocketAssemblerBlockEntity.this.getEnergyConsumption();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

