/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.blocks.thruster;

import com.mojang.logging.LogUtils;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;
import net.jcm.vsch.accessor.IGuiAccessor;
import net.jcm.vsch.blocks.custom.BaseThrusterBlock;
import net.jcm.vsch.blocks.custom.template.WrenchableBlock;
import net.jcm.vsch.blocks.entity.template.ParticleBlockEntity;
import net.jcm.vsch.blocks.thruster.ThrusterBrain;
import net.jcm.vsch.blocks.thruster.ThrusterEngine;
import net.jcm.vsch.config.VSCHServerConfig;
import net.jcm.vsch.ship.VSCHForceInducedShips;
import net.jcm.vsch.ship.thruster.ThrusterData;
import net.jcm.vsch.util.NoSourceClipContext;
import net.lointain.cosmos.init.CosmosModParticleTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.slf4j.Logger;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public abstract class AbstractThrusterBlockEntity
extends BlockEntity
implements ParticleBlockEntity,
WrenchableBlock {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String BRAIN_POS_TAG_NAME = "BrainPos";
    private static final String BRAIN_DATA_TAG_NAME = "BrainData";
    private final Direction facing;
    private ThrusterBrain brain;
    private BlockPos brainPos = null;
    private boolean brainNeedInit = false;
    private final Map<Capability<?>, LazyOptional<?>> capsCache = new HashMap();

    protected AbstractThrusterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.facing = (Direction)state.m_61143_((Property)DirectionalBlock.f_52588_);
        this.brain = new ThrusterBrain(this, this.getPeripheralType(), this.facing, this.createThrusterEngine());
    }

    protected abstract String getPeripheralType();

    protected abstract ThrusterEngine createThrusterEngine();

    public ThrusterBrain getBrain() {
        return this.brain;
    }

    public void setBrain(ThrusterBrain brain) {
        this.brain = brain;
        this.capsCache.forEach((k, v) -> v.invalidate());
        this.capsCache.clear();
        this.sendUpdate();
    }

    public ThrusterData.ThrusterMode getThrusterMode() {
        return this.brain.getThrusterMode();
    }

    public void setThrusterMode(ThrusterData.ThrusterMode mode) {
        this.brain.setThrusterMode(mode);
    }

    public double getCurrentPower() {
        return this.brain.getCurrentPower();
    }

    double getScale() {
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)this.m_58904_(), (BlockPos)this.m_58899_());
        if (ship == null) {
            return 1.0;
        }
        Vector3dc scaling = ship.getTransform().getShipToWorldScaling();
        return scaling.x() * scaling.y() * scaling.z();
    }

    public void m_142466_(CompoundTag data) {
        super.m_142466_(data);
        BlockPos pos = this.m_58899_();
        if (data.m_128425_(BRAIN_POS_TAG_NAME, 7)) {
            byte[] offset = data.m_128463_(BRAIN_POS_TAG_NAME);
            this.brainPos = pos.m_7918_((int)offset[0], (int)offset[1], (int)offset[2]);
        } else if (data.m_128425_(BRAIN_POS_TAG_NAME, 11)) {
            int[] offset = data.m_128465_(BRAIN_POS_TAG_NAME);
            this.brainPos = pos.m_7918_(offset[0], offset[1], offset[2]);
        } else if (data.m_128425_(BRAIN_DATA_TAG_NAME, 10)) {
            this.brain.readFromNBT(data.m_128469_(BRAIN_DATA_TAG_NAME));
            this.brainNeedInit = true;
        }
    }

    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        BlockPos selfPos = this.m_58899_();
        AbstractThrusterBlockEntity dataBlock = this.brain.getDataBlock();
        if (dataBlock == this) {
            data.m_128365_(BRAIN_DATA_TAG_NAME, (Tag)this.brain.writeToNBT(new CompoundTag()));
        } else if (this.brainPos != null) {
            BlockPos offset = this.brainPos.m_121996_((Vec3i)selfPos);
            data.m_128385_(BRAIN_POS_TAG_NAME, new int[]{offset.m_123341_(), offset.m_123342_(), offset.m_123343_()});
        } else {
            BlockPos dataPos = dataBlock.m_58899_();
            if (dataPos.equals((Object)selfPos)) {
                LOGGER.error("[starlance]: duplicated thruster block entity at {}", (Object)selfPos);
                return;
            }
            BlockPos offset = dataPos.m_121996_((Vec3i)selfPos);
            data.m_128385_(BRAIN_POS_TAG_NAME, new int[]{offset.m_123341_(), offset.m_123342_(), offset.m_123343_()});
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag data = super.m_5995_();
        this.m_183515_(data);
        return data;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    void sendUpdate() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction direction) {
        LazyOptional result = this.capsCache.computeIfAbsent(cap, c -> this.brain.getCapability(c, direction).lazyMap(v -> v));
        if (result.isPresent()) {
            return result;
        }
        return super.getCapability(cap, direction);
    }

    public void neighborChanged(Block block, BlockPos pos, boolean moving) {
        this.brain.neighborChanged(this, block, pos, moving);
    }

    private boolean canMerge(AbstractThrusterBlockEntity other) {
        if (this.facing != other.facing) {
            return false;
        }
        BlockPos selfPos = this.m_58899_();
        BlockPos otherPos = other.m_58899_();
        if (this.facing.m_122434_().m_7863_(otherPos.m_123341_() - selfPos.m_123341_(), otherPos.m_123342_() - selfPos.m_123342_(), otherPos.m_123343_() - selfPos.m_123343_()) != 0) {
            return false;
        }
        return this.getPeripheralType().equals(other.getPeripheralType());
    }

    private void resolveBrain() {
        Level level = this.m_58904_();
        BlockEntity be = level.m_7702_(this.brainPos);
        if (be instanceof AbstractThrusterBlockEntity) {
            AbstractThrusterBlockEntity thruster = (AbstractThrusterBlockEntity)be;
            if (thruster.brainNeedInit) {
                thruster.searchThrusters();
            }
            if (this.brainPos != null) {
                if (level.f_46443_) {
                    return;
                }
                this.brainPos = null;
                this.searchThrusters();
            }
        } else if (this.m_58904_() instanceof ServerLevel) {
            LOGGER.debug("[starlance]: Thruster brain at {} for {} is not found", (Object)this.brainPos, (Object)this.m_58899_());
            this.brainPos = null;
            this.m_6596_();
        }
    }

    private void searchThrusters() {
        this.brainNeedInit = false;
        Level level = this.m_58904_();
        AbstractThrusterBlockEntity.bfs(this.m_58899_(), otherPos -> {
            AbstractThrusterBlockEntity other;
            block7: {
                block6: {
                    BlockEntity patt7836$temp = level.m_7702_(otherPos);
                    if (!(patt7836$temp instanceof AbstractThrusterBlockEntity)) break block6;
                    other = (AbstractThrusterBlockEntity)patt7836$temp;
                    if (other.brainPos != null && this.canMerge(other)) break block7;
                }
                return false;
            }
            if (other.brainPos.equals((Object)this.brainPos)) {
                this.brain.addThruster(other);
                other.setBrain(this.brain);
                other.brainPos = null;
                return true;
            }
            if (this.brain == other.getBrain()) {
                other.brainPos = null;
                return false;
            }
            boolean ok = this.brain.tryMergeBrain(other.getBrain());
            if (ok) {
                other.brainPos = null;
            }
            return ok;
        });
    }

    @Override
    public void tickForce(ServerLevel level, BlockPos pos, BlockState state) {
        VSCHForceInducedShips ships;
        boolean powered;
        if (this.brainNeedInit) {
            this.searchThrusters();
        } else if (this.brainPos != null) {
            this.resolveBrain();
        }
        if (this.brain.getDataBlock() == this) {
            this.brain.tick(level);
        }
        boolean isLit = (Boolean)state.m_61143_((Property)BaseThrusterBlock.LIT);
        boolean bl = powered = this.brain.getPower() > 0.0;
        if (powered != isLit) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)BaseThrusterBlock.LIT, (Comparable)Boolean.valueOf(powered)));
        }
        if ((ships = VSCHForceInducedShips.get((Level)level, pos)) == null) {
            return;
        }
        ThrusterData thrusterData = this.brain.getThrusterData();
        if (ships.getThrusterAtPos(pos) != thrusterData) {
            ships.addThruster(pos, thrusterData);
        }
    }

    @Override
    public InteractionResult onUseWrench(UseOnContext ctx) {
        if (ctx.m_43724_() != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        Player player = ctx.m_43723_();
        if (!((Boolean)VSCHServerConfig.THRUSTER_TOGGLE.get()).booleanValue()) {
            if (player != null) {
                player.m_5661_((Component)Component.m_237115_((String)"vsch.error.thruster_modes_disabled").m_130940_(ChatFormatting.RED), true);
            }
            return InteractionResult.PASS;
        }
        ThrusterData.ThrusterMode blockMode = this.getThrusterMode();
        blockMode = blockMode.toggle();
        this.setThrusterMode(blockMode);
        if (player != null) {
            player.m_5661_((Component)Component.m_237115_((String)"vsch.message.toggle").m_7220_((Component)Component.m_237115_((String)("vsch." + blockMode.toString().toLowerCase()))), true);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void onFocusWithWrench(ItemStack stack, Level level, Player player) {
        if (!level.f_46443_) {
            return;
        }
        ((IGuiAccessor)Minecraft.m_91087_().f_91065_).vsch$setOverlayMessageIfNotExist((Component)Component.m_237115_((String)"vsch.message.mode").m_7220_((Component)Component.m_237115_((String)("vsch." + this.getThrusterMode().toString().toLowerCase()))), 25);
    }

    protected ParticleOptions getThrusterParticleType() {
        return (ParticleOptions)CosmosModParticleTypes.THRUSTED.get();
    }

    protected ParticleOptions getThrusterSmokeParticleType() {
        return (ParticleOptions)CosmosModParticleTypes.THRUST_SMOKE.get();
    }

    protected abstract double getEvaporateDistance();

    @Override
    public void tickParticles(Level level, BlockPos pos, BlockState state) {
        if (this.brainNeedInit) {
            this.searchThrusters();
        } else if (this.brainPos != null) {
            this.resolveBrain();
            if (this.brainPos == null) {
                return;
            }
        }
        if (this.getCurrentPower() == 0.0) {
            return;
        }
        Vec3 center = pos.m_252807_();
        Vector3d worldPos = new Vector3d(center.f_82479_, center.f_82480_, center.f_82481_);
        Direction dir = ((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_)).m_122424_();
        Vector3d direction = new Vector3d((double)dir.m_122429_(), (double)dir.m_122430_(), (double)dir.m_122431_());
        this.spawnParticles(worldPos, direction);
        this.spawnEvaporateParticles(level, pos, dir);
    }

    protected void spawnParticles(Vector3d pos, Vector3d direction) {
        double x = pos.x + direction.x;
        double y = pos.y + direction.y;
        double z = pos.z + direction.z;
        Vector3d speed = new Vector3d((Vector3dc)direction).mul(this.getCurrentPower());
        speed.mul(0.6);
        this.f_58857_.m_7106_(this.getThrusterParticleType(), x, y, z, speed.x, speed.y, speed.z);
        speed.mul(1.06);
        this.f_58857_.m_7106_(this.getThrusterSmokeParticleType(), x, y, z, speed.x, speed.y, speed.z);
    }

    protected void spawnEvaporateParticles(Level level, BlockPos pos, Direction direction) {
        double distance = this.getEvaporateDistance();
        if (distance <= 0.0) {
            return;
        }
        Vec3 center = pos.m_252807_();
        Vec3 centerExtendedPos = center.m_231075_(direction, distance);
        BlockHitResult hitResult = level.m_45547_((ClipContext)new NoSourceClipContext(VSGameUtilsKt.toWorldCoordinates((Level)level, (Vec3)center), VSGameUtilsKt.toWorldCoordinates((Level)level, (Vec3)centerExtendedPos), pos));
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockPos hitPos = hitResult.m_82425_();
        FluidState hitFluid = level.m_6425_(hitPos);
        if (!hitFluid.m_205070_(FluidTags.f_13131_)) {
            return;
        }
        Vec3 waterCenter = hitPos.m_252807_();
        for (int i = 0; i < 20; ++i) {
            Vec3 ppos = waterCenter.m_272010_(level.f_46441_, 1.0f);
            Vec3 speed = Vec3.f_82478_.m_272010_(level.f_46441_, 0.5f);
            level.m_6493_((ParticleOptions)CosmosModParticleTypes.AIR_THRUST.get(), true, ppos.f_82479_, ppos.f_82480_, ppos.f_82481_, speed.f_82479_, speed.f_82480_, speed.f_82481_);
        }
    }

    private static float getPowerByRedstone(Level level, BlockPos pos) {
        return (float)level.m_277086_(pos) / 15.0f;
    }

    private static void bfs(BlockPos startPos, Predicate<BlockPos> consumer) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        visited.add(startPos);
        queue.add(startPos);
        while (!queue.isEmpty()) {
            BlockPos pos = (BlockPos)queue.remove();
            for (Direction dir : Direction.values()) {
                BlockPos pos2 = pos.m_121945_(dir);
                if (!visited.add(pos2) || !consumer.test(pos2)) continue;
                queue.add(pos2);
            }
        }
    }
}

