/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.blocks.thruster;

import dan200.computercraft.shared.Capabilities;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jcm.vsch.blocks.thruster.AbstractThrusterBlockEntity;
import net.jcm.vsch.blocks.thruster.ThrusterEngine;
import net.jcm.vsch.blocks.thruster.ThrusterEngineContext;
import net.jcm.vsch.compat.CompatMods;
import net.jcm.vsch.compat.cc.peripherals.ThrusterPeripheral;
import net.jcm.vsch.config.VSCHServerConfig;
import net.jcm.vsch.ship.thruster.ThrusterData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class ThrusterBrain
implements IEnergyStorage,
IFluidHandler,
ICapabilityProvider {
    private static final String THRUSTERS_COUNT_TAG_NAME = "ThrustersCount";
    private static final String MODE_TAG_NAME = "Mode";
    private static final String POWER_TAG_NAME = "Power";
    private static final String CURRENT_POWER_TAG_NAME = "CurrentPower";
    private static final String PERIPHERAL_MOD_TAG_NAME = "PeripheralMode";
    private static final String ENERGY_TAG_NAME = "Energy";
    private static final String TANKS_TAG_NAME = "Tanks";
    private static final int FLUID_TANK_CAPACITY = 10000;
    private final ThrusterData thrusterData;
    private final ThrusterEngine engine;
    private final Direction facing;
    private int maxEnergy;
    private int storedEnergy;
    private final IEnergyStorage extractOnly = new ExtractOnly();
    private final FluidTank[] tanks;
    private final IFluidHandler drainOnly = new DrainOnly();
    private double scale;
    private volatile double power = 0.0;
    private volatile double currentPower = 0.0;
    private volatile boolean powerChanged = false;
    private List<AbstractThrusterBlockEntity> connectedBlocks;
    private final String peripheralType;
    private volatile boolean isPeripheralMode = false;
    private boolean wasPeripheralMode = true;
    private LazyOptional<Object> lazyPeripheral = LazyOptional.empty();

    private ThrusterBrain(List<AbstractThrusterBlockEntity> connectedBlocks, String peripheralType, Direction facing, ThrusterEngine engine) {
        this.connectedBlocks = connectedBlocks;
        this.peripheralType = peripheralType;
        this.facing = facing;
        this.thrusterData = new ThrusterData(VectorConversionsMCKt.toJOMLD((Vec3i)facing.m_122436_()), 0.0, (ThrusterData.ThrusterMode)((Object)VSCHServerConfig.THRUSTER_MODE.get()));
        this.engine = engine;
        int count = this.connectedBlocks.size();
        this.maxEnergy = this.engine.getEnergyConsumeRate() * count;
        this.tanks = new FluidTank[this.engine.getTanks()];
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i] = new FluidTank(10000 * count);
        }
        this.scale = this.connectedBlocks.get(0).getScale();
    }

    protected ThrusterBrain(AbstractThrusterBlockEntity dataBlock, String peripheralType, Direction facing, ThrusterEngine engine) {
        this(new ArrayList<AbstractThrusterBlockEntity>(List.of(dataBlock)), peripheralType, facing, engine);
    }

    public ThrusterEngine getEngine() {
        return this.engine;
    }

    public String getPeripheralType() {
        return this.peripheralType;
    }

    public int getThrusterCount() {
        return this.connectedBlocks.size();
    }

    public List<AbstractThrusterBlockEntity> getThrusters() {
        return Collections.unmodifiableList(this.connectedBlocks);
    }

    void addThruster(AbstractThrusterBlockEntity be) {
        this.connectedBlocks.add(be);
    }

    public void setThrusterMode(ThrusterData.ThrusterMode mode) {
        if (this.thrusterData.mode == mode) {
            return;
        }
        this.thrusterData.mode = mode;
        this.getDataBlock().sendUpdate();
    }

    public double getCurrentPower() {
        return this.currentPower;
    }

    public double getMaxThrottle() {
        return (double)this.engine.getMaxThrottle() * this.scale;
    }

    protected void setCurrentPower(double power) {
        if (this.currentPower == power) {
            return;
        }
        this.currentPower = power;
        this.markPowerChanged();
    }

    public double getCurrentThrottle() {
        return this.getCurrentPower() * this.getMaxThrottle();
    }

    public double getPower() {
        return this.power;
    }

    public void setPower(double power) {
        double newPower = Math.min(Math.max(power, 0.0), 1.0);
        if (this.power == newPower) {
            return;
        }
        this.power = newPower;
        this.setChanged();
    }

    public boolean getPeripheralMode() {
        return this.isPeripheralMode;
    }

    public void setPeripheralMode(boolean on) {
        if (this.isPeripheralMode == on) {
            return;
        }
        this.isPeripheralMode = on;
        this.setChanged();
    }

    public AbstractThrusterBlockEntity getDataBlock() {
        return this.connectedBlocks.get(0);
    }

    public ThrusterData.ThrusterMode getThrusterMode() {
        return this.thrusterData.mode;
    }

    public ThrusterData getThrusterData() {
        return this.thrusterData;
    }

    public void setChanged() {
        this.getDataBlock().m_6596_();
    }

    protected void markPowerChanged() {
        this.powerChanged = true;
        this.getDataBlock().sendUpdate();
    }

    public void copySettingFrom(ThrusterBrain origin) {
        this.power = origin.getPower();
        this.isPeripheralMode = origin.getPeripheralMode();
        this.thrusterData.mode = origin.getThrusterMode();
    }

    public void readFromNBT(CompoundTag data) {
        ListTag tanks;
        int count = data.m_128451_(THRUSTERS_COUNT_TAG_NAME);
        this.thrusterData.mode = ThrusterData.ThrusterMode.values()[data.m_128445_(MODE_TAG_NAME)];
        this.power = Math.min(Math.max(data.m_128459_(POWER_TAG_NAME), 0.0), 1.0);
        this.currentPower = data.m_128459_(CURRENT_POWER_TAG_NAME);
        this.isPeripheralMode = CompatMods.COMPUTERCRAFT.isLoaded() && data.m_128471_(PERIPHERAL_MOD_TAG_NAME);
        this.maxEnergy = this.engine.getEnergyConsumeRate() * count;
        this.storedEnergy = Math.min(this.maxEnergy, data.m_128451_(ENERGY_TAG_NAME));
        if (data.m_128441_(TANKS_TAG_NAME) && (tanks = data.m_128437_(TANKS_TAG_NAME, 10)).size() == this.tanks.length) {
            for (int i = 0; i < this.tanks.length; ++i) {
                FluidTank tank = this.tanks[i];
                tank.setCapacity(10000 * count);
                tank.readFromNBT(tanks.m_128728_(i));
            }
        }
        this.thrusterData.throttle = this.getCurrentThrottle();
    }

    public CompoundTag writeToNBT(CompoundTag data) {
        data.m_128405_(THRUSTERS_COUNT_TAG_NAME, this.connectedBlocks.size());
        data.m_128344_(MODE_TAG_NAME, (byte)this.thrusterData.mode.ordinal());
        data.m_128347_(POWER_TAG_NAME, this.getPower());
        data.m_128347_(CURRENT_POWER_TAG_NAME, this.getCurrentPower());
        data.m_128379_(PERIPHERAL_MOD_TAG_NAME, this.getPeripheralMode());
        data.m_128405_(ENERGY_TAG_NAME, this.storedEnergy);
        ListTag tanks = new ListTag();
        for (int i = 0; i < this.tanks.length; ++i) {
            FluidTank tank = this.tanks[i];
            tanks.add((Object)tank.writeToNBT(new CompoundTag()));
        }
        data.m_128365_(TANKS_TAG_NAME, (Tag)tanks);
        return data;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction direction) {
        if (cap == ForgeCapabilities.ENERGY || cap == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(() -> this).cast();
        }
        if (CompatMods.COMPUTERCRAFT.isLoaded() && cap == Capabilities.CAPABILITY_PERIPHERAL) {
            if (!this.lazyPeripheral.isPresent()) {
                this.lazyPeripheral = LazyOptional.of(() -> new ThrusterPeripheral(this));
            }
            return this.lazyPeripheral.cast();
        }
        return LazyOptional.empty();
    }

    public void tick(ServerLevel level) {
        if (this.wasPeripheralMode != this.isPeripheralMode && !this.isPeripheralMode) {
            this.updatePowerByRedstone();
        }
        this.wasPeripheralMode = this.isPeripheralMode;
        this.scale = this.connectedBlocks.get(0).getScale();
        ThrusterEngineContext context = new ThrusterEngineContext(level, this.extractOnly, this.drainOnly, this.getPower(), this.connectedBlocks.size(), this.scale);
        this.engine.tick(context);
        if (context.isRejected()) {
            this.setCurrentPower(0.0);
        } else {
            List<BlockPos> positions = this.connectedBlocks.stream().map(BlockEntity::m_58899_).collect(Collectors.toList());
            if (((Boolean)VSCHServerConfig.THRUSTER_FLAME_IMPACT.get()).booleanValue()) {
                this.engine.tickBurningObjects(context, positions, this.facing.m_122424_());
            }
            this.setCurrentPower((float)context.getPower());
            context.consume();
        }
        if (this.powerChanged) {
            this.powerChanged = false;
            this.thrusterData.throttle = this.getCurrentThrottle();
        }
    }

    public void neighborChanged(AbstractThrusterBlockEntity thruster, Block block, BlockPos pos, boolean moving) {
        block3: {
            Level level;
            block2: {
                level = thruster.m_58904_();
                BlockEntity changed = level.m_7702_(pos);
                if (!(changed instanceof AbstractThrusterBlockEntity)) break block2;
                AbstractThrusterBlockEntity newThruster = (AbstractThrusterBlockEntity)changed;
                ThrusterBrain newBrain = newThruster.getBrain();
                if (newBrain == this) break block3;
                this.tryMergeBrain(newBrain);
                break block3;
            }
            for (int i = 0; i < this.connectedBlocks.size(); ++i) {
                AbstractThrusterBlockEntity be = this.connectedBlocks.get(i);
                if (!be.m_58899_().equals((Object)pos)) continue;
                this.removeFromBrain(level, i);
                break;
            }
        }
        if (!this.isPeripheralMode) {
            this.updatePowerByRedstone();
        }
    }

    public boolean canMerge(ThrusterBrain other) {
        if (this.facing != other.facing) {
            return false;
        }
        BlockPos selfPos = this.getDataBlock().m_58899_();
        BlockPos otherPos = other.getDataBlock().m_58899_();
        if (this.facing.m_122434_().m_7863_(otherPos.m_123341_() - selfPos.m_123341_(), otherPos.m_123342_() - selfPos.m_123342_(), otherPos.m_123343_() - selfPos.m_123343_()) != 0) {
            return false;
        }
        return this.peripheralType.equals(other.peripheralType) && this.getThrusterMode() == other.getThrusterMode();
    }

    boolean tryMergeBrain(ThrusterBrain other) {
        int maxZ;
        int maxY;
        int maxX;
        if (!this.canMerge(other)) {
            return false;
        }
        List[] dataPos = this.getDataBlock().m_58899_();
        int minX = maxX = dataPos.m_123341_();
        int minY = maxY = dataPos.m_123342_();
        int minZ = maxZ = dataPos.m_123343_();
        for (List connectedBlocks : new List[]{this.connectedBlocks, other.connectedBlocks}) {
            for (AbstractThrusterBlockEntity be : connectedBlocks) {
                BlockPos pos = be.m_58899_();
                int x = pos.m_123341_();
                int y = pos.m_123342_();
                int z = pos.m_123343_();
                if (x < minX) {
                    minX = x;
                } else if (x > maxX) {
                    maxX = x;
                }
                if (y < minY) {
                    minY = y;
                } else if (y > maxY) {
                    maxY = y;
                }
                if (z < minZ) {
                    minZ = z;
                    continue;
                }
                if (z <= maxZ) continue;
                maxZ = z;
            }
        }
        this.connectedBlocks.addAll(other.connectedBlocks);
        for (AbstractThrusterBlockEntity be : other.connectedBlocks) {
            be.setBrain(this);
        }
        int count = this.connectedBlocks.size();
        this.maxEnergy = this.engine.getEnergyConsumeRate() * count;
        this.storedEnergy += other.storedEnergy;
        for (int i = 0; i < this.tanks.length; ++i) {
            FluidTank tank = this.tanks[i];
            tank.setCapacity(10000 * count);
            tank.fill(other.tanks[i].getFluid(), IFluidHandler.FluidAction.EXECUTE);
        }
        this.getDataBlock().sendUpdate();
        return true;
    }

    private void removeFromBrain(Level level, int index) {
        int i;
        AbstractThrusterBlockEntity removed = this.connectedBlocks.remove(index);
        if (this.connectedBlocks.isEmpty()) {
            this.maxEnergy = 0;
            this.storedEnergy = 0;
            return;
        }
        if (index == 0) {
            this.broadcastDataBlockUpdate();
        }
        HashSet<BlockPos> collected = new HashSet<BlockPos>();
        collected.add(removed.m_58899_());
        List[] sets = (List[])ThrusterBrain.streamNeighborPositions(removed.m_58899_(), this.facing).map(arg_0 -> ((Level)level).m_7702_(arg_0)).filter(AbstractThrusterBlockEntity.class::isInstance).map(AbstractThrusterBlockEntity.class::cast).filter(be -> !collected.contains(be.m_58899_())).map(be -> ThrusterBrain.collectAllConnecting(level, be, this.facing, collected)).toArray(List[]::new);
        this.connectedBlocks = sets[0];
        int count = this.connectedBlocks.size();
        this.maxEnergy = this.engine.getEnergyConsumeRate() * count;
        int lastEnergy = this.storedEnergy;
        this.storedEnergy = Math.min(this.maxEnergy, lastEnergy);
        lastEnergy -= this.storedEnergy;
        int[] lastFluids = new int[this.tanks.length];
        for (i = 0; i < this.tanks.length; ++i) {
            FluidTank tank = this.tanks[i];
            FluidStack stack = tank.getFluid();
            tank.setCapacity(10000 * count);
            if (stack.isEmpty()) continue;
            lastFluids[i] = stack.getAmount();
            stack.setAmount(Math.min(tank.getCapacity(), lastFluids[i]));
            int n = i;
            lastFluids[n] = lastFluids[n] - stack.getAmount();
        }
        for (i = 1; i < sets.length; ++i) {
            List set = sets[i];
            ThrusterBrain newBrain = new ThrusterBrain(set, this.peripheralType, this.facing, this.engine);
            newBrain.copySettingFrom(this);
            newBrain.storedEnergy = Math.min(newBrain.maxEnergy, lastEnergy);
            lastEnergy -= newBrain.storedEnergy;
            for (int j = 0; j < newBrain.tanks.length; ++j) {
                FluidTank tank = newBrain.tanks[j];
                FluidStack stack = tank.getFluid();
                if (lastFluids[j] <= 0) continue;
                int amount = Math.min(tank.getCapacity(), lastFluids[j]);
                int n = j;
                lastFluids[n] = lastFluids[n] - amount;
                newBrain.tanks[j].setFluid(new FluidStack(stack.getFluid(), amount));
            }
            for (AbstractThrusterBlockEntity t : set) {
                t.setBrain(newBrain);
            }
        }
        this.getDataBlock().sendUpdate();
    }

    private static Stream<BlockPos> streamNeighborPositions(BlockPos origin, Direction facing) {
        return Direction.m_235666_().filter(d -> d.m_122434_() != facing.m_122434_()).map(arg_0 -> ((BlockPos)origin).m_121945_(arg_0));
    }

    private static List<AbstractThrusterBlockEntity> collectAllConnecting(Level level, AbstractThrusterBlockEntity be, Direction facing, Set<BlockPos> collected) {
        ArrayList<AbstractThrusterBlockEntity> result = new ArrayList<AbstractThrusterBlockEntity>();
        if (!collected.add(be.m_58899_())) {
            return result;
        }
        ArrayDeque<AbstractThrusterBlockEntity> deque = new ArrayDeque<AbstractThrusterBlockEntity>();
        deque.addLast(be);
        while (!deque.isEmpty()) {
            AbstractThrusterBlockEntity b = (AbstractThrusterBlockEntity)deque.removeLast();
            result.add(b);
            BlockPos pos = b.m_58899_();
            ThrusterBrain.streamNeighborPositions(pos, facing).filter(collected::add).map(arg_0 -> ((Level)level).m_7702_(arg_0)).filter(AbstractThrusterBlockEntity.class::isInstance).map(AbstractThrusterBlockEntity.class::cast).forEach(deque::addLast);
        }
        return result;
    }

    private void broadcastDataBlockUpdate() {
        for (AbstractThrusterBlockEntity be : this.connectedBlocks) {
            be.sendUpdate();
        }
    }

    private void updatePowerByRedstone() {
        float newPower = 0.0f;
        for (AbstractThrusterBlockEntity be : this.connectedBlocks) {
            float power = ThrusterBrain.getPowerByRedstone(be.m_58904_(), be.m_58899_());
            if (!(power > newPower)) continue;
            newPower = power;
            if (power != 1.0f) continue;
            break;
        }
        this.setPower(newPower);
    }

    private static float getPowerByRedstone(Level level, BlockPos pos) {
        return (float)level.m_277086_(pos) / 15.0f;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int needs = this.maxEnergy - this.storedEnergy;
        if (needs < maxReceive) {
            maxReceive = needs;
        }
        if (!simulate) {
            this.storedEnergy += maxReceive;
            this.setChanged();
        }
        return maxReceive;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.storedEnergy;
    }

    public int getMaxEnergyStored() {
        return this.maxEnergy;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public int getTanks() {
        return this.tanks.length;
    }

    private IFluidHandler getDrainOnly() {
        return this.drainOnly;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.tanks[tank].getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.tanks[tank].getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.engine.isValidFuel(tank, stack.getFluid());
    }

    private FluidTank getFillableTank(FluidStack resource) {
        Fluid fluid = resource.getFluid();
        for (int i = 0; i < this.tanks.length; ++i) {
            if (!this.engine.isValidFuel(i, fluid)) continue;
            FluidTank tank = this.tanks[i];
            FluidStack stack = tank.getFluid();
            if (stack.getFluid() != fluid) {
                if (!stack.isEmpty()) {
                    return null;
                }
                stack = new FluidStack(fluid, 0);
                tank.setFluid(stack);
            }
            return tank;
        }
        return null;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidTank tank = this.getFillableTank(resource);
        if (tank == null) {
            return 0;
        }
        if (action.execute()) {
            this.setChanged();
        }
        return tank.fill(resource, action);
    }

    private FluidTank getDrainableTank(FluidStack resource) {
        Fluid fluid = resource.getFluid();
        for (FluidTank tank : this.tanks) {
            if (tank.getFluid().getFluid() != fluid) continue;
            return tank;
        }
        return null;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    final class ExtractOnly
    implements IEnergyStorage {
        ExtractOnly() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (maxExtract > ThrusterBrain.this.storedEnergy) {
                maxExtract = ThrusterBrain.this.storedEnergy;
            }
            if (!simulate) {
                ThrusterBrain.this.storedEnergy -= maxExtract;
                ThrusterBrain.this.setChanged();
            }
            return maxExtract;
        }

        public int getEnergyStored() {
            return ThrusterBrain.this.storedEnergy;
        }

        public int getMaxEnergyStored() {
            return ThrusterBrain.this.maxEnergy;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return false;
        }
    }

    final class DrainOnly
    implements IFluidHandler {
        DrainOnly() {
        }

        public int getTanks() {
            return ThrusterBrain.this.getTanks();
        }

        public FluidStack getFluidInTank(int tank) {
            return ThrusterBrain.this.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return ThrusterBrain.this.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return ThrusterBrain.this.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            FluidTank tank = ThrusterBrain.this.getDrainableTank(resource);
            if (tank == null) {
                return FluidStack.EMPTY;
            }
            if (action.execute()) {
                ThrusterBrain.this.setChanged();
            }
            return tank.drain(resource, action);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            for (FluidTank tank : ThrusterBrain.this.tanks) {
                FluidStack stack = tank.drain(maxDrain, action);
                if (stack.isEmpty()) continue;
                ThrusterBrain.this.setChanged();
                return stack;
            }
            return FluidStack.EMPTY;
        }
    }
}

