/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import net.jcm.vsch.event.Gravity;
import net.jcm.vsch.util.ShipUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import org.slf4j.Logger;

public class StarlanceCommand {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"starlance").requires(ctx -> ctx.m_6761_(2))).then(Commands.m_82127_((String)"reloadgravity").executes(ctx -> StarlanceCommand.reloadGravity((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"assemble").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> StarlanceCommand.assembleSingleBlock((CommandSourceStack)ctx.getSource(), BlockPosArgument.m_264582_((CommandContext)ctx, (String)"pos")))).then(Commands.m_82129_((String)"dx", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82129_((String)"dy", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82129_((String)"dz", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> StarlanceCommand.assembleBlocks((CommandSourceStack)ctx.getSource(), BlockPosArgument.m_264582_((CommandContext)ctx, (String)"pos"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"dx"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"dy"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"dz")))))))));
    }

    private static int assembleSingleBlock(CommandSourceStack source, BlockPos pos) {
        return ShipUtils.assembleBlock(source.m_81372_(), pos) != null ? 1 : 0;
    }

    private static int assembleBlocks(CommandSourceStack source, BlockPos pos, int dx, int dy, int dz) {
        return ShipUtils.assembleBlocks(source.m_81372_(), pos, dx, dy, dz) != null ? 1 : 0;
    }

    public static int reloadGravity(CommandSourceStack source) {
        try {
            Gravity.setAll(source.m_81377_().m_129783_());
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Couldn't execute command. See log for more info. " + e.getMessage())));
            LOGGER.error("Error when reloading gravity", (Throwable)e);
            return 0;
        }
        source.m_288197_(() -> Component.m_237113_((String)"Successfully reloaded gravity for all CH datapacked dimensions"), true);
        return 1;
    }
}

