/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.compat.create.ponder.scenes;

import com.simibubi.create.content.redstone.analogLever.AnalogLeverBlockEntity;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.ponder.instruction.EmitParticlesInstruction;
import com.simibubi.create.foundation.utility.Pointing;
import net.jcm.vsch.items.VSCHItems;
import net.lointain.cosmos.init.CosmosModParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ThrusterScenes {
    public static void thrusters(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("thrusters", "Thrusters");
        scene.configureBasePlate(1, 0, 5);
        scene.removeShadow();
        BlockPos middleThrusterLever = util.grid.at(2, 2, 2);
        BlockPos leftThrusterLever = util.grid.at(3, 2, 2);
        BlockPos rightThrusterLever = util.grid.at(1, 2, 2);
        Selection leftThruster = util.select.fromTo(3, 1, 1, 3, 2, 2);
        Selection middleThruster = util.select.fromTo(2, 1, 1, 2, 2, 2);
        Selection rightThruster = util.select.fromTo(1, 1, 1, 1, 2, 2);
        Selection baseplate = util.select.fromTo(0, 0, 0, 4, 0, 4);
        scene.world.showSection(baseplate, Direction.UP);
        ElementLink middleThrusterContraption = scene.world.showIndependentSection(middleThruster, Direction.DOWN);
        scene.idle(40);
        scene.overlay.showText(80).colored(PonderPalette.WHITE).text("Thrusters need to be powered with redstone to thrust").pointAt(util.vector.centerOf(middleThrusterLever)).attachKeyFrame().placeNearTarget();
        scene.idle(80);
        scene.idle(20);
        scene.addKeyframe();
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(middleThrusterLever), Pointing.DOWN).rightClick(), 30);
        scene.idle(30);
        scene.world.moveSection(middleThrusterContraption, util.vector.of(0.0, 0.0, 20.0), 30);
        scene.effects.emitParticles(util.vector.of(2.5, 1.5, 3.5), EmitParticlesInstruction.Emitter.simple((ParticleOptions)((SimpleParticleType)CosmosModParticleTypes.THRUSTED.get()), (Vec3)new Vec3(0.0, 0.0, -10.0)), 2.0f, 10);
        scene.idle(60);
        ElementLink leftThrusterContraption = scene.world.showIndependentSection(leftThruster, Direction.DOWN);
        ElementLink rightThrusterContraption = scene.world.showIndependentSection(rightThruster, Direction.DOWN);
        scene.idle(40);
        scene.overlay.showText(65).colored(PonderPalette.WHITE).text("Redstone level can control strength").pointAt(util.vector.centerOf(leftThrusterLever)).attachKeyFrame().placeNearTarget();
        scene.idle(65);
        scene.idle(20);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(leftThrusterLever), Pointing.DOWN).rightClick(), 30);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(rightThrusterLever), Pointing.DOWN).rightClick(), 30);
        scene.idle(20);
        scene.addKeyframe();
        scene.world.modifyBlockEntityNBT(util.select.position(leftThrusterLever), AnalogLeverBlockEntity.class, nbt -> nbt.m_128405_("State", 1));
        scene.idle(10);
        scene.idle(10);
        scene.world.moveSection(leftThrusterContraption, util.vector.of(0.0, 0.0, 20.0), 70);
        scene.world.moveSection(rightThrusterContraption, util.vector.of(0.0, 0.0, 20.0), 30);
        scene.effects.emitParticles(util.vector.of(3.5, 1.5, 3.5), EmitParticlesInstruction.Emitter.simple((ParticleOptions)((SimpleParticleType)CosmosModParticleTypes.THRUSTED.get()), (Vec3)new Vec3(0.0, 0.0, -10.0)), 2.0f, 10);
        scene.effects.emitParticles(util.vector.of(1.5, 1.5, 3.5), EmitParticlesInstruction.Emitter.simple((ParticleOptions)((SimpleParticleType)CosmosModParticleTypes.THRUSTED.get()), (Vec3)new Vec3(0.0, 0.0, -10.0)), 2.0f, 10);
        scene.idle(10);
        scene.effects.emitParticles(util.vector.of(3.5, 1.5, 6.5), EmitParticlesInstruction.Emitter.simple((ParticleOptions)((SimpleParticleType)CosmosModParticleTypes.THRUSTED.get()), (Vec3)new Vec3(0.0, 0.0, -10.0)), 2.0f, 10);
        scene.idle(15);
        scene.effects.emitParticles(util.vector.of(3.5, 1.5, 9.0), EmitParticlesInstruction.Emitter.simple((ParticleOptions)((SimpleParticleType)CosmosModParticleTypes.THRUSTED.get()), (Vec3)new Vec3(0.0, 0.0, -10.0)), 2.0f, 10);
        scene.idle(50);
        scene.markAsFinished();
    }

    public static void modes(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("thruster_modes", "Thruster Modes");
        scene.configureBasePlate(1, 0, 5);
        scene.removeShadow();
        Selection basePlate = util.select.fromTo(0, 0, 0, 4, 0, 4);
        Selection ship = util.select.fromTo(3, 1, 1, 1, 2, 2);
        BlockPos thruster = util.grid.at(3, 1, 1);
        BlockPos lever = util.grid.at(3, 2, 2);
        scene.world.showSection(basePlate, Direction.UP);
        scene.idle(5);
        ElementLink shipLink = scene.world.showIndependentSection(ship, Direction.DOWN);
        scene.idle(10);
        scene.overlay.showText(60).text("By default, thrusters are in POSITION mode").pointAt(util.vector.centerOf(thruster)).attachKeyFrame();
        scene.idle(80);
        scene.overlay.showText(60).text("This means they will apply force based on where they are").pointAt(util.vector.centerOf(thruster)).attachKeyFrame();
        scene.idle(30);
        scene.overlay.showOutline(PonderPalette.RED, (Object)1, util.select.position(thruster), 60);
        scene.idle(5);
        ThrusterScenes.drawArrow(scene.overlay, util.vector.centerOf(thruster), util.vector.centerOf(3, 1, 5), PonderPalette.RED, 55);
        scene.idle(65);
        scene.world.configureCenterOfRotation(shipLink, new Vec3(1.0, 1.0, 4.0));
        scene.world.rotateSection(shipLink, 0.0, -60.0, 0.0, 20);
        scene.world.moveSection(shipLink, new Vec3(-2.0, 0.0, 9.0), 20);
        scene.effects.emitParticles(util.vector.centerOf(3, 1, 2), EmitParticlesInstruction.Emitter.simple((ParticleOptions)((SimpleParticleType)CosmosModParticleTypes.THRUSTED.get()), (Vec3)new Vec3(0.0, 0.0, -10.0)), 10.0f, 7);
        scene.idle(7);
        scene.effects.emitParticles(util.vector.centerOf(3, 1, 5), EmitParticlesInstruction.Emitter.simple((ParticleOptions)((SimpleParticleType)CosmosModParticleTypes.THRUSTED.get()), (Vec3)new Vec3(3.0, 0.0, -7.0)), 10.0f, 5);
        scene.idle(5);
        scene.effects.emitParticles(util.vector.centerOf(3, 1, 8), EmitParticlesInstruction.Emitter.simple((ParticleOptions)((SimpleParticleType)CosmosModParticleTypes.THRUSTED.get()), (Vec3)new Vec3(5.0, 0.0, -5.0)), 10.0f, 5);
        scene.idle(18);
        scene.world.hideIndependentSectionImmediately(shipLink);
        shipLink = scene.world.showIndependentSection(ship, Direction.DOWN);
        scene.idle(10);
        scene.overlay.showText(60).text("However, this can cause unwanted rotation").pointAt(util.vector.centerOf(2, 1, 2));
        scene.idle(80);
        scene.addKeyframe();
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(thruster), Pointing.DOWN).rightClick().withItem(new ItemStack((ItemLike)VSCHItems.WRENCH.get())), 30);
        scene.idle(40);
        scene.overlay.showText(60).text("Using a wrench, a thruster can be changed to GLOBAL mode").pointAt(util.vector.centerOf(thruster));
        scene.idle(80);
        scene.overlay.showText(60).text("In GLOBAL mode it applies force without position").pointAt(util.vector.centerOf(thruster)).attachKeyFrame();
        scene.idle(30);
        scene.overlay.showOutline(PonderPalette.GREEN, (Object)1, ship.substract(util.select.layer(2)), 60);
        scene.idle(5);
        ThrusterScenes.drawArrow(scene.overlay, util.vector.centerOf(2, 1, 2), util.vector.centerOf(2, 1, 5), PonderPalette.GREEN, 55);
        scene.idle(65);
        scene.world.moveSection(shipLink, new Vec3(0.0, 0.0, 10.0), 20);
        scene.effects.emitParticles(util.vector.centerOf(3, 1, 2), EmitParticlesInstruction.Emitter.simple((ParticleOptions)((SimpleParticleType)CosmosModParticleTypes.THRUSTED.get()), (Vec3)new Vec3(0.0, 0.0, -10.0)), 10.0f, 10);
        scene.idle(10);
        scene.effects.emitParticles(util.vector.centerOf(3, 1, 7), EmitParticlesInstruction.Emitter.simple((ParticleOptions)((SimpleParticleType)CosmosModParticleTypes.THRUSTED.get()), (Vec3)new Vec3(0.0, 0.0, -10.0)), 10.0f, 10);
        scene.idle(20);
        scene.world.hideIndependentSectionImmediately(shipLink);
        shipLink = scene.world.showIndependentSection(ship, Direction.DOWN);
        scene.idle(10);
        scene.overlay.showText(60).text("This prevents unwanted rotation").pointAt(util.vector.centerOf(2, 1, 2)).attachKeyFrame();
        scene.idle(80);
        scene.markAsFinished();
    }

    private static void drawArrow(SceneBuilder.OverlayInstructions overlay, Vec3 start, Vec3 end, PonderPalette color, int duration) {
        overlay.showLine(color, start, end, duration);
        float headLength = 0.5f;
        Vector3f direction = new Vector3f((Vector3fc)end.m_252839_()).sub((Vector3fc)start.m_252839_()).normalize();
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
        if ((double)Math.abs(direction.dot((Vector3fc)up)) > 0.99) {
            up.set(1.0f, 0.0f, 0.0f);
        }
        Vector3f perpendicular = new Vector3f((Vector3fc)direction).cross((Vector3fc)up).normalize().mul(headLength);
        Vector3f arrowLeft = new Vector3f((Vector3fc)end.m_252839_()).add((Vector3fc)new Vector3f((Vector3fc)perpendicular).sub((Vector3fc)direction).normalize().mul(headLength));
        Vector3f arrowRight = new Vector3f((Vector3fc)end.m_252839_()).add((Vector3fc)new Vector3f((Vector3fc)perpendicular).negate().sub((Vector3fc)direction).normalize().mul(headLength));
        overlay.showLine(color, end, new Vec3(arrowLeft), duration);
        overlay.showLine(color, new Vec3(arrowRight), end, duration);
    }
}

