/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.event;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.List;
import net.jcm.vsch.api.event.PreTravelEvent;
import net.jcm.vsch.config.ShipLandingMode;
import net.jcm.vsch.config.VSCHServerConfig;
import net.jcm.vsch.ship.ShipLandingAttachment;
import net.jcm.vsch.util.TeleportationHandler;
import net.jcm.vsch.util.VSCHUtils;
import net.jcm.vsch.util.wapi.LevelData;
import net.lointain.cosmos.network.CosmosModVariables;
import net.lointain.cosmos.world.inventory.LandingSelectorMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionfc;
import org.joml.Vector2i;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBdc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class PlanetCollision {
    private static final Logger LOGGER = LogManager.getLogger((String)"vsch");
    private static final EntityTypeTest<Entity, ServerPlayer> PLAYER_TESTER = new EntityTypeTest<Entity, ServerPlayer>(){

        public ServerPlayer tryCast(Entity entity) {
            return entity.getClass() == ServerPlayer.class ? (ServerPlayer)entity : null;
        }

        public Class<ServerPlayer> m_142225_() {
            return ServerPlayer.class;
        }
    };
    private static final double OUTER_RANGE = 128.0;
    private static final double CLOSE_RANGE = 16.0;

    public static void planetCollisionTick(ServerLevel level) {
        ShipLandingMode landingMode = (ShipLandingMode)((Object)VSCHServerConfig.SHIP_LANDING_MODE.get());
        int landingAccuracy = (Integer)VSCHServerConfig.SHIP_LANDING_ACCURACY.get();
        int firstLandingAccuracy = (Integer)VSCHServerConfig.SHIP_FIRST_LANDING_SPAWN_RANGE.get();
        HashMap<ResourceKey, TeleportationHandler> handlers = new HashMap<ResourceKey, TeleportationHandler>();
        LevelData levelData = LevelData.get((Level)level);
        String dimension = level.m_46472_().m_135782_().toString();
        if (!levelData.hasPlanets()) {
            return;
        }
        List<LoadedServerShip> ships = VSCHUtils.getLoadedShipsInLevel(level);
        ships.sort((a, b) -> {
            AABBdc aBox = a.getWorldAABB();
            AABBdc bBox = b.getWorldAABB();
            double n = (aBox.maxX() - aBox.minX()) * (aBox.maxY() - aBox.minY()) * (aBox.maxZ() - aBox.minZ()) - (bBox.maxX() - bBox.minX()) * (bBox.maxY() - bBox.minY()) * (bBox.maxZ() - bBox.minZ());
            if (n < 0.0) {
                return 1;
            }
            if (n > 0.0) {
                return -1;
            }
            return Long.compare(a.getId(), b.getId());
        });
        for (final LoadedServerShip ship : ships) {
            boolean isFirstLand;
            ChunkPos newChunkPos;
            ServerPlayer commander;
            TeleportationHandler handler;
            Vec3 shipCenter = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getWorldAABB().center(new Vector3d()));
            LevelData.ClosestPlanetData nearestPlanetData = levelData.getNearestPlanet(shipCenter);
            ResourceKey<Level> targetDimension = nearestPlanetData.planet().getLevelData().getDimension();
            ServerLevel targetLevel = level.m_7654_().m_129880_(targetDimension);
            if (targetLevel == null || (handler = (TeleportationHandler)handlers.get(targetDimension)) != null && handler.hasShip((ServerShip)ship)) continue;
            ShipLandingAttachment landingAttachment = ShipLandingAttachment.get((ServerShip)ship);
            double distance = nearestPlanetData.distance();
            if (distance > 128.0) {
                commander = landingAttachment.commander;
                if (commander != null && commander.f_36096_ instanceof ShipLandingSelectorMenu) {
                    PlanetCollision.setPlayerCapCheckCollision(commander, true);
                    commander.m_9230_();
                }
                landingAttachment.launching = false;
                continue;
            }
            if (landingAttachment.launching && distance > 0.0 || !landingAttachment.freezed && ship.isStatic()) continue;
            if (landingMode.canOpenMenu() && (landingAttachment.commander == null || !landingAttachment.commander.m_6084_())) {
                ServerPlayer nearestPlayer = PlanetCollision.getShipNearestPlayer((Ship)ship, level);
                if (nearestPlayer == null) {
                    landingAttachment.commander = null;
                    if (!landingMode.canUseHistory()) {
                        continue;
                    }
                } else {
                    PlanetCollision.setPlayerCapCheckCollision(nearestPlayer, false);
                    landingAttachment.commander = nearestPlayer;
                }
            }
            if ((commander = landingAttachment.commander) != null) {
                if (!ship.isStatic() && distance <= 16.0) {
                    landingAttachment.freezeShip(ship);
                }
                if (!(commander.f_36096_ instanceof ShipLandingSelectorMenu)) {
                    LOGGER.debug("[starlance]: opened menu instead of CH");
                    final BlockPos bpos = commander.m_20183_();
                    NetworkHooks.openScreen((ServerPlayer)commander, (MenuProvider)new MenuProvider(){

                        public Component m_5446_() {
                            return Component.m_237113_((String)"LandingSelector");
                        }

                        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                            return new ShipLandingSelectorMenu(id, inventory, (ServerShip)ship, bpos);
                        }
                    }, (BlockPos)bpos);
                }
                newChunkPos = PlanetCollision.playerMenuTick(commander, (ServerShip)ship, level);
                isFirstLand = false;
                if (newChunkPos == null) {
                    continue;
                }
            } else {
                ChunkPos historyPos = landingAttachment.getLaunchPosition(targetDimension);
                if (historyPos == null) {
                    newChunkPos = ChunkPos.f_186419_;
                    isFirstLand = true;
                } else {
                    newChunkPos = historyPos;
                    isFirstLand = false;
                }
            }
            int accuracy = isFirstLand ? firstLandingAccuracy : landingAccuracy;
            System.out.println("accuracy: " + accuracy);
            Vector2i addPos = VSCHUtils.randomPosOnSqaureRing(level.f_46441_, accuracy, new Vector2i());
            Vector3d newPos = new Vector3d((double)SectionPos.m_123223_((int)(newChunkPos.f_45578_ + addPos.x)), nearestPlanetData.planet().getLevelData().getAtmosphereY(), (double)SectionPos.m_123223_((int)(newChunkPos.f_45579_ + addPos.y)));
            Quaterniond rotation = new Quaterniond((Quaternionfc)nearestPlanetData.direction().m_253075_());
            nearestPlanetData.planet().getRotation().mul((Quaterniondc)rotation, rotation).conjugate();
            MinecraftForge.EVENT_BUS.post((Event)new PreTravelEvent.SpaceToPlanet((ResourceKey<Level>)level.m_46472_(), ship.getTransform().getPositionInWorld(), targetDimension, newPos, rotation));
            LOGGER.info("[starlance]: Handling teleport {} ({}) to {} {} {} {}", (Object)ship.getSlug(), (Object)ship.getId(), (Object)targetDimension.m_135782_(), (Object)newPos.x, (Object)newPos.y, (Object)newPos.z);
            TeleportationHandler handler2 = handlers.computeIfAbsent(targetDimension, targetDim1 -> new TeleportationHandler(level, targetLevel, true));
            handler2.addShip((ServerShip)ship, (Vector3dc)newPos, (Quaterniondc)rotation);
        }
        for (TeleportationHandler handler : handlers.values()) {
            for (LoadedServerShip ship : handler.getPendingShips()) {
                ShipLandingAttachment attachment = ShipLandingAttachment.get((ServerShip)ship);
                attachment.freezed = false;
                attachment.setLanding();
            }
            handler.finalizeTeleport();
        }
    }

    private static ChunkPos playerMenuTick(ServerPlayer player, ServerShip ship, ServerLevel level) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (!(abstractContainerMenu instanceof ShipLandingSelectorMenu)) {
            return null;
        }
        ShipLandingSelectorMenu shipMenu = (ShipLandingSelectorMenu)abstractContainerMenu;
        if (shipMenu.shipId != ship.getId()) {
            return null;
        }
        CosmosModVariables.PlayerVariables vars = VSCHUtils.getPlayerCap((Player)player);
        if (vars == null || vars.landing_coords.equals("^") || vars.landing_coords.equals("=")) {
            return null;
        }
        double posX = Double.parseDouble(vars.landing_coords.substring(vars.landing_coords.indexOf("*") + 1, vars.landing_coords.indexOf("|")));
        double posZ = Double.parseDouble(vars.landing_coords.substring(vars.landing_coords.indexOf("|") + 1, vars.landing_coords.indexOf("~")));
        vars.landing_coords = "^";
        vars.check_collision = true;
        vars.syncPlayerVariables((Entity)player);
        return new ChunkPos(SectionPos.m_235865_((double)posX), SectionPos.m_235865_((double)posZ));
    }

    private static ServerPlayer getShipNearestPlayer(Ship ship, ServerLevel level) {
        AABBdc shipBox = ship.getWorldAABB();
        AABB currentWorldAABB = VectorConversionsMCKt.toMinecraft((AABBdc)shipBox).m_82400_(10.0);
        Vec3 center = VectorConversionsMCKt.toMinecraft((Vector3dc)shipBox.center(new Vector3d()));
        List players = level.m_142425_(PLAYER_TESTER, currentWorldAABB, EntitySelector.f_20408_);
        ServerPlayer nearestPlayer = null;
        double nearestDistance = Double.MAX_VALUE;
        for (ServerPlayer player : players) {
            double distance;
            Entity root = player.m_20201_();
            ServerShip rootShip = VSGameUtilsKt.getShipManagingPos((ServerLevel)level, (BlockPos)root.m_20183_());
            if (rootShip != null && rootShip.getId() != ship.getId() || !((distance = player.m_20238_(center)) < nearestDistance)) continue;
            nearestPlayer = player;
            nearestDistance = distance;
        }
        return nearestPlayer;
    }

    private static void setPlayerCapCheckCollision(ServerPlayer player, boolean checkCollision) {
        CosmosModVariables.PlayerVariables playerVars = VSCHUtils.getPlayerCap((Player)player);
        if (playerVars == null) {
            return;
        }
        playerVars.check_collision = checkCollision;
        playerVars.syncPlayerVariables((Entity)player);
    }

    private static final class ShipLandingSelectorMenu
    extends LandingSelectorMenu {
        private final long shipId;

        public ShipLandingSelectorMenu(int id, Inventory inv, ServerShip ship, BlockPos pos) {
            super(id, inv, new FriendlyByteBuf(Unpooled.buffer()).m_130064_(pos));
            this.shipId = ship.getId();
        }
    }
}

