/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.mixin.cosmos;

import java.util.ArrayList;
import java.util.Collection;
import net.jcm.vsch.items.custom.MagnetBootItem;
import net.jcm.vsch.util.wapi.LevelData;
import net.lointain.cosmos.entity.RocketSeatEntity;
import net.lointain.cosmos.item.NickelSuitItem;
import net.lointain.cosmos.item.SteelSuitItem;
import net.lointain.cosmos.item.TitaniumSuitItem;
import net.lointain.cosmos.procedures.SpacesuitwornLogicProcedure;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpacesuitwornLogicProcedure.class})
public class MixinSpacesuitwornLogicProcedure {
    private static final Logger logger = LogManager.getLogger((String)"vsch");
    private static final Collection<EquipmentSlot> armorSlots = new ArrayList<EquipmentSlot>();
    private static final Collection<Class<? extends Item>> validSpacesuits = new ArrayList<Class<? extends Item>>();

    @Inject(method={"execute"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private static void execute(LevelAccessor world, Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (entity == null) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            cir.setReturnValue((Object)false);
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!LevelData.get((Level)world).isSpace()) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (livingEntity.m_20202_() instanceof RocketSeatEntity) {
            cir.setReturnValue((Object)false);
            return;
        }
        cir.setReturnValue((Object)MixinSpacesuitwornLogicProcedure.isEntityWearingSpaceSuit(livingEntity));
    }

    private static boolean isEntityWearingSpaceSuit(LivingEntity entity) {
        for (EquipmentSlot slot : armorSlots) {
            ItemStack stack = entity.m_6844_(slot);
            if (stack.m_41619_()) {
                return false;
            }
            if (MixinSpacesuitwornLogicProcedure.isSpaceSuitItem(stack.m_41720_())) continue;
            return false;
        }
        return true;
    }

    private static boolean isSpaceSuitItem(Item item) {
        for (Class<? extends Item> suitClass : validSpacesuits) {
            if (!suitClass.isInstance(item)) continue;
            return true;
        }
        return false;
    }

    static {
        armorSlots.add(EquipmentSlot.HEAD);
        armorSlots.add(EquipmentSlot.CHEST);
        armorSlots.add(EquipmentSlot.LEGS);
        armorSlots.add(EquipmentSlot.FEET);
        validSpacesuits.add(SteelSuitItem.class);
        validSpacesuits.add(TitaniumSuitItem.class);
        validSpacesuits.add(NickelSuitItem.class);
        validSpacesuits.add(MagnetBootItem.class);
    }
}

