/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.mixin.minecraft;

import com.mojang.datafixers.util.Either;
import java.util.concurrent.CompletableFuture;
import net.jcm.vsch.util.EmptyChunkAccess;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkMap.class})
public class MixinChunkMap {
    @Shadow
    @Final
    ServerLevel f_140133_;

    @Inject(method={"schedule"}, at={@At(value="HEAD")}, cancellable=true)
    private void schedule(ChunkHolder holder, ChunkStatus status, CallbackInfoReturnable<CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> cir) {
        ServerLevel level = this.f_140133_;
        ChunkPos pos = holder.m_140092_();
        if (EmptyChunkAccess.shouldUseEmptyChunk((Level)level, pos.f_45578_, pos.f_45579_)) {
            cir.setReturnValue(CompletableFuture.completedFuture(Either.left((Object)((Object)new EmptyChunkAccess((Level)level, pos)))));
        }
    }

    @Inject(method={"save"}, at={@At(value="HEAD")}, cancellable=true)
    private void save(ChunkAccess chunk, CallbackInfoReturnable<Boolean> cir) {
        if (chunk instanceof EmptyChunkAccess) {
            cir.setReturnValue((Object)false);
        }
    }
}

