/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.network;

import java.util.Optional;
import java.util.function.Function;
import net.jcm.vsch.network.INetworkPacket;
import net.jcm.vsch.network.c2s.ToggleItemPacketC2S;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public final class VSCHNetwork {
    private static final String PROTOCOL_VERSION = ModLoadingContext.get().getActiveContainer().getModInfo().getVersion().toString();
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("vsch", "main"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
    private static int id = 0;

    private VSCHNetwork() {
    }

    public static void register() {
        VSCHNetwork.registerC2S(ToggleItemPacketC2S.class, ToggleItemPacketC2S::decode);
    }

    public static <T extends INetworkPacket> void registerC2S(Class<T> clazz, Function<FriendlyByteBuf, T> decoder) {
        CHANNEL.registerMessage(id++, clazz, INetworkPacket::encode, decoder, (packet, ctx) -> packet.handle((NetworkEvent.Context)ctx.get()), Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    public static <T extends INetworkPacket> void registerS2C(Class<T> clazz, Function<FriendlyByteBuf, T> decoder) {
        CHANNEL.registerMessage(id++, clazz, INetworkPacket::encode, decoder, (packet, ctx) -> packet.handle((NetworkEvent.Context)ctx.get()), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static void sendToServer(INetworkPacket packet) {
        CHANNEL.sendToServer((Object)packet);
    }

    public static void sendToPlayer(INetworkPacket packet, ServerPlayer player) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public static void sendToTracking(INetworkPacket packet, ServerLevel level, BlockPos pos) {
        level.m_7726_().f_8325_.m_183262_(new ChunkPos(pos), false).forEach(p -> VSCHNetwork.sendToPlayer(packet, p));
    }
}

