/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.network.c2s;

import net.jcm.vsch.compat.CompatMods;
import net.jcm.vsch.items.IToggleableItem;
import net.jcm.vsch.network.INetworkPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class ToggleItemPacketC2S
implements INetworkPacket {
    public final boolean isCurios;
    public final int slot;
    public final String id;

    public ToggleItemPacketC2S(int slot) {
        this.isCurios = false;
        this.slot = slot;
        this.id = null;
    }

    public ToggleItemPacketC2S(String id, int slot) {
        this.isCurios = true;
        this.slot = slot;
        this.id = id;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isCurios);
        buf.m_130130_(this.slot);
        if (this.isCurios) {
            buf.m_130072_(this.id, 256);
        }
    }

    public static ToggleItemPacketC2S decode(FriendlyByteBuf buf) {
        boolean isCurios = buf.readBoolean();
        int slot = buf.m_130242_();
        return isCurios ? new ToggleItemPacketC2S(buf.m_130136_(256), slot) : new ToggleItemPacketC2S(slot);
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        ctx.setPacketHandled(true);
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        if (this.isCurios) {
            if (!CompatMods.CURIOS.isLoaded()) {
                return;
            }
            ctx.enqueueWork(() -> {
                ICuriosItemHandler curiosInv = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).orElse(null);
                if (curiosInv == null) {
                    return;
                }
                SlotResult result = curiosInv.findCurio(this.id, this.slot).orElse(null);
                if (result == null) {
                    return;
                }
                ItemStack stack = result.stack();
                if (stack.m_41619_()) {
                    return;
                }
                Item patt2016$temp = stack.m_41720_();
                if (patt2016$temp instanceof IToggleableItem) {
                    IToggleableItem item = (IToggleableItem)patt2016$temp;
                    item.onToggle((Player)player, stack);
                }
            });
            return;
        }
        ctx.enqueueWork(() -> {
            ItemStack stack = player.m_150109_().m_8020_(this.slot);
            if (stack.m_41619_()) {
                return;
            }
            Item patt2281$temp = stack.m_41720_();
            if (patt2281$temp instanceof IToggleableItem) {
                IToggleableItem item = (IToggleableItem)patt2281$temp;
                item.onToggle((Player)player, stack);
            }
        });
    }
}

