/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.util;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public final class TaskUtil {
    private static final Queue<Runnable> TICK_START_QUEUE = new ConcurrentLinkedQueue<Runnable>();
    private static final Queue<Runnable> TICK_END_QUEUE = new ConcurrentLinkedQueue<Runnable>();

    private TaskUtil() {
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        Queue<Runnable> queue = switch (event.phase) {
            default -> throw new IncompatibleClassChangeError();
            case TickEvent.Phase.START -> TICK_START_QUEUE;
            case TickEvent.Phase.END -> TICK_END_QUEUE;
        };
        for (int i = queue.size(); i > 0; --i) {
            Runnable task = queue.remove();
            task.run();
        }
    }

    public static void queueTickStart(Runnable task) {
        TICK_START_QUEUE.add(task);
    }

    public static void queueTickEnd(Runnable task) {
        TICK_END_QUEUE.add(task);
    }
}

