/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import net.jcm.vsch.compat.CompatMods;
import net.lointain.cosmos.network.CosmosModVariables;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Vector2i;
import org.joml.Vector3d;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class VSCHUtils {
    private static final Logger LOGGER = LogManager.getLogger((String)"vsch");

    public static String dimToVSDim(String dimension) {
        return "minecraft:dimension:" + dimension;
    }

    public static ServerLevel registeryDimToLevel(String dimension) {
        String[] parts = dimension.split(":");
        if (parts.length != 4) {
            throw new IllegalArgumentException("Unexpected dimension ID: " + dimension);
        }
        ResourceKey levelId = ResourceKey.m_135785_((ResourceKey)ResourceKey.m_135788_((ResourceLocation)new ResourceLocation(parts[0], parts[1])), (ResourceLocation)new ResourceLocation(parts[2], parts[3]));
        return ValkyrienSkiesMod.getCurrentServer().m_129880_(levelId);
    }

    public static ServerLevel dimToLevel(String dimensionString) {
        return ValkyrienSkiesMod.getCurrentServer().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dimensionString)));
    }

    public static CosmosModVariables.PlayerVariables getPlayerCap(Player player) {
        return (CosmosModVariables.PlayerVariables)player.getCapability(CosmosModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse(null);
    }

    public static Vector3d clampVector(Vector3d force, double limit) {
        force.x = Math.max(-limit, Math.min(limit, force.x));
        force.y = Math.max(-limit, Math.min(limit, force.y));
        force.z = Math.max(-limit, Math.min(limit, force.z));
        return force;
    }

    public static List<LoadedServerShip> getLoadedShipsInLevel(ServerLevel level) {
        String dimId = VSGameUtilsKt.getDimensionId((Level)level);
        ArrayList<LoadedServerShip> loadedships = new ArrayList<LoadedServerShip>();
        for (LoadedServerShip ship : VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getLoadedShips()) {
            if (!dimId.equals(ship.getChunkClaimDimension())) continue;
            loadedships.add(ship);
        }
        return loadedships;
    }

    public static Component getWarningComponent() {
        return Component.m_237115_((String)"vsch.tooltip.may_need_fuel_or_energy").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY});
    }

    public static boolean testCuriosItems(LivingEntity entity, String id, BiPredicate<ItemStack, Integer> tester) {
        if (!CompatMods.CURIOS.isLoaded()) {
            return false;
        }
        ICuriosItemHandler curiosInv = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)entity).orElse(null);
        if (curiosInv == null) {
            return false;
        }
        ICurioStacksHandler stacksHandler = curiosInv.getStacksHandler(id).orElse(null);
        if (stacksHandler == null) {
            return false;
        }
        IDynamicStackHandler stacks = stacksHandler.getStacks();
        for (int slot = 0; slot < stacks.getSlots(); ++slot) {
            ItemStack stack = stacks.getStackInSlot(slot);
            if (stack.m_41619_() || !tester.test(stack, slot)) continue;
            return true;
        }
        return false;
    }

    public static Vector2i randomPosOnSqaureRing(RandomSource rnd, int distance, Vector2i dest) {
        int x = rnd.m_188503_(distance + 1);
        int y = distance - x;
        dest.x = rnd.m_188499_() ? x : -x;
        dest.y = rnd.m_188499_() ? y : -y;
        return dest;
    }
}

