/*
 * Decompiled with CFR 0.152.
 */
package net.jcm.vsch.util.assemble;

import com.simibubi.create.content.contraptions.IControlContraption;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.jcm.vsch.compat.CompatMods;
import net.jcm.vsch.util.assemble.IMoveable;
import net.jcm.vsch.util.assemble.MoveableIControlContraption;

public final class MoveUtil {
    private static final Map<Class<?>, IMoveable<?>> DEFAULT_MOVERS = new HashMap();

    private MoveUtil() {
    }

    public static IMoveable<?> registerDefaultMover(Class<?> blockClass, IMoveable<?> mover) {
        if (mover == null) {
            return DEFAULT_MOVERS.remove(blockClass);
        }
        return DEFAULT_MOVERS.put(blockClass, mover);
    }

    public static IMoveable<?> getMover(Object block) {
        Class<?> blockClass;
        if (block == null) {
            return null;
        }
        if (block instanceof IMoveable) {
            IMoveable mover = (IMoveable)block;
            return mover;
        }
        for (blockClass = block.getClass(); blockClass != null; blockClass = blockClass.getSuperclass()) {
            IMoveable<?> mover = DEFAULT_MOVERS.get(blockClass);
            if (mover == null) continue;
            return mover;
        }
        for (blockClass = block.getClass(); blockClass != null; blockClass = blockClass.getSuperclass()) {
            for (Class intf : Stream.of(blockClass.getInterfaces()).flatMap(MoveUtil::streamClassAnsSubInterfaces)::iterator) {
                IMoveable<?> mover = DEFAULT_MOVERS.get(intf);
                if (mover == null) continue;
                return mover;
            }
        }
        return null;
    }

    public static void registerDefaultMovers() {
        if (CompatMods.CREATE.isLoaded()) {
            MoveUtil.registerDefaultMover(IControlContraption.class, MoveableIControlContraption.INSTANCE);
        }
    }

    private static Stream<Class<?>> streamClassAnsSubInterfaces(Class<?> clazz) {
        return Stream.concat(Stream.of(clazz), Stream.of(clazz.getInterfaces()).flatMap(MoveUtil::streamClassAnsSubInterfaces));
    }
}

