/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx;

import com.foundryx.FoundryxMod;
import com.foundryx.chat.ChatFormatter;
import com.foundryx.event.FoundryxCommonEvents;
import com.foundryx.managers.TabManager;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="foundryx")
public final class Foundryx {
    public Foundryx(FMLJavaModLoadingContext context) {
        BusGroup modBusGroup = context.getModBusGroup();
        FMLCommonSetupEvent.getBus((BusGroup)modBusGroup).addListener(this::commonSetup);
        RegisterCommandsEvent.BUS.addListener(this::registerCommands);
        ServerChatEvent.BUS.addListener(this::handleChatMessage);
        TickEvent.ServerTickEvent.Post.BUS.addListener(this::handleServerTick);
        TickEvent.PlayerTickEvent.Post.BUS.addListener(this::handlePlayerTick);
        PlayerEvent.PlayerLoggedInEvent.BUS.addListener(this::handlePlayerJoin);
        PlayerEvent.PlayerLoggedOutEvent.BUS.addListener(this::handlePlayerQuit);
        LivingDamageEvent.BUS.addListener(this::handlePlayerDamage);
        LivingDeathEvent.BUS.addListener(this::handlePlayerDeath);
        PlayerEvent.TabListNameFormat.BUS.addListener(this::handleTabListName);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(FoundryxMod::init);
    }

    private void registerCommands(RegisterCommandsEvent event) {
        FoundryxMod.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
    }

    private boolean handleChatMessage(ServerChatEvent event) {
        ServerPlayer sender = event.getPlayer();
        if (sender == null) {
            return false;
        }
        ServerLevel level = sender.level();
        PlayerList playerList = level.getServer().getPlayerList();
        boolean handled = ChatFormatter.handle(playerList, sender, event.getRawText(), ChatType.bind((ResourceKey)ChatType.CHAT, (Entity)sender));
        return !handled;
    }

    private void handleServerTick(TickEvent.ServerTickEvent.Post event) {
        FoundryxCommonEvents.onServerTick(event.server());
    }

    private void handlePlayerTick(TickEvent.PlayerTickEvent.Post event) {
        Player player = event.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            FoundryxCommonEvents.onPlayerTick(serverPlayer);
        }
    }

    private void handlePlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            FoundryxCommonEvents.onPlayerJoin(serverPlayer);
        }
    }

    private void handlePlayerQuit(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            FoundryxCommonEvents.onPlayerQuit(serverPlayer);
        }
    }

    private void handlePlayerDamage(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            FoundryxCommonEvents.onPlayerDamaged(serverPlayer);
        }
    }

    private void handlePlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            String cause = event.getSource() == null ? null : event.getSource().getMsgId();
            FoundryxCommonEvents.onPlayerDeath(serverPlayer, cause);
        }
    }

    private void handleTabListName(PlayerEvent.TabListNameFormat event) {
        ServerPlayer serverPlayer;
        Component display;
        Player player = event.getEntity();
        if (player instanceof ServerPlayer && (display = TabManager.getDisplay(serverPlayer = (ServerPlayer)player)) != null) {
            event.setDisplayName(display);
        }
    }
}

