/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.chat;

import com.foundryx.Constants;
import com.foundryx.config.ModConfig;
import com.foundryx.localization.Localization;
import com.foundryx.managers.AfkManager;
import com.foundryx.managers.TabManager;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.foundryx.permission.LuckPermsMetaUtil;
import com.foundryx.platform.Services;
import com.foundryx.storage.FoundryxDataStorage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.StringUtil;
import net.minecraft.world.scores.PlayerTeam;

public final class ChatFormatter {
    private static final Set<String> PLATFORMS_WITH_CUSTOM_BROADCAST = Set.of("Fabric", "NeoForge", "Forge");
    private static final Component SPACE = Component.literal((String)" ");

    private ChatFormatter() {
    }

    public static boolean isPlatformHandlingBroadcast() {
        return PLATFORMS_WITH_CUSTOM_BROADCAST.contains(Services.PLATFORM.getPlatformName());
    }

    public static boolean handle(PlayerList playerList, PlayerChatMessage message, CommandSourceStack source, ChatType.Bound chatType) {
        ServerPlayer sender = source.getPlayer();
        if (sender == null) {
            return false;
        }
        return ChatFormatter.handle(playerList, sender, message.signedContent(), chatType, message);
    }

    public static boolean handle(PlayerList playerList, ServerPlayer sender, String rawMessage, ChatType.Bound chatType) {
        return ChatFormatter.handle(playerList, sender, rawMessage, chatType, null);
    }

    private static boolean handle(PlayerList playerList, ServerPlayer sender, String rawMessage, ChatType.Bound chatType, PlayerChatMessage originalMessage) {
        if (sender == null) {
            return false;
        }
        AfkManager.handleChat(sender);
        MinecraftServer server = playerList.getServer();
        FoundryxDataStorage storage = FoundryxDataStorage.get(server);
        UUID playerId = sender.getUUID();
        if (storage.isMuted(playerId)) {
            sender.sendSystemMessage((Component)Localization.formatted("chat.foundryx.muted"));
            return true;
        }
        boolean allowColors = FoundryxPermissions.check(sender, FoundryxPermission.CHAT_COLOR);
        boolean allowFormats = FoundryxPermissions.check(sender, FoundryxPermission.CHAT_FORMATTING);
        MutableComponent baseNameComponent = ChatFormatter.sanitizeDisplayName(sender);
        baseNameComponent = !ChatFormatter.hasExplicitColor((Component)baseNameComponent) ? ChatFormatter.applyDefaultColor(baseNameComponent.copy(), ChatFormatter.defaultNameColor()) : baseNameComponent.copy();
        MutableComponent nameComponent = ChatFormatter.decorateWithLuckPermsMeta(sender, baseNameComponent);
        MutableComponent messageComponent = ChatFormatter.formatChatMessage(playerList, rawMessage, allowColors, allowFormats);
        MutableComponent formatted = Component.empty().append((Component)nameComponent).append((Component)Component.literal((String)": ")).append((Component)messageComponent);
        MutableComponent finalMessage = formatted.copy();
        Constants.LOG.info("[CHAT] {}", (Object)finalMessage.getString());
        for (ServerPlayer target : playerList.getPlayers()) {
            target.sendSystemMessage((Component)finalMessage);
        }
        return true;
    }

    public static MutableComponent sanitizeDisplayName(ServerPlayer player) {
        Optional<Object> storedNickname = Optional.empty();
        ServerLevel serverLevel = player.level();
        if (serverLevel instanceof ServerLevel) {
            ServerLevel serverLevel2 = serverLevel;
            storedNickname = FoundryxDataStorage.get(serverLevel2.getServer()).getNickname(player.getUUID());
        }
        if (storedNickname.isPresent()) {
            return ChatFormatter.nicknameComponent((String)storedNickname.get());
        }
        PlayerTeam team = player.getTeam();
        Component displayName = TabManager.isTabTeam(team) ? player.getName() : player.getDisplayName();
        MutableComponent sanitized = Component.empty();
        displayName.visit((style, text) -> {
            String sanitizedText = text.replace("<", "").replace(">", "");
            if (sanitizedText.isEmpty()) {
                return Optional.empty();
            }
            MutableComponent part = Component.literal((String)sanitizedText);
            if (style != null && !style.isEmpty()) {
                part = part.withStyle(style);
            }
            sanitized.append((Component)part);
            return Optional.empty();
        }, Style.EMPTY);
        if (!displayName.getStyle().isEmpty()) {
            sanitized.withStyle(displayName.getStyle());
        }
        if (ChatFormatter.isComponentEmpty((Component)sanitized)) {
            sanitized.append((Component)player.getName().copy());
        }
        return sanitized;
    }

    private static Component parseMessage(String raw, boolean allowColors, boolean allowFormats, Map<String, ServerPlayer> mentionTargets) {
        if (StringUtil.isNullOrEmpty((String)raw)) {
            return Component.empty();
        }
        return ChatFormatter.parseLegacy(raw, allowColors, allowFormats, mentionTargets);
    }

    public static Component legacyToComponent(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return ChatFormatter.parseLegacy(value, true, true);
    }

    private static Component parseLegacy(String value, boolean allowColors, boolean allowFormats) {
        return ChatFormatter.parseLegacy(value, allowColors, allowFormats, Collections.emptyMap());
    }

    private static Component parseLegacy(String value, boolean allowColors, boolean allowFormats, Map<String, ServerPlayer> mentionTargets) {
        MutableComponent result = Component.empty();
        ChatFormatting currentColor = null;
        Integer customColor = null;
        boolean bold = false;
        boolean italic = false;
        boolean underlined = false;
        boolean strikethrough = false;
        boolean obfuscated = false;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            ServerPlayer mentioned;
            MentionCandidate candidate;
            char character = value.charAt(i);
            if (character == '&' || character == '\u00a7') {
                if (i + 1 >= value.length()) {
                    buffer.append(character);
                    continue;
                }
                char next = value.charAt(i + 1);
                if (next == '#') {
                    if (!allowColors) {
                        buffer.append(character);
                        continue;
                    }
                    if (i + 7 < value.length()) {
                        String hex = value.substring(i + 2, i + 8);
                        try {
                            int color = Integer.parseInt(hex, 16);
                            if (buffer.length() > 0) {
                                result.append((Component)ChatFormatter.applyStyle(buffer, currentColor, customColor, bold, italic, underlined, strikethrough, obfuscated));
                                buffer.setLength(0);
                            }
                            currentColor = null;
                            customColor = color;
                            bold = false;
                            italic = false;
                            underlined = false;
                            strikethrough = false;
                            obfuscated = false;
                            i += 7;
                            continue;
                        }
                        catch (NumberFormatException color) {
                        }
                    }
                } else {
                    ChatFormatting formatting = ChatFormatting.getByCode((char)next);
                    if (formatting != null) {
                        boolean permitted;
                        boolean isReset;
                        boolean isColor = formatting.isColor();
                        boolean bl = isReset = formatting == ChatFormatting.RESET;
                        boolean bl2 = isColor ? allowColors : (isReset ? allowColors || allowFormats : (permitted = allowFormats));
                        if (!permitted) {
                            buffer.append(character);
                            continue;
                        }
                        if (buffer.length() > 0) {
                            result.append((Component)ChatFormatter.applyStyle(buffer, currentColor, customColor, bold, italic, underlined, strikethrough, obfuscated));
                            buffer.setLength(0);
                        }
                        if (formatting == ChatFormatting.RESET) {
                            currentColor = null;
                            customColor = null;
                            bold = false;
                            italic = false;
                            underlined = false;
                            strikethrough = false;
                            obfuscated = false;
                        } else if (formatting.isColor()) {
                            currentColor = formatting;
                            customColor = null;
                            bold = false;
                            italic = false;
                            underlined = false;
                            strikethrough = false;
                            obfuscated = false;
                        } else {
                            switch (formatting) {
                                case BOLD: {
                                    bold = true;
                                    break;
                                }
                                case ITALIC: {
                                    italic = true;
                                    break;
                                }
                                case UNDERLINE: {
                                    underlined = true;
                                    break;
                                }
                                case STRIKETHROUGH: {
                                    strikethrough = true;
                                    break;
                                }
                                case OBFUSCATED: {
                                    obfuscated = true;
                                    break;
                                }
                            }
                        }
                        ++i;
                        continue;
                    }
                }
            }
            if (!mentionTargets.isEmpty() && character == '@' && ChatFormatter.isMentionStart(value, i) && (candidate = ChatFormatter.extractMention(value, i + 1)) != null && (mentioned = mentionTargets.get(ChatFormatter.normalizeMentionKey(candidate.token()))) != null) {
                if (buffer.length() > 0) {
                    result.append((Component)ChatFormatter.applyStyle(buffer, currentColor, customColor, bold, italic, underlined, strikethrough, obfuscated));
                    buffer.setLength(0);
                }
                result.append((Component)ChatFormatter.buildMentionComponent(mentioned));
                i = candidate.endIndex() - 1;
                continue;
            }
            buffer.append(character);
        }
        if (buffer.length() > 0) {
            result.append((Component)ChatFormatter.applyStyle(buffer, currentColor, customColor, bold, italic, underlined, strikethrough, obfuscated));
        }
        return result;
    }

    public static MutableComponent formatDisplayName(ServerPlayer player) {
        Component suffix;
        Component prefix;
        MutableComponent baseName;
        PlayerTeam team = player.getTeam();
        if (TabManager.isTabTeam(team)) {
            team = null;
        }
        if (!ChatFormatter.hasExplicitColor((Component)(baseName = ChatFormatter.sanitizeDisplayName(player)))) {
            TextColor fallbackColor = ChatFormatter.defaultNameColor();
            baseName = baseName.copy();
            if (team != null && team.getColor() != null) {
                ChatFormatting teamFormatting = team.getColor();
                baseName = baseName.withStyle(teamFormatting);
                TextColor teamColor = TextColor.fromLegacyFormat((ChatFormatting)teamFormatting);
                if (teamColor != null) {
                    fallbackColor = teamColor;
                }
            }
            baseName = ChatFormatter.applyDefaultColor(baseName, fallbackColor);
        } else {
            baseName = baseName.copy();
        }
        MutableComponent formatted = Component.empty();
        if (team != null && !ChatFormatter.isNullOrEmpty(prefix = team.getPlayerPrefix())) {
            formatted.append((Component)prefix.copy());
        }
        formatted.append((Component)baseName);
        if (team != null && !ChatFormatter.isNullOrEmpty(suffix = team.getPlayerSuffix())) {
            formatted.append((Component)suffix.copy());
        }
        return formatted;
    }

    private static MutableComponent decorateWithLuckPermsMeta(ServerPlayer player, MutableComponent baseName) {
        Component parsedSuffix;
        Component parsedPrefix;
        MutableComponent decorated = Component.empty();
        String prefix = LuckPermsMetaUtil.getPrefix(player);
        if (prefix != null && !prefix.isBlank() && !ChatFormatter.isComponentEmpty(parsedPrefix = ChatFormatter.legacyToComponent(prefix))) {
            decorated.append((Component)parsedPrefix.copy());
            if (!ChatFormatter.componentEndsWithWhitespace((Component)decorated) && !ChatFormatter.hasTrailingWhitespace(prefix)) {
                decorated.append((Component)SPACE.copy());
            }
        }
        decorated.append((Component)baseName);
        String suffix = LuckPermsMetaUtil.getSuffix(player);
        if (suffix != null && !suffix.isBlank() && !ChatFormatter.isComponentEmpty(parsedSuffix = ChatFormatter.legacyToComponent(suffix))) {
            if (!ChatFormatter.componentEndsWithWhitespace((Component)decorated) && !ChatFormatter.hasLeadingWhitespace(suffix)) {
                decorated.append((Component)SPACE.copy());
            }
            decorated.append((Component)parsedSuffix.copy());
        }
        return decorated;
    }

    private static MutableComponent formatChatMessage(PlayerList playerList, String raw, boolean allowColors, boolean allowFormats) {
        Map<String, ServerPlayer> mentionTargets = ChatFormatter.buildMentionTargets(playerList);
        MutableComponent message = ChatFormatter.parseMessage(raw, allowColors, allowFormats, mentionTargets).copy();
        if (!ChatFormatter.hasExplicitColor((Component)message)) {
            message = ChatFormatter.applyDefaultColor(message, ChatFormatter.defaultMessageColor());
        }
        return message;
    }

    private static TextColor defaultNameColor() {
        return TextColor.fromRgb((int)ModConfig.get().defaultNameColor());
    }

    private static TextColor defaultMessageColor() {
        return TextColor.fromRgb((int)ModConfig.get().defaultMessageColor());
    }

    private static MutableComponent applyDefaultColor(MutableComponent component, TextColor color) {
        if (color == null) {
            return component;
        }
        component.withStyle(style -> style.withColor(color));
        for (int i = 0; i < component.getSiblings().size(); ++i) {
            Component sibling = (Component)component.getSiblings().get(i);
            MutableComponent tintedSibling = sibling.copy();
            ChatFormatter.applyDefaultColor(tintedSibling, color);
            component.getSiblings().set(i, tintedSibling);
        }
        return component;
    }

    private static boolean hasExplicitColor(Component component) {
        if (component == null) {
            return false;
        }
        if (component.getStyle().getColor() != null) {
            return true;
        }
        return component.visit((style, text) -> {
            if (style != null && style.getColor() != null) {
                return Optional.of(Boolean.TRUE);
            }
            return Optional.empty();
        }, Style.EMPTY).orElse(Boolean.FALSE);
    }

    private static boolean isNullOrEmpty(Component component) {
        return component == null || component.getString().isEmpty() && component.getSiblings().isEmpty();
    }

    private static boolean hasLeadingWhitespace(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        return Character.isWhitespace(value.charAt(0));
    }

    private static boolean hasTrailingWhitespace(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        return Character.isWhitespace(value.charAt(value.length() - 1));
    }

    private static boolean componentEndsWithWhitespace(Component component) {
        if (component == null) {
            return false;
        }
        String value = component.getString();
        return !value.isEmpty() && Character.isWhitespace(value.charAt(value.length() - 1));
    }

    private static boolean isComponentEmpty(Component component) {
        return component == null || component.getString().isEmpty() && component.getSiblings().isEmpty();
    }

    private static MutableComponent nicknameComponent(String nickname) {
        Component parsed = ChatFormatter.legacyToComponent(nickname);
        if (parsed != null) {
            return parsed.copy();
        }
        return Component.literal((String)nickname);
    }

    private static MutableComponent applyStyle(StringBuilder buffer, ChatFormatting color, Integer customColor, boolean bold, boolean italic, boolean underlined, boolean strikethrough, boolean obfuscated) {
        MutableComponent component = Component.literal((String)buffer.toString());
        return component.withStyle(style -> {
            if (customColor != null) {
                style = style.withColor(customColor.intValue());
            } else if (color != null) {
                style = style.withColor(color);
            }
            if (bold) {
                style = style.withBold(Boolean.valueOf(true));
            }
            if (italic) {
                style = style.withItalic(Boolean.valueOf(true));
            }
            if (underlined) {
                style = style.withUnderlined(Boolean.valueOf(true));
            }
            if (strikethrough) {
                style = style.withStrikethrough(Boolean.valueOf(true));
            }
            if (obfuscated) {
                style = style.withObfuscated(Boolean.valueOf(true));
            }
            return style;
        });
    }

    private static Map<String, ServerPlayer> buildMentionTargets(PlayerList playerList) {
        if (playerList == null) {
            return Collections.emptyMap();
        }
        HashMap<String, ServerPlayer> mentions = new HashMap<String, ServerPlayer>();
        for (ServerPlayer candidate : playerList.getPlayers()) {
            ChatFormatter.addMentionTarget(mentions, candidate.getScoreboardName(), candidate);
            ChatFormatter.addMentionTarget(mentions, candidate.getName().getString(), candidate);
            MutableComponent sanitized = ChatFormatter.sanitizeDisplayName(candidate);
            ChatFormatter.addMentionTarget(mentions, sanitized.getString(), candidate);
        }
        return mentions;
    }

    private static void addMentionTarget(Map<String, ServerPlayer> mentions, String value, ServerPlayer player) {
        String normalized = ChatFormatter.normalizeMentionKey(value);
        if (!normalized.isEmpty()) {
            mentions.putIfAbsent(normalized, player);
        }
    }

    private static String normalizeMentionKey(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char character = value.charAt(i);
            if (!ChatFormatter.isMentionPart(character)) continue;
            builder.append(Character.toLowerCase(character));
        }
        return builder.toString();
    }

    private static boolean isMentionStart(String value, int index) {
        char previous;
        if (index < 0 || index >= value.length()) {
            return false;
        }
        return index <= 0 || !ChatFormatter.isMentionPart(previous = value.charAt(index - 1));
    }

    private static MentionCandidate extractMention(String value, int start) {
        int index;
        for (index = start; index < value.length() && ChatFormatter.isMentionPart(value.charAt(index)); ++index) {
        }
        if (index == start) {
            return null;
        }
        int length = index - start;
        if (length < 3 || length > 32) {
            return null;
        }
        String token = value.substring(start, index);
        return new MentionCandidate(token, index);
    }

    private static boolean isMentionPart(char character) {
        return Character.isLetterOrDigit(character) || character == '_';
    }

    private static MutableComponent buildMentionComponent(ServerPlayer player) {
        MutableComponent baseName = ChatFormatter.sanitizeDisplayName(player);
        baseName = !ChatFormatter.hasExplicitColor((Component)baseName) ? ChatFormatter.applyDefaultColor(baseName.copy(), ChatFormatter.defaultNameColor()) : baseName.copy();
        MutableComponent decorated = ChatFormatter.decorateWithLuckPermsMeta(player, baseName);
        MutableComponent mention = Component.empty();
        mention.append((Component)Component.literal((String)"@"));
        mention.append((Component)decorated);
        return mention;
    }

    private record MentionCandidate(String token, int endIndex) {
    }
}

