/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.command.util.CommandUtil;
import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.Date;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;

public final class BanCommand {
    private static final SimpleCommandExceptionType NO_TARGETS = new SimpleCommandExceptionType((Message)Localization.formatted("commands.foundryx.ban.none"));

    private BanCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ban").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_BAN))).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)GameProfileArgument.gameProfile()).executes(context -> BanCommand.ban((CommandContext<CommandSourceStack>)context, null))).then(Commands.argument((String)"reason", (ArgumentType)MessageArgument.message()).executes(context -> BanCommand.ban((CommandContext<CommandSourceStack>)context, MessageArgument.getMessage((CommandContext)context, (String)"reason"))))));
    }

    private static int ban(CommandContext<CommandSourceStack> context, Component reason) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection targets = GameProfileArgument.getGameProfiles(context, (String)"targets");
        UserBanList banList = source.getServer().getPlayerList().getBans();
        int bannedCount = 0;
        for (NameAndId target : targets) {
            ServerPlayer online;
            NameAndId normalized = target.id() != null ? target : NameAndId.createOffline((String)target.name());
            if (banList.isBanned(normalized)) continue;
            ServerPlayer serverPlayer = online = normalized.id() != null ? source.getServer().getPlayerList().getPlayer(normalized.id()) : source.getServer().getPlayerList().getPlayerByName(normalized.name());
            if (online != null) {
                try {
                    CommandUtil.ensureCanAffect(source, online, FoundryxPermission.COMMAND_BAN_EXEMPT, FoundryxPermission.COMMAND_BAN_FORCE);
                }
                catch (CommandSyntaxException exception) {
                    if (targets.size() != 1) continue;
                    throw exception;
                }
            }
            String reasonText = reason == null ? null : reason.getString();
            banList.add(new UserBanListEntry(normalized, new Date(), source.getTextName(), null, reasonText));
            if (online != null) {
                MutableComponent kickMessage = reason == null ? Localization.formatted("commands.foundryx.ban.disconnect") : Localization.formatted("commands.foundryx.ban.disconnect.reason", reason);
                online.connection.disconnect((Component)kickMessage);
            }
            MutableComponent displayName = Component.literal((String)target.name());
            MutableComponent success = reason == null ? Localization.formatted("commands.foundryx.ban.success", displayName) : Localization.formatted("commands.foundryx.ban.success.reason", displayName, reason);
            source.sendSuccess(() -> BanCommand.lambda$ban$3((Component)success), true);
            CommandUtil.notify(source, (Component)(reason == null ? Localization.formatted("commands.foundryx.ban.notify", source.getDisplayName(), displayName) : Localization.formatted("commands.foundryx.ban.notify.reason", source.getDisplayName(), displayName, reason)), FoundryxPermission.COMMAND_BAN_NOTIFY);
            ++bannedCount;
        }
        if (bannedCount == 0) {
            throw NO_TARGETS.create();
        }
        return bannedCount;
    }

    private static /* synthetic */ Component lambda$ban$3(Component success) {
        return success;
    }
}

