/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.data.BanData;
import com.foundryx.localization.Localization;
import com.foundryx.managers.BanDataManager;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.foundryx.storage.FoundryxDataStorage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.IpBanListEntry;
import net.minecraft.server.players.PlayerList;

public final class BanIpCommand {
    private static final Pattern IP_PATTERN = Pattern.compile("^\\d{1,3}(?:\\.\\d{1,3}){3}$");
    private static final SimpleCommandExceptionType INVALID_IP = new SimpleCommandExceptionType((Message)Localization.formatted("commands.foundryx.banip.invalid"));
    private static final DynamicCommandExceptionType UNKNOWN_TARGET = new DynamicCommandExceptionType(target -> Localization.formatted("commands.foundryx.banip.unknown", Component.literal((String)target.toString())));
    private static final DynamicCommandExceptionType ALREADY_BANNED = new DynamicCommandExceptionType(ip -> Localization.formatted("commands.foundryx.banip.already", Component.literal((String)ip.toString())));

    private BanIpCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ban-ip").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_BAN_IP))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)StringArgumentType.word()).executes(context -> BanIpCommand.ban((CommandContext<CommandSourceStack>)context, null))).then(Commands.argument((String)"reason", (ArgumentType)MessageArgument.message()).executes(context -> BanIpCommand.ban((CommandContext<CommandSourceStack>)context, MessageArgument.getMessage((CommandContext)context, (String)"reason"))))));
    }

    private static int ban(CommandContext<CommandSourceStack> context, Component reason) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        PlayerList playerList = source.getServer().getPlayerList();
        String target = StringArgumentType.getString(context, (String)"target");
        ResolvedAddress resolved = BanIpCommand.resolveIp(playerList, target);
        String ipAddress = resolved.ip();
        IpBanList banList = playerList.getIpBans();
        if (banList.isBanned(ipAddress)) {
            throw ALREADY_BANNED.create((Object)ipAddress);
        }
        String reasonText = reason == null ? null : reason.getString();
        banList.add(new IpBanListEntry(ipAddress, new Date(), source.getTextName(), null, reasonText));
        List players = playerList.getPlayers();
        MutableComponent disconnectMessage = reason == null ? Localization.formatted("commands.foundryx.banip.disconnect") : Localization.formatted("commands.foundryx.banip.disconnect.reason", reason);
        for (ServerPlayer player : players) {
            if (!ipAddress.equals(player.getIpAddress())) continue;
            player.connection.disconnect((Component)disconnectMessage);
        }
        String bannedBy = source.getTextName();
        BanDataManager manager = FoundryxDataStorage.get(source.getServer()).getBanDataManager();
        BanData banData = new BanData(null, ipAddress, resolved.nickname(), bannedBy, reasonText, Instant.now(), null);
        manager.addOrUpdate(banData);
        MutableComponent successMessage = reason == null ? Localization.formatted("commands.foundryx.banip.success", Component.literal((String)ipAddress)) : Localization.formatted("commands.foundryx.banip.success.reason", Component.literal((String)ipAddress), reason);
        source.sendSuccess(() -> BanIpCommand.lambda$ban$5((Component)successMessage), true);
        return 1;
    }

    private static ResolvedAddress resolveIp(PlayerList playerList, String input) throws CommandSyntaxException {
        if (IP_PATTERN.matcher(input).matches()) {
            BanIpCommand.validateIp(input);
            return new ResolvedAddress(input, null);
        }
        ServerPlayer player = playerList.getPlayerByName(input);
        if (player == null) {
            throw UNKNOWN_TARGET.create((Object)input);
        }
        String ipAddress = player.getIpAddress();
        if (!IP_PATTERN.matcher(ipAddress).matches()) {
            throw INVALID_IP.create();
        }
        BanIpCommand.validateIp(ipAddress);
        return new ResolvedAddress(ipAddress, player.getScoreboardName());
    }

    private static void validateIp(String address) throws CommandSyntaxException {
        String[] segments = address.split("\\.");
        if (segments.length != 4) {
            throw INVALID_IP.create();
        }
        for (String segment : segments) {
            try {
                int value = Integer.parseInt(segment);
                if (value >= 0 && value <= 255) continue;
                throw INVALID_IP.create();
            }
            catch (NumberFormatException exception) {
                throw INVALID_IP.create();
            }
        }
    }

    private static /* synthetic */ Component lambda$ban$5(Component successMessage) {
        return successMessage;
    }

    private record ResolvedAddress(String ip, String nickname) {
    }
}

