/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.data.BanData;
import com.foundryx.localization.Localization;
import com.foundryx.managers.BanDataManager;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.foundryx.storage.FoundryxDataStorage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class BanListCommand {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm", Locale.ROOT).withZone(ZoneId.systemDefault());

    private BanListCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"banlist").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_BANLIST))).executes(BanListCommand::showPlayers)).then(Commands.literal((String)"players").executes(BanListCommand::showPlayers))).then(Commands.literal((String)"ips").executes(BanListCommand::showIps)));
    }

    private static int showPlayers(CommandContext<CommandSourceStack> context) {
        BanDataManager manager = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer()).getBanDataManager();
        List entries = manager.getAll().stream().filter(BanData::isPlayerBan).sorted(Comparator.comparing(BanListCommand::displayName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.banlist.players", entries.size()), false);
        for (BanData entry : entries) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> BanListCommand.formatEntry(entry), false);
        }
        return entries.size();
    }

    private static int showIps(CommandContext<CommandSourceStack> context) {
        BanDataManager manager = FoundryxDataStorage.get(((CommandSourceStack)context.getSource()).getServer()).getBanDataManager();
        List entries = manager.getAll().stream().filter(BanData::isIpBan).sorted(Comparator.comparing(ban -> ban.getIpAddress().orElse(""), String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.banlist.ips", entries.size()), false);
        for (BanData entry : entries) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> BanListCommand.formatIpEntry(entry), false);
        }
        return entries.size();
    }

    private static Component formatEntry(BanData banData) {
        MutableComponent name = Component.literal((String)BanListCommand.displayName(banData));
        Component identifier = (Component)banData.getPlayerUuid().map(uuid -> Component.literal((String)uuid.toString())).orElseGet(() -> banData.getIpAddress().map(Component::literal).orElse(Component.empty()));
        MutableComponent byClause = Localization.formatted("commands.foundryx.banlist.entry.by", BanListCommand.operatorComponent(banData.getBannedBy()));
        MutableComponent dateClause = Localization.formatted("commands.foundryx.banlist.entry.on", Component.literal((String)DATE_FORMATTER.format(banData.getBanDate())));
        Component expiryClause = BanListCommand.expiryComponent(banData);
        Component reasonClause = BanListCommand.reasonComponent(banData);
        return Localization.formatted("commands.foundryx.banlist.entry", name, identifier, byClause, dateClause, expiryClause, reasonClause);
    }

    private static Component formatIpEntry(BanData banData) {
        MutableComponent ip = Component.literal((String)banData.getIpAddress().orElse("?"));
        MutableComponent byClause = Localization.formatted("commands.foundryx.banlist.entry.by", BanListCommand.operatorComponent(banData.getBannedBy()));
        MutableComponent dateClause = Localization.formatted("commands.foundryx.banlist.entry.on", Component.literal((String)DATE_FORMATTER.format(banData.getBanDate())));
        Component expiryClause = BanListCommand.expiryComponent(banData);
        Component reasonClause = BanListCommand.reasonComponent(banData);
        return Localization.formatted("commands.foundryx.banlist.entry.ip", ip, byClause, dateClause, expiryClause, reasonClause);
    }

    private static String displayName(BanData banData) {
        String nickname = banData.getNickname();
        if (nickname != null && !nickname.isBlank()) {
            return nickname;
        }
        return banData.getPlayerUuid().map(UUID::toString).orElse(banData.getIpAddress().orElse(""));
    }

    private static Component operatorComponent(String operator) {
        if (operator == null || operator.isBlank()) {
            return Localization.formatted("commands.foundryx.banlist.entry.server");
        }
        return Component.literal((String)operator);
    }

    private static Component expiryComponent(BanData banData) {
        if (banData.isPermanent()) {
            return Localization.formatted("commands.foundryx.banlist.entry.permanent");
        }
        return (Component)banData.getUnbanDate().map(date -> Localization.formatted("commands.foundryx.banlist.entry.expires", Component.literal((String)DATE_FORMATTER.format((TemporalAccessor)date)))).orElse(Component.empty());
    }

    private static Component reasonComponent(BanData banData) {
        String reason = banData.getReason();
        if (reason == null || reason.isBlank()) {
            return Component.empty();
        }
        return Localization.formatted("commands.foundryx.banlist.entry.reason", Component.literal((String)reason));
    }
}

