/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public final class ClearChatCommand {
    private static final int CLEAR_LINES = 100;

    private ClearChatCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register(ClearChatCommand.buildLiteral("clearchat"));
        dispatcher.register(ClearChatCommand.buildLiteral("cc"));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildLiteral(String literal) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)literal).requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_CLEAR_CHAT))).executes(ClearChatCommand::clearChat);
    }

    private static int clearChat(CommandContext<CommandSourceStack> context) {
        MutableComponent mutableComponent;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MinecraftServer server = source.getServer();
        if (server == null) {
            return 0;
        }
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            mutableComponent = Localization.formatted("commands.foundryx.clearchat.broadcast", player.getDisplayName());
        } else {
            mutableComponent = Localization.formatted("commands.foundryx.clearchat.broadcast.console");
        }
        MutableComponent broadcast = mutableComponent;
        for (ServerPlayer viewer : server.getPlayerList().getPlayers()) {
            for (int index = 0; index < 100; ++index) {
                viewer.sendSystemMessage((Component)Component.literal((String)" "));
            }
            viewer.sendSystemMessage((Component)broadcast.copy());
        }
        source.sendSuccess(() -> Localization.formatted("commands.foundryx.clearchat.success"), true);
        server.sendSystemMessage((Component)broadcast.copy());
        return 1;
    }
}

