/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.command.util.CommandUtil;
import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public final class ClearCommand {
    private ClearCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"clear").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_CLEAR_INVENTORY))).executes(ClearCommand::clearSelf)).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> ClearCommand.clear((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayer((CommandContext)context, (String)"target")))));
    }

    private static int clearSelf(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return ClearCommand.clear(context, ((CommandSourceStack)context.getSource()).getPlayerOrException());
    }

    private static int clear(CommandContext<CommandSourceStack> context, ServerPlayer target) throws CommandSyntaxException {
        ServerPlayer executor;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        CommandUtil.ensureCanAffect(source, target, FoundryxPermission.COMMAND_CLEAR_INVENTORY_EXEMPT, FoundryxPermission.COMMAND_CLEAR_INVENTORY_FORCE);
        target.getInventory().clearContent();
        target.getInventory().setChanged();
        target.inventoryMenu.broadcastChanges();
        target.containerMenu.broadcastChanges();
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer && (executor = (ServerPlayer)entity).getUUID().equals(target.getUUID())) {
            MutableComponent message = Localization.formatted("commands.foundryx.clear.self");
            source.sendSuccess(() -> message, true);
            return 1;
        }
        MutableComponent success = Localization.formatted("commands.foundryx.clear.success", target.getName());
        source.sendSuccess(() -> success, true);
        target.sendSystemMessage((Component)Localization.formatted("commands.foundryx.clear.notice", source.getDisplayName()));
        CommandUtil.notify(source, (Component)Localization.formatted("commands.foundryx.clear.notify", source.getDisplayName(), target.getName()), FoundryxPermission.COMMAND_CLEAR_INVENTORY_NOTIFY);
        return 1;
    }
}

