/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.command.admin;

import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Abilities;

public final class FlyCommand {
    private FlyCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"fly").requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_FLY))).executes(context -> FlyCommand.toggleFlight((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).getPlayerOrException(), null))).then(((RequiredArgumentBuilder)Commands.argument((String)"state", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.suggest((String[])new String[]{"on", "off"}, (SuggestionsBuilder)builder)).executes(context -> FlyCommand.toggleFlight((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).getPlayerOrException(), StringArgumentType.getString((CommandContext)context, (String)"state")))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_FLY_OTHERS))).executes(context -> FlyCommand.toggleFlight((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayer((CommandContext)context, (String)"target"), StringArgumentType.getString((CommandContext)context, (String)"state")))))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).requires(source -> FoundryxPermissions.check(source, FoundryxPermission.COMMAND_FLY_OTHERS))).executes(context -> FlyCommand.toggleFlight((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayer((CommandContext)context, (String)"target"), null))));
    }

    private static int toggleFlight(CommandContext<CommandSourceStack> context, ServerPlayer target, String desiredState) throws CommandSyntaxException {
        ServerPlayer executor;
        boolean self;
        boolean enable = desiredState == null ? !target.getAbilities().mayfly || !target.getAbilities().flying : desiredState.equalsIgnoreCase("on");
        Abilities abilities = target.getAbilities();
        abilities.mayfly = enable;
        if (!enable) {
            abilities.flying = false;
        }
        target.onUpdateAbilities();
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        boolean bl = self = entity instanceof ServerPlayer && (executor = (ServerPlayer)entity).getUUID().equals(target.getUUID());
        if (enable) {
            if (self) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.fly.enabled"), true);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.fly.enabled.other", target.getName()), true);
                target.sendSystemMessage((Component)Localization.formatted("commands.foundryx.fly.enabled"));
            }
        } else if (self) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.fly.disabled"), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Localization.formatted("commands.foundryx.fly.disabled.other", target.getName()), true);
            target.sendSystemMessage((Component)Localization.formatted("commands.foundryx.fly.disabled"));
        }
        return 1;
    }
}

